/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.maven.plugins;

import java.net.URL;
import liquibase.sdk.github.GitHubClient;
import liquibase.sdk.maven.plugins.AbstractGitHubMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.kohsuke.github.GHAsset;
import org.kohsuke.github.GHRelease;

@Mojo(name="install-release", requiresProject=false)
public class InstallReleaseMojo
extends AbstractGitHubMojo {
    @Parameter(property="liquibase.sdk.releaseTag", required=true)
    protected String releaseTag;

    public void execute() throws MojoExecutionException, MojoFailureException {
        for (String repo : this.getRepos()) {
            if (repo.equals("liquibase/liquibase-pro")) {
                this.log.debug("Nothing to install from liquibase-pro");
                continue;
            }
            this.log.info("Installing release from " + repo);
            try {
                GitHubClient github = new GitHubClient(this.githubToken, this.log);
                GHRelease release = github.getRelease(repo, this.releaseTag);
                for (GHAsset asset : release.listAssets()) {
                    if (!asset.getName().endsWith(".jar")) {
                        this.log.debug("Not installing " + asset.getName());
                        continue;
                    }
                    this.log.info("Installing " + asset.getName() + "...");
                    this.installToMavenCache(github.downloadArtifact(new URL(asset.getBrowserDownloadUrl())));
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
    }
}

