/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.maven.plugins;

import java.io.File;
import java.net.URL;
import liquibase.sdk.github.GitHubClient;
import liquibase.sdk.maven.plugins.AbstractGitHubMojo;
import liquibase.sdk.util.ArchiveUtil;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.kohsuke.github.GHAsset;
import org.kohsuke.github.GHRelease;

@Mojo(name="install-release-cli", requiresProject=false)
public class InstallReleaseCliMojo
extends AbstractGitHubMojo {
    @Parameter(property="liquibase.sdk.releaseTag", required=true)
    protected String releaseTag;
    @Parameter(property="liquibase.sdk.liquibaseHome", required=true)
    protected String liquibaseHome;
    @Parameter(property="liquibase.sdk.allowInstall", defaultValue="false")
    protected boolean allowInstall;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File liquibaseHomeDir = new File(this.liquibaseHome);
        if (liquibaseHomeDir.exists()) {
            if (!liquibaseHomeDir.isDirectory()) {
                throw new MojoFailureException("LiquibaseHome " + this.liquibaseHome + " is not a directory");
            }
            if (!new File(liquibaseHomeDir, "liquibase.bat").exists()) {
                throw new MojoFailureException("LiquibaseHome " + this.liquibaseHome + " is not a liquibase home");
            }
        } else if (this.allowInstall) {
            this.log.info("LiquibaseHome " + this.liquibaseHome + " does not exist. Installing new version");
            liquibaseHomeDir.mkdirs();
        } else {
            throw new MojoFailureException("LiquibaseHome " + this.liquibaseHome + " does not exist. To install to a new directory, set allowInstall=true");
        }
        if (this.releaseTag.matches("\\d\\.\\d\\.\\d")) {
            this.releaseTag = "v" + this.releaseTag;
        }
        String version = this.releaseTag.replaceFirst("^v", "");
        for (String repo : this.getRepos()) {
            if (repo.equals("liquibase/eliquibase-pro")) {
                this.log.debug("Nothing to install from liquibase-pro");
                continue;
            }
            try {
                GitHubClient github = new GitHubClient(this.githubToken, this.log);
                GHRelease release = github.getRelease(repo, this.releaseTag);
                if (release == null) {
                    throw new MojoFailureException("Cannot find release " + this.releaseTag + " in " + repo);
                }
                String wantedAsset = "liquibase-" + version + ".zip";
                GHAsset zipAsset = null;
                for (GHAsset asset : release.listAssets()) {
                    if (asset.getName().equals(wantedAsset)) {
                        zipAsset = asset;
                        continue;
                    }
                    this.log.debug("Not installing " + asset.getName());
                }
                if (zipAsset == null) {
                    throw new MojoFailureException("Could not find " + wantedAsset);
                }
                File file = github.downloadArtifact(new URL(zipAsset.getBrowserDownloadUrl()));
                ArchiveUtil.unzipCli(file, liquibaseHomeDir, this.log, null, null);
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
    }
}

