/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.maven.plugins;

import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import liquibase.sdk.github.GitHubClient;
import liquibase.sdk.maven.plugins.AbstractGitHubMojo;
import liquibase.sdk.util.ArchiveUtil;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.kohsuke.github.GHAsset;
import org.kohsuke.github.GHRelease;

@Mojo(name="download-release-artifacts", requiresProject=false)
public class DownloadReleaseArtifactsMojo
extends AbstractGitHubMojo {
    @Parameter(property="liquibase.sdk.releaseTag", required=true)
    protected String releaseTag;
    @Parameter(property="liquibase.sdk.artifactPattern", required=true)
    protected String artifactPattern;
    @Parameter(property="liquibase.sdk.downloadDirectory", required=true)
    protected String downloadDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File downloadDirectory = new File(this.downloadDirectory);
        downloadDirectory.mkdirs();
        int downloaded = 0;
        if (this.releaseTag.matches("\\d\\.\\d\\.\\d")) {
            this.releaseTag = "v" + this.releaseTag;
        }
        for (String repo : this.getRepos()) {
            if (repo.equals("liquibase/liquibase-pro")) {
                this.log.debug("No releases in liquibase-pro");
                continue;
            }
            try {
                GitHubClient github = new GitHubClient(this.githubToken, this.log);
                GHRelease release = github.getRelease(repo, this.releaseTag);
                if (release == null) {
                    throw new MojoFailureException("Cannot find release " + this.releaseTag + " in " + repo);
                }
                for (GHAsset asset : release.listAssets()) {
                    if (ArchiveUtil.filenameMatches(asset.getName(), this.artifactPattern)) {
                        Path finalPath = new File(downloadDirectory, asset.getName()).toPath().normalize().toAbsolutePath();
                        this.log.info("Downloading " + finalPath + "...");
                        URL url = new URL(asset.getBrowserDownloadUrl());
                        File tempFile = github.downloadArtifact(url);
                        Files.move(tempFile.toPath(), finalPath, StandardCopyOption.REPLACE_EXISTING);
                        ++downloaded;
                        continue;
                    }
                    this.log.debug("Not downloading " + asset.getName());
                }
            }
            catch (MojoFailureException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        if (downloaded == 0) {
            throw new MojoFailureException("Did not find any matching artifacts");
        }
    }
}

