/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.maven.plugins;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import liquibase.sdk.util.GPGUtil;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="create-release-artifacts", requiresProject=false)
public class CreateReleaseArtifactsMojo
extends AbstractMojo {
    @Parameter(property="liquibase.sdk.inputDirectory", required=true)
    protected String inputDirectory;
    @Parameter(property="liquibase.sdk.outputDirectory", required=true)
    protected String outputDirectory;
    @Parameter(property="liquibase.sdk.newVersion", required=true)
    protected String newVersion;
    @Parameter(property="liquibase.sdk.repo", required=true)
    protected String repo;
    @Parameter(property="liquibase.sdk.gpgExecutable")
    protected String gpgExecutable;
    @Parameter(property="liquibase.sdk.reversion.requireCaseSensitiveFilesystem", defaultValue="true")
    protected boolean requireCaseSensitiveFilesystem;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.repo.contains(",")) {
            throw new MojoFailureException("Goal does not support multiple repos");
        }
        if (this.repo.contains("/")) {
            this.repo = this.repo.split("/")[1];
        }
        if (this.newVersion.startsWith("v")) {
            this.newVersion = this.newVersion.substring(1);
        }
        try {
            File inputDirectory = new File(this.inputDirectory);
            if (!inputDirectory.exists()) {
                throw new MojoFailureException("inputDirectory " + inputDirectory.getAbsolutePath() + " does not exist");
            }
            File outputDirectory = new File(this.outputDirectory);
            outputDirectory.mkdirs();
            if (this.requireCaseSensitiveFilesystem) {
                CreateReleaseArtifactsMojo.checkFileSystemCaseSensitivity();
            }
            File[] inputJarFiles = inputDirectory.listFiles(pathname -> pathname.getName().endsWith(".jar") && pathname.getName().contains("0-SNAPSHOT"));
            int fixedFiles = 0;
            for (File inputFile : inputJarFiles) {
                ++fixedFiles;
                File outputFile = new File(outputDirectory, inputFile.getName().replace("0-SNAPSHOT", this.newVersion));
                File workDir = File.createTempFile("liquibase-reversion-workdir-", ".dir");
                workDir.delete();
                workDir.mkdirs();
                this.getLog().info((CharSequence)("Re-versioning " + inputFile.getAbsolutePath() + " to " + outputFile.getAbsolutePath()));
                HashMap<String, FileTime> lastModified = new HashMap<String, FileTime>();
                this.extractAndFixJars(outputDirectory, inputFile, outputFile, workDir, lastModified);
                CreateReleaseArtifactsMojo.rebuildJars(outputFile, workDir, lastModified);
                this.cleanupWorkDir(workDir);
                this.signFiles(outputDirectory);
            }
            if (fixedFiles == 0) {
                throw new MojoFailureException("Found no files to release");
            }
            this.createAdditionalZip(outputDirectory);
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void createAdditionalZip(File outputDirectory) throws IOException {
        File additionalFileObj = new File(outputDirectory, this.repo + "-additional-" + this.newVersion + ".zip");
        this.getLog().info((CharSequence)("Creating " + additionalFileObj.getAbsolutePath() + "..."));
        try (JarOutputStream additionalFiles = new JarOutputStream(Files.newOutputStream(additionalFileObj.toPath(), new OpenOption[0]));){
            for (File file : outputDirectory.listFiles()) {
                if (!file.getName().contains("-sources") && !file.getName().contains("-javadoc") && !file.getName().endsWith(".asc") && !file.getName().endsWith(".md5") && !file.getName().endsWith(".sha1") && !file.getName().endsWith(".pom")) continue;
                ZipEntry entry = new ZipEntry(file.getName());
                ((ZipOutputStream)additionalFiles).putNextEntry(entry);
                try (InputStream fileContent = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                    IOUtils.copy((InputStream)fileContent, (OutputStream)additionalFiles);
                }
                additionalFiles.closeEntry();
                file.delete();
            }
        }
    }

    private static void rebuildJars(File outputFile, File workDir, final Map<String, FileTime> lastModified) throws IOException {
        final Path workdirPath = workDir.toPath();
        try (InputStream manifestStream = Files.newInputStream(workdirPath.resolve("META-INF/MANIFEST.MF"), new OpenOption[0]);){
            Manifest manifest = new Manifest(manifestStream);
            try (final JarOutputStream target = new JarOutputStream(Files.newOutputStream(outputFile.toPath(), new OpenOption[0]), manifest);){
                Files.walkFileTree(workdirPath, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        if (dir.equals(workdirPath)) {
                            return FileVisitResult.CONTINUE;
                        }
                        String entryName = workdirPath.relativize(dir).toString().replace("\\", "/");
                        FileTime fileModified = (FileTime)lastModified.get(entryName);
                        if (fileModified == null) {
                            fileModified = (FileTime)lastModified.get(entryName + "/");
                        }
                        if (fileModified == null) {
                            fileModified = FileTime.fromMillis(new Date().getTime());
                        }
                        if (!entryName.endsWith("/")) {
                            entryName = entryName + "/";
                        }
                        JarEntry entry = new JarEntry(entryName);
                        entry.setTime(fileModified.toMillis());
                        target.putNextEntry(entry);
                        target.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (file.toString().endsWith("MANIFEST.MF")) {
                            return FileVisitResult.CONTINUE;
                        }
                        String entryName = workdirPath.relativize(file).toString().replace("\\", "/");
                        JarEntry entry = new JarEntry(entryName);
                        FileTime fileModified = (FileTime)lastModified.get(entryName);
                        if (fileModified == null) {
                            fileModified = FileTime.fromMillis(new Date().getTime());
                        }
                        entry.setTime(fileModified.toMillis());
                        target.putNextEntry(entry);
                        try (InputStream fileContent = Files.newInputStream(file, new OpenOption[0]);){
                            IOUtils.copy((InputStream)fileContent, (OutputStream)target);
                        }
                        target.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                        throw exc;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
    }

    private void extractAndFixJars(File outputDirectory, File inputFile, File outputFile, File workDir, Map<String, FileTime> lastModified) throws IOException, MojoFailureException {
        try (ZipFile zipFile = new ZipFile(inputFile);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                lastModified.put(entry.getName().replace("\\", "/"), entry.getLastModifiedTime());
                if (entry.isDirectory()) continue;
                File outFile = new File(workDir, entry.getName());
                outFile.getParentFile().mkdirs();
                try (InputStream in = zipFile.getInputStream(entry);
                     OutputStream out = Files.newOutputStream(outFile.toPath(), new OpenOption[0]);){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                if (entry.getName().equals("META-INF/MANIFEST.MF")) {
                    this.fixManifest(outFile);
                } else if (entry.getName().endsWith("/pom.xml") || entry.getName().endsWith("/pom.properties") || entry.getName().matches("/plugin.*\\.xml") || entry.getName().endsWith(".html") || entry.getName().endsWith(".xml")) {
                    this.simpleSnapshotReplace(outFile);
                } else if (entry.getName().endsWith("liquibase.build.properties")) {
                    this.fixBuildProperties(outFile);
                }
                this.checkForSnapshot(outFile);
                if (!entry.getName().endsWith("/pom.xml") || inputFile.getName().contains("-javadoc-") || inputFile.getName().contains("-sources-")) continue;
                String outputPomName = outputFile.getName().replace(".jar", ".pom");
                this.getLog().info((CharSequence)("Extracting " + outputPomName));
                Files.copy(outFile.toPath(), Paths.get(outputDirectory.getAbsolutePath(), outputPomName), StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private void signFiles(File outputDirectory) throws IOException {
        File[] filesToSign = outputDirectory.listFiles(pathname -> !pathname.getName().endsWith(".md5") && !pathname.getName().endsWith(".sha1") && !pathname.getName().endsWith(".asc"));
        if (filesToSign == null) {
            throw new IOException("Cannot list files in " + outputDirectory.getAbsolutePath());
        }
        for (File file : filesToSign) {
            try (InputStream content = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                File md5File = new File(file.getAbsoluteFile() + ".md5");
                FileUtils.write((File)md5File, (CharSequence)DigestUtils.md5Hex((InputStream)content), (Charset)StandardCharsets.UTF_8);
                this.getLog().info((CharSequence)("Created " + md5File));
            }
            content = Files.newInputStream(file.toPath(), new OpenOption[0]);
            var8_8 = null;
            try {
                File sha1File = new File(file.getAbsoluteFile() + ".sha1");
                FileUtils.write((File)sha1File, (CharSequence)DigestUtils.sha1Hex((InputStream)content), (Charset)StandardCharsets.UTF_8);
                this.getLog().info((CharSequence)("Created " + sha1File));
            }
            catch (Throwable throwable) {
                var8_8 = throwable;
                throw throwable;
            }
            finally {
                if (content != null) {
                    if (var8_8 != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable) {
                            var8_8.addSuppressed(throwable);
                        }
                    } else {
                        content.close();
                    }
                }
            }
            this.getLog().info((CharSequence)("Signing " + file.getAbsolutePath()));
            GPGUtil.sign(file.getAbsolutePath(), this.gpgExecutable);
        }
    }

    private void checkForSnapshot(File outFile) throws IOException, MojoFailureException {
        try (InputStream input = Files.newInputStream(outFile.toPath(), new OpenOption[0]);){
            String content = IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
            if (content.contains("0-SNAPSHOT")) {
                throw new MojoFailureException(outFile.getAbsolutePath() + " still contains 0-SNAPSHOT");
            }
            if (content.contains("0.0.0.SNAPSHOT")) {
                throw new MojoFailureException(outFile.getAbsolutePath() + " still contains 0.0.0.SNAPSHOT");
            }
        }
    }

    private void simpleSnapshotReplace(File outFile) throws IOException {
        try (InputStream input = Files.newInputStream(outFile.toPath(), new OpenOption[0]);){
            String content = IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
            content = content.replaceAll("([^.])0-SNAPSHOT", "$1" + this.newVersion);
            FileUtils.write((File)outFile, (CharSequence)content, (Charset)StandardCharsets.UTF_8);
        }
    }

    private void fixBuildProperties(File outFile) throws IOException {
        try (InputStream input = Files.newInputStream(outFile.toPath(), new OpenOption[0]);){
            String content = IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
            content = content.replaceAll("build.version=.*", "build.version=" + this.newVersion);
            FileUtils.write((File)outFile, (CharSequence)content, (Charset)StandardCharsets.UTF_8);
        }
    }

    private void fixManifest(File outFile) throws IOException {
        String exportPackage;
        String importPackage;
        Manifest manifest;
        try (InputStream input = Files.newInputStream(outFile.toPath(), new OpenOption[0]);){
            manifest = new Manifest(input);
        }
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Liquibase-Version", this.newVersion);
        String bundleVersion = attributes.getValue("Bundle-Version");
        if (bundleVersion != null) {
            attributes.putValue("Bundle-Version", this.newVersion);
        }
        if ((importPackage = attributes.getValue("Import-Package")) != null) {
            attributes.putValue("Import-Package", importPackage.replaceAll("version=\"\\[0\\.0,1\\)\"", "version=\"" + this.newVersion + "\""));
        }
        if ((exportPackage = attributes.getValue("Export-Package")) != null) {
            attributes.putValue("Export-Package", exportPackage.replaceAll(";version=\"0\\.0\\.0\"", ";version=\"" + this.newVersion + "\""));
        }
        try (OutputStream out = Files.newOutputStream(outFile.toPath(), new OpenOption[0]);){
            manifest.write(out);
        }
    }

    private void cleanupWorkDir(File workDir) {
        try {
            FileUtils.deleteDirectory((File)workDir);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Cannot delete " + workDir));
        }
    }

    private static void checkFileSystemCaseSensitivity() throws MojoExecutionException, IOException {
        File tempFile = File.createTempFile("liquibase-case-test-", ".TMP");
        tempFile.deleteOnExit();
        File otherCaseFile = new File(tempFile.getAbsolutePath().replace(".TMP", ".tmp"));
        if (otherCaseFile.exists()) {
            throw new MojoExecutionException("reversion-jar requires a case sensitive filesystem");
        }
    }
}

