/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.maven.plugins;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import liquibase.sdk.github.GitHubClient;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.twdata.maven.mojoexecutor.MojoExecutor;

abstract class AbstractGitHubMojo
extends AbstractMojo {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Component
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;
    @Parameter(property="liquibase.sdk.github.token")
    protected String githubToken;
    @Parameter(property="liquibase.sdk.repo", defaultValue="liquibase/liquibase")
    protected String repo;

    protected GitHubClient createGitHubClient() throws IOException {
        return new GitHubClient(this.githubToken, this.log);
    }

    protected List<String> getRepos() {
        ArrayList<String> returnList = new ArrayList<String>();
        for (String name : this.repo.split(",")) {
            if (!name.contains("/")) {
                name = "liquibase/" + name;
            }
            returnList.add(name);
        }
        return returnList;
    }

    protected String getRepo() {
        List<String> repos = this.getRepos();
        if (repos.size() > 1) {
            throw new IllegalArgumentException("Goal does not support multiple repos");
        }
        return repos.get(0);
    }

    protected void installToMavenCache(File entryFile) throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-install-plugin"), (String)MojoExecutor.version((String)"3.0.0-M1")), (String)MojoExecutor.goal((String)"install-file"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"file"), (String)entryFile.getAbsolutePath())}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
    }
}

