/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.statement;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import liquibase.ext.mongodb.statement.AbstractRunCommandStatement;
import liquibase.ext.mongodb.statement.BsonUtils;
import lombok.Generated;
import org.bson.Document;

public class InsertManyStatement
extends AbstractRunCommandStatement {
    public static final String RUN_COMMAND_NAME = "insert";
    public static final String DOCUMENTS = "documents";

    @Override
    public String getRunCommandName() {
        return RUN_COMMAND_NAME;
    }

    public InsertManyStatement(String collectionName, String documents, String options) {
        this(collectionName, new ArrayList<Document>(BsonUtils.orEmptyList(documents)), BsonUtils.orEmptyDocument(options));
    }

    public InsertManyStatement(String collectionName, List<Document> documents, Document options) {
        super(BsonUtils.toCommand(RUN_COMMAND_NAME, collectionName, InsertManyStatement.combine(documents, options)));
    }

    public InsertManyStatement(String collectionName, List<Document> documents) {
        this(collectionName, documents, new Document());
    }

    private static Document combine(List<Document> documents, Document options) {
        Document combined = new Document(DOCUMENTS, documents);
        if (Objects.nonNull(options)) {
            combined.putAll(options);
        }
        return combined;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InsertManyStatement)) {
            return false;
        }
        InsertManyStatement other = (InsertManyStatement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InsertManyStatement;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

