/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.precondition;

import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.database.Database;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.ext.mongodb.statement.BsonUtils;
import liquibase.ext.mongodb.statement.CountDocumentsInCollectionStatement;
import liquibase.precondition.AbstractPrecondition;
import liquibase.precondition.Precondition;
import lombok.Generated;
import org.bson.Document;

public class DocumentExistsPrecondition
extends AbstractPrecondition {
    private String collectionName;
    private String filter;

    public String getName() {
        return "documentExists";
    }

    public Warnings warn(Database database) {
        return new Warnings();
    }

    public ValidationErrors validate(Database database) {
        return new ValidationErrors();
    }

    public void check(Database database, DatabaseChangeLog changeLog, ChangeSet changeSet, ChangeExecListener changeExecListener) throws PreconditionFailedException, PreconditionErrorException {
        try {
            Document bsonFilter = BsonUtils.orEmptyDocument(this.filter);
            CountDocumentsInCollectionStatement countDocumentsInCollectionStatement = new CountDocumentsInCollectionStatement(this.collectionName, bsonFilter);
            if (countDocumentsInCollectionStatement.queryForLong((MongoLiquibaseDatabase)database) <= 0L) {
                throw new PreconditionFailedException(String.format("Document does not exist in collection %s", this.collectionName), changeLog, (Precondition)this);
            }
        }
        catch (PreconditionFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PreconditionErrorException(e, changeLog, (Precondition)this);
        }
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog-ext";
    }

    @Generated
    public String getCollectionName() {
        return this.collectionName;
    }

    @Generated
    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    @Generated
    public String getFilter() {
        return this.filter;
    }

    @Generated
    public void setFilter(String filter) {
        this.filter = filter;
    }
}

