/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.changelog;

import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import liquibase.ContextExpression;
import liquibase.Labels;
import liquibase.change.CheckSum;
import liquibase.changelog.ChangeSet;
import liquibase.ext.mongodb.changelog.MongoRanChangeSet;
import liquibase.nosql.changelog.AbstractNoSqlItemToDocumentConverter;
import org.bson.Document;

public class MongoRanChangeSetToDocumentConverter
extends AbstractNoSqlItemToDocumentConverter<MongoRanChangeSet, Document> {
    @Override
    public Document toDocument(MongoRanChangeSet item) {
        Document document = new Document();
        document.append("fileName", item.getChangeLog());
        document.append("id", item.getId());
        document.append("author", item.getAuthor());
        document.append("md5sum", Optional.ofNullable(item.getLastCheckSum()).map(CheckSum::toString).orElse(null));
        document.append("dateExecuted", Optional.ofNullable(item.getDateExecuted()).orElse(null));
        document.append("tag", item.getTag());
        document.append("execType", Optional.ofNullable(item.getExecType()).map(e -> e.value).orElse(null));
        document.append("description", item.getDescription());
        document.append("comments", item.getComments());
        document.append("contexts", this.buildFullContext(item.getContextExpression(), item.getInheritableContexts()));
        document.append("labels", this.buildLabels(item.getLabels()));
        document.append("deploymentId", item.getDeploymentId());
        document.append("orderExecuted", item.getOrderExecuted());
        document.append("liquibase", item.getLiquibaseVersion());
        return document;
    }

    @Override
    public MongoRanChangeSet fromDocument(Document document) {
        return new MongoRanChangeSet((String)document.get("fileName"), (String)document.get("id"), (String)document.get("author"), CheckSum.parse((String)((String)document.get("md5sum"))), (Date)document.get("dateExecuted"), (String)document.get("tag"), Optional.ofNullable(document.get("execType")).map(s -> ChangeSet.ExecType.valueOf((String)((String)s))).orElse(null), (String)document.get("description"), (String)document.get("comments"), new ContextExpression((String)document.get("contexts")), null, new Labels((String)document.get("labels")), (String)document.get("deploymentId"), Optional.ofNullable(document.get("orderExecuted")).orElse(null), (String)document.get("liquibase"));
    }

    @Override
    public String buildLabels(Labels labels) {
        if (labels == null || labels.isEmpty()) {
            return null;
        }
        return labels.toString();
    }

    @Override
    public String buildFullContext(ContextExpression contextExpression, Collection<ContextExpression> inheritableContexts) {
        if (contextExpression == null || contextExpression.isEmpty()) {
            return null;
        }
        StringBuilder contextExpressionString = new StringBuilder();
        boolean notFirstContext = false;
        for (ContextExpression inheritableContext : inheritableContexts) {
            this.appendContext(contextExpressionString, inheritableContext.toString(), notFirstContext);
            notFirstContext = true;
        }
        this.appendContext(contextExpressionString, contextExpression.toString(), notFirstContext);
        return contextExpressionString.toString();
    }

    private void appendContext(StringBuilder contextExpression, String contextToAppend, boolean notFirstContext) {
        boolean complexExpression;
        boolean bl = complexExpression = contextToAppend.contains(",") || contextToAppend.contains(" ");
        if (notFirstContext) {
            contextExpression.append(" AND ");
        }
        if (complexExpression) {
            contextExpression.append("(");
        }
        contextExpression.append(contextToAppend);
        if (complexExpression) {
            contextExpression.append(")");
        }
    }
}

