/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.change;

import liquibase.change.CheckSum;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.mongodb.change.AbstractMongoChange;
import liquibase.ext.mongodb.statement.InsertOneStatement;
import liquibase.statement.SqlStatement;
import lombok.Generated;

@DatabaseChange(name="insertOne", description="Insert a Single Document https://docs.mongodb.com/manual/tutorial/insert-documents/#insert-a-single-document", priority=1, appliesTo={"collection"})
public class InsertOneChange
extends AbstractMongoChange {
    private String collectionName;
    private String document;
    private String options;

    public String getConfirmationMessage() {
        return "Document inserted into collection " + this.getCollectionName();
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new InsertOneStatement(this.collectionName, this.document, this.options)};
    }

    public CheckSum generateCheckSum() {
        return super.generateCheckSum(this.collectionName, this.document, this.options);
    }

    @Generated
    public InsertOneChange() {
    }

    @Generated
    public String getCollectionName() {
        return this.collectionName;
    }

    @Generated
    public String getDocument() {
        return this.document;
    }

    @Generated
    public String getOptions() {
        return this.options;
    }

    @Generated
    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    @Generated
    public void setDocument(String document) {
        this.document = document;
    }

    @Generated
    public void setOptions(String options) {
        this.options = options;
    }
}

