/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.change;

import liquibase.change.CheckSum;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.mongodb.change.AbstractMongoChange;
import liquibase.ext.mongodb.statement.AdminCommandStatement;
import liquibase.statement.SqlStatement;
import lombok.Generated;

@DatabaseChange(name="adminCommand", description="Provides a helper to run specified database commands against the admin database. https://docs.mongodb.com/manual/reference/method/db.adminCommand/#db.adminCommand", priority=1, appliesTo={"admin"})
public class AdminCommandChange
extends AbstractMongoChange {
    private String command;

    public String getConfirmationMessage() {
        return "Admin Command run";
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new AdminCommandStatement(this.command)};
    }

    public CheckSum generateCheckSum() {
        return super.generateCheckSum(this.command);
    }

    @Generated
    public AdminCommandChange() {
    }

    @Generated
    public String getCommand() {
        return this.command;
    }

    @Generated
    public void setCommand(String command) {
        this.command = command;
    }
}

