/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.Function;
import com.mongodb.MongoException;
import com.mongodb.MongoExecutionTimeoutException;
import com.mongodb.MongoNodeIsRecoveringException;
import com.mongodb.MongoNotPrimaryException;
import com.mongodb.MongoSocketException;
import com.mongodb.MongoTimeoutException;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.WriteConcern;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.TransactionOperation;
import com.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;

public class CommitTransactionOperation
extends TransactionOperation {
    private final boolean alreadyCommitted;
    private BsonDocument recoveryToken;
    private static final List<Integer> NON_RETRYABLE_WRITE_CONCERN_ERROR_CODES = Arrays.asList(79, 100);

    public CommitTransactionOperation(WriteConcern writeConcern) {
        this(writeConcern, false);
    }

    public CommitTransactionOperation(WriteConcern writeConcern, boolean alreadyCommitted) {
        super(writeConcern);
        this.alreadyCommitted = alreadyCommitted;
    }

    public CommitTransactionOperation recoveryToken(@Nullable BsonDocument recoveryToken) {
        this.recoveryToken = recoveryToken;
        return this;
    }

    @Override
    public Void execute(WriteBinding binding) {
        try {
            return super.execute(binding);
        }
        catch (MongoException e) {
            this.addErrorLabels(e);
            throw e;
        }
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<Void> callback) {
        super.executeAsync(binding, (Void result, Throwable t) -> {
            if (t instanceof MongoException) {
                this.addErrorLabels((MongoException)t);
            }
            callback.onResult((Void)result, t);
        });
    }

    private void addErrorLabels(MongoException e) {
        if (CommitTransactionOperation.shouldAddUnknownTransactionCommitResultLabel(e)) {
            e.addLabel("UnknownTransactionCommitResult");
        }
    }

    private static boolean shouldAddUnknownTransactionCommitResultLabel(MongoException e) {
        if (e instanceof MongoSocketException || e instanceof MongoTimeoutException || e instanceof MongoNotPrimaryException || e instanceof MongoNodeIsRecoveringException || e instanceof MongoExecutionTimeoutException) {
            return true;
        }
        if (e.hasErrorLabel("RetryableWriteError")) {
            return true;
        }
        if (e instanceof MongoWriteConcernException) {
            return !NON_RETRYABLE_WRITE_CONCERN_ERROR_CODES.contains(e.getCode());
        }
        return false;
    }

    @Override
    protected String getCommandName() {
        return "commitTransaction";
    }

    @Override
    CommandOperationHelper.CommandCreator getCommandCreator() {
        CommandOperationHelper.CommandCreator creator = (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument command = CommitTransactionOperation.super.getCommandCreator().create(operationContext, serverDescription, connectionDescription);
            operationContext.getTimeoutContext().setMaxTimeOverrideToMaxCommitTime();
            return command;
        };
        if (this.alreadyCommitted) {
            return (operationContext, serverDescription, connectionDescription) -> this.getRetryCommandModifier(operationContext.getTimeoutContext()).apply(creator.create(operationContext, serverDescription, connectionDescription));
        }
        if (this.recoveryToken != null) {
            return (operationContext, serverDescription, connectionDescription) -> creator.create(operationContext, serverDescription, connectionDescription).append("recoveryToken", this.recoveryToken);
        }
        return creator;
    }

    @Override
    protected Function<BsonDocument, BsonDocument> getRetryCommandModifier(TimeoutContext timeoutContext) {
        return command -> {
            WriteConcern retryWriteConcern = this.getWriteConcern().withW("majority");
            if (retryWriteConcern.getWTimeout(TimeUnit.MILLISECONDS) == null && !timeoutContext.hasTimeoutMS()) {
                retryWriteConcern = retryWriteConcern.withWTimeout(10000L, TimeUnit.MILLISECONDS);
            }
            command.put("writeConcern", retryWriteConcern.asDocument());
            if (this.recoveryToken != null) {
                command.put("recoveryToken", this.recoveryToken);
            }
            return command;
        };
    }
}

