/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.operation.BsonDocumentWrapperHelper;
import com.mongodb.lang.Nullable;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;

public class CommandCursorResult<T> {
    private static final String CURSOR = "cursor";
    private static final String POST_BATCH_RESUME_TOKEN = "postBatchResumeToken";
    private static final String OPERATION_TIME = "operationTime";
    private final ServerAddress serverAddress;
    private final List<T> results;
    private final MongoNamespace namespace;
    private final long cursorId;
    @Nullable
    private final BsonTimestamp operationTime;
    @Nullable
    private final BsonDocument postBatchResumeToken;

    public CommandCursorResult(ServerAddress serverAddress, String fieldNameContainingBatch, BsonDocument commandCursorDocument) {
        Assertions.isTrue("Contains cursor", commandCursorDocument.isDocument(CURSOR));
        this.serverAddress = serverAddress;
        BsonDocument cursorDocument = commandCursorDocument.getDocument(CURSOR);
        this.results = BsonDocumentWrapperHelper.toList(cursorDocument, fieldNameContainingBatch);
        this.namespace = new MongoNamespace(cursorDocument.getString("ns").getValue());
        this.cursorId = cursorDocument.getNumber("id").longValue();
        this.operationTime = cursorDocument.getTimestamp(OPERATION_TIME, null);
        this.postBatchResumeToken = cursorDocument.getDocument(POST_BATCH_RESUME_TOKEN, null);
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    @Nullable
    public ServerCursor getServerCursor() {
        return this.cursorId == 0L ? null : new ServerCursor(this.cursorId, this.serverAddress);
    }

    public List<T> getResults() {
        return this.results;
    }

    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    public long getCursorId() {
        return this.cursorId;
    }

    @Nullable
    public BsonDocument getPostBatchResumeToken() {
        return this.postBatchResumeToken;
    }

    @Nullable
    public BsonTimestamp getOperationTime() {
        return this.operationTime;
    }
}

