/*
 * Decompiled with CFR 0.152.
 */
package com.liquibase.ext.tools;

import com.datical.liquibase.ext.tools.AbstractNativeToolExecutor;
import com.liquibase.ext.change.MongoshChange;
import com.liquibase.ext.change.MongoshFileChange;
import com.liquibase.ext.config.OIDCMongoConfiguration;
import com.liquibase.ext.statement.MongoshStatement;
import com.liquibase.ext.tools.MongoshRunner;
import java.util.List;
import java.util.ResourceBundle;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.change.core.EmptyChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.ValidationErrors;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;

public class MongoshExecutor
extends AbstractNativeToolExecutor {
    private static final ResourceBundle mongoshBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-mongosh");
    protected static final String MSG_UNABLE_TO_VALIDATE_CHANGE_SET = mongoshBundle.getString("unable.to.validate.changeset");
    private static final String AUTHENTICATION_MECHANISM = (String)OIDCMongoConfiguration.AUTHENTICATION_MECHANISM.getCurrentValue();
    protected static final String MSG_OIDC_AUTHENTICATION_METHOD_NOT_SUPPORTED = mongoshBundle.getString("oidc.authentication.method.are.not.supported");
    private static final String name = "mongosh";

    public MongoshExecutor() {
        super(name);
    }

    public String getName() {
        return name;
    }

    public int getPriority() {
        return 10;
    }

    public boolean supports(Database database) {
        return database instanceof MongoLiquibaseDatabase;
    }

    protected void validateChange(ChangeSet object, ValidationErrors validationErrors, Change change, String string) {
        if ("MONGODB-OIDC".equalsIgnoreCase(AUTHENTICATION_MECHANISM)) {
            object = String.format(MSG_OIDC_AUTHENTICATION_METHOD_NOT_SUPPORTED, string, name, "mongo", "mongoFile");
            validationErrors.addError((String)object);
            return;
        }
        if (!(change instanceof MongoshChange || change instanceof MongoshFileChange || change instanceof EmptyChange)) {
            object = "In changeset '" + object.getId() + "::" + object.getAuthor() + "' there is an unsupported change type '" + change.toString() + "'";
            object = String.format(MSG_UNABLE_TO_VALIDATE_CHANGE_SET, object, string, name, "mongo", "mongoFile");
            validationErrors.addError((String)object);
        }
    }

    public void execute(SqlStatement sqlArray, List<SqlVisitor> logger) {
        logger = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        if (!(sqlArray instanceof MongoshStatement)) {
            logger.warning("statement should be type or subtype of MongoshStatement, but is " + String.valueOf(sqlArray.getClass()) + ". Learn more at https://docs.liquibase.com/mongodb");
        }
        logger.info("Executing with the '" + this.getName() + "' executor");
        sqlArray = SqlGeneratorFactory.getInstance().generateSql((SqlStatement)sqlArray, this.database);
        try {
            MongoshRunner mongoshRunner = new MongoshRunner(this.changeSet, null);
            mongoshRunner.executeCommand(this.database);
            logger.info("Successfully validated mongosh");
            mongoshRunner = new MongoshRunner(this.changeSet, sqlArray);
            mongoshRunner.executeCommand(this.database);
            logger.info(String.format("Success! Changeset '%s' by '%s' deployed by mongosh", this.changeSet.getId(), this.changeSet.getAuthor()));
            return;
        }
        catch (Exception exception) {
            logger.warning(String.format("%nChangeset '%s' by '%s' failed to deploy with 'mongosh'. Please check mongosh logs", this.changeSet.getId(), this.changeSet.getAuthor()) + ". Learn more at https://docs.liquibase.com/mongodb");
            throw new DatabaseException((Throwable)exception);
        }
    }
}

