/*
 * Decompiled with CFR 0.152.
 */
package com.liquibase.ext.snapshot.jvm;

import com.liquibase.ext.snapshot.jvm.AbstractMongoDbSnapshotGenerator;
import com.liquibase.ext.statement.ListCollectionStatement;
import com.liquibase.ext.structure.Collection;
import com.liquibase.ext.structure.NoSqlRelation;
import java.util.ArrayList;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.executor.ExecutorService;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.nosql.executor.NoSqlExecutor;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import org.apache.commons.lang3.ObjectUtils;
import org.bson.Document;

public class CollectionSnapshotGeneratorMongoDB
extends AbstractMongoDbSnapshotGenerator {
    public CollectionSnapshotGeneratorMongoDB() {
        super(Collection.class, new Class[]{Catalog.class});
    }

    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (database instanceof MongoLiquibaseDatabase) {
            return super.getPriority(clazz, database);
        }
        return -1;
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject databaseObject, DatabaseSnapshot databaseSnapshot) {
        if (ObjectUtils.allNotNull((Object[])new Object[]{databaseObject, databaseObject.getName()}) && databaseObject instanceof Collection) {
            return databaseObject;
        }
        throw new DatabaseException("Unexpected example of type " + (databaseObject == null ? "null" : databaseObject.getClass().getSimpleName()));
    }

    @Override
    protected void addTo(DatabaseObject databaseObject, DatabaseSnapshot object2) {
        if (!object2.getSnapshotControl().shouldInclude(Collection.class)) {
            return;
        }
        if (databaseObject instanceof Catalog) {
            Object object3 = object2.getDatabase();
            if (!(object3 instanceof MongoLiquibaseDatabase)) {
                return;
            }
            MongoLiquibaseDatabase mongoLiquibaseDatabase = (MongoLiquibaseDatabase)((Object)object3);
            databaseObject = (Catalog)databaseObject;
            try {
                object3 = (NoSqlExecutor)((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", (Database)object3);
                Object object4 = new ListCollectionStatement();
                object3 = ((NoSqlExecutor)((Object)object3)).queryForList((SqlStatement)object4, Document.class).stream().filter(Document.class::isInstance).map(Document.class::cast).collect(Collectors.toList());
                object2.setScratchData("All collections of " + databaseObject.getName(), object3);
                object2 = object3.stream().filter(object -> {
                    String string = ((Document)object).getString("name");
                    object = ((Document)object).get("type");
                    return string != null && !string.startsWith("system.") && (object == null || !"view".equals(object.toString()));
                }).collect(Collectors.toList());
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    object3 = (Document)object2.next();
                    object4 = ((Document)object3).getString("name");
                    object4 = mongoLiquibaseDatabase.getMongoDatabase().getCollection((String)object4);
                    object4 = object4.listIndexes().into(new ArrayList());
                    ((Document)object3).append("indexes", object4);
                    object4 = new Collection();
                    ((NoSqlRelation)((Object)object4)).setName(((String)((Object)((Document)object3).get((Object)"name", String.class))).trim());
                    ((NoSqlRelation)((Object)object4)).setCatalog((Catalog)databaseObject);
                    databaseObject.addDatabaseObject((DatabaseObject)object4);
                    ((NoSqlRelation)((Object)object4)).setCatalog((Catalog)databaseObject);
                }
                return;
            }
            catch (DatabaseException databaseException) {
                throw new DatabaseException((Throwable)databaseException);
            }
        }
    }
}

