/*
 * Decompiled with CFR 0.152.
 */
package com.liquibase.ext.snapshot.jvm;

import com.liquibase.ext.snapshot.jvm.AbstractMongoDbSnapshotGenerator;
import java.sql.SQLException;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.snapshot.jvm.CatalogSnapshotGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;

public class CatalogSnapshotGeneratorMongoDb
extends AbstractMongoDbSnapshotGenerator {
    public CatalogSnapshotGeneratorMongoDb() {
        super(Catalog.class, null);
    }

    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (database instanceof MongoLiquibaseDatabase) {
            return super.getPriority(clazz, database) + 1;
        }
        return super.getPriority(clazz, database);
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject object, DatabaseSnapshot databaseSnapshot) {
        if (!(object instanceof Catalog)) {
            throw new UnexpectedLiquibaseException("Unexpected databaseObject type: " + object.getClass().getName());
        }
        databaseSnapshot = databaseSnapshot.getDatabase();
        String string = null;
        if ((object = object.getName()) == null && databaseSnapshot.supports(Catalog.class)) {
            object = databaseSnapshot.getDefaultCatalogName();
        }
        object = new Catalog((String)object);
        try {
            for (String string2 : this.getDatabaseCatalogNames((Database)databaseSnapshot)) {
                if ((string2 = new Catalog(string2)).getAttribute("name", String.class) != null && (string2.toString() == null || !string2.toString().equalsIgnoreCase(object.toString()))) continue;
                if (string == null) {
                    string = string2;
                    continue;
                }
                throw new InvalidExampleException("Found multiple catalogs matching " + object.getName());
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseException((Throwable)sQLException);
        }
        if (string != null && string.getName().equals(databaseSnapshot.getConnection().getCatalog())) {
            string.setDefault(Boolean.TRUE);
        }
        return string;
    }

    @Override
    protected void addTo(DatabaseObject databaseObject, DatabaseSnapshot databaseSnapshot) {
    }

    protected String[] getDatabaseCatalogNames(Database database) {
        if (database.getDatabaseProductName().equalsIgnoreCase("MongoDB")) {
            database = (MongoLiquibaseDatabase)database;
            return new String[]{database.getConnection().getCatalog()};
        }
        throw new DatabaseException("Unsupported database. Current snapshot generator is intended for MongoDB databases.");
    }

    @Override
    public Class<? extends SnapshotGenerator>[] replaces() {
        return new Class[]{CatalogSnapshotGenerator.class};
    }
}

