/*
 * Decompiled with CFR 0.152.
 */
package com.liquibase.ext.parser;

import java.io.IOException;
import java.util.ResourceBundle;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.ChangeLogParseException;
import liquibase.parser.ChangeLogParser;
import liquibase.resource.ResourceAccessor;
import liquibase.util.FileUtil;

public class JavaScriptMongoshChangeLogParser
implements ChangeLogParser {
    private static final ResourceBundle mongoshBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-mongosh");
    private static final String CHANGELOG_IS_NOT_SUPPORTED = mongoshBundle.getString("changelog.is.not.supported");

    public boolean supports(String string, ResourceAccessor resourceAccessor) {
        return string.toLowerCase().endsWith(".js");
    }

    public int getPriority() {
        return 1;
    }

    public DatabaseChangeLog parse(String string, ChangeLogParameters changeLogParameters, ResourceAccessor resourceAccessor) {
        try {
            changeLogParameters = resourceAccessor.get(string);
            if (!changeLogParameters.exists()) {
                throw new ChangeLogParseException(FileUtil.getFileNotFoundMessage((String)string));
            }
        }
        catch (IOException iOException) {
            throw new ChangeLogParseException((Throwable)iOException);
        }
        throw new ChangeLogParseException(String.format(CHANGELOG_IS_NOT_SUPPORTED, string, "1", "// liquibase formatted mongo"));
    }
}

