/*
 * Decompiled with CFR 0.152.
 */
package com.liquibase.ext.parser;

import com.liquibase.ext.change.MongoshChange;
import com.liquibase.ext.change.MongoshFileChange;
import java.util.ResourceBundle;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.ChangeLogParseException;
import liquibase.util.StringUtil;

class ChangeLogErrorHandler {
    private static final ResourceBundle mongoshBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-mongosh");
    private static final String CHANGELOG_ATTRIBUTE_IS_MISSING = mongoshBundle.getString("changelog.attribute.is.missing");
    private static final String CHANGELOG_ATTRIBUTE_IS_NOT_CORRECT = mongoshBundle.getString("changelog.runwith.attribute.is.not.correct");

    private ChangeLogErrorHandler() {
    }

    public static DatabaseChangeLog parse(DatabaseChangeLog databaseChangeLog, String string, String string2) {
        if (Scope.getCurrentScope().has("modifyChangeSets")) {
            return databaseChangeLog;
        }
        for (ChangeSet changeSet : databaseChangeLog.getChangeSets()) {
            for (Change change : changeSet.getChanges()) {
                if (!(change instanceof MongoshChange) && !(change instanceof MongoshFileChange)) continue;
                if (StringUtil.isEmpty((String)changeSet.getRunWith())) {
                    throw new ChangeLogParseException(String.format(CHANGELOG_ATTRIBUTE_IS_MISSING, string, changeSet.getAuthor(), changeSet.getId(), string2));
                }
                if (changeSet.getRunWith().equalsIgnoreCase("mongosh")) continue;
                throw new ChangeLogParseException(String.format(CHANGELOG_ATTRIBUTE_IS_NOT_CORRECT, string, changeSet.getAuthor(), changeSet.getId(), ChangeLogErrorHandler.getChangelogSpecificElementSyntax(changeSet.getRunWith(), string2), string2));
            }
        }
        return databaseChangeLog;
    }

    private static String getChangelogSpecificElementSyntax(String string, String string2) {
        return string2.replace("mongosh", string);
    }
}

