/*
 * Decompiled with CFR 0.152.
 */
package com.liquibase.ext.mongodb.database;

import com.liquibase.ext.config.OIDCMongoConfiguration;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.client.MongoClients;
import java.sql.Driver;
import java.util.Properties;
import liquibase.Scope;
import liquibase.exception.DatabaseException;
import liquibase.ext.mongodb.database.MongoConnection;
import liquibase.ext.mongodb.statement.BsonUtils;
import liquibase.license.LicenseServiceUtils;

public class OIDCMongoConnectionWrapper
extends MongoConnection {
    private static final String OIDC_FEATURE_NAME = "MongoDB OIDC Authentication";
    private static final String FEATURE_NAME = "MongoDB Commercial Extension";

    @Override
    public void open(String string, Driver object, Properties properties) {
        try {
            String string2 = (String)OIDCMongoConfiguration.AUTHENTICATION_MECHANISM.getCurrentValue();
            String string3 = (String)OIDCMongoConfiguration.OIDC_APPLICATION_ID_URI.getCurrentValue();
            String string4 = (String)OIDCMongoConfiguration.ENVIRONMENT.getCurrentValue();
            String string5 = (String)OIDCMongoConfiguration.OIDC_CLIENT_ID.getCurrentValue();
            properties.put("appName", this.getAppName(properties, LicenseServiceUtils.isProLicenseValid()));
            LicenseServiceUtils.checkProLicenseAndThrowException((String[])new String[]{this.isOIDCAuthentication(string2) ? OIDC_FEATURE_NAME : FEATURE_NAME});
            if (this.isOIDCAuthentication(string2)) {
                this.validateOIDCParameters(string3, string4);
                this.setConnectionString(new ConnectionString(string));
                string = this.getConnectionString().getDatabase();
                if (string == null) {
                    throw new IllegalArgumentException("Database not specified in URL");
                }
            } else {
                super.open(string, (Driver)object, properties);
                return;
            }
            object = MongoCredential.createOidcCredential(string5).withMechanismProperty("ENVIRONMENT", string4).withMechanismProperty("TOKEN_RESOURCE", string3);
            object = MongoClientSettings.builder().applyConnectionString(this.getConnectionString()).credential((MongoCredential)object).build();
            this.setMongoClient(MongoClients.create((MongoClientSettings)object));
            OIDCMongoConnectionWrapper oIDCMongoConnectionWrapper = this;
            oIDCMongoConnectionWrapper.setMongoDatabase(oIDCMongoConnectionWrapper.getMongoClient().getDatabase(string).withCodecRegistry(BsonUtils.uuidCodecRegistry()));
            Scope.getCurrentScope().getLog(this.getClass()).info("Successfully established OIDC connection");
        }
        catch (Exception exception) {
            throw new DatabaseException("Failed to open connection: " + exception.getMessage(), (Throwable)exception);
        }
    }

    private boolean isOIDCAuthentication(String string) {
        return "MONGODB-OIDC".equalsIgnoreCase(string);
    }

    private void validateOIDCParameters(String string, String string2) {
        if (string == null || string.isEmpty()) {
            throw new DatabaseException("OIDC Application ID URI is required when using MONGODB-OIDC authentication");
        }
        if (!"azure".equalsIgnoreCase(string2)) {
            throw new DatabaseException("Environment must be 'azure' when using MONGODB-OIDC authentication");
        }
    }
}

