/*
 * Decompiled with CFR 0.152.
 */
package com.liquibase.ext.history;

import com.datical.liquibase.ext.config.DatabaseChangelogHistoryConfiguration;
import com.datical.liquibase.ext.history.DatabaseChangeLogHistoryEntry;
import com.datical.liquibase.ext.history.DatabaseChangeLogHistoryServiceFactory;
import com.datical.liquibase.ext.history.StandardDatabaseChangeLogHistoryService;
import com.liquibase.ext.history.DatabaseChangeLogHistoryEntryDocumentConverter;
import com.liquibase.ext.statement.AdjustChangeLogHistoryCollectionStatement;
import com.liquibase.ext.statement.CreateChangeLogHistoryCollectionStatement;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.command.CommandScope;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.ext.mongodb.statement.CountCollectionByNameStatement;
import liquibase.ext.mongodb.statement.FindAllStatement;
import liquibase.ext.mongodb.statement.InsertOneStatement;
import liquibase.nosql.executor.NoSqlExecutor;
import liquibase.snapshot.SnapshotControl;
import liquibase.statement.SqlStatement;
import org.bson.Document;

public class MongoDatabaseChangeLogHistoryService
extends StandardDatabaseChangeLogHistoryService {
    private static final ResourceBundle mongoBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-mongo");

    public int getPriority(Database database) {
        if (database instanceof MongoLiquibaseDatabase) {
            return 5;
        }
        return -1;
    }

    public void insertHistoryEntry(ChangeSet object, Database database, String string, CommandScope commandScope, AtomicBoolean atomicBoolean) {
        Object object2;
        DatabaseChangeLogHistoryServiceFactory databaseChangeLogHistoryServiceFactory = (DatabaseChangeLogHistoryServiceFactory)Scope.getCurrentScope().getSingleton(DatabaseChangeLogHistoryServiceFactory.class);
        databaseChangeLogHistoryServiceFactory = databaseChangeLogHistoryServiceFactory.getService(database);
        String string2 = DatabaseChangelogHistoryConfiguration.getTableName((Database)database);
        if (!atomicBoolean.get() && !this.historyTableExists(database)) {
            object2 = new CreateChangeLogHistoryCollectionStatement(string2);
            this.getExecutor(database).execute((SqlStatement)object2);
            this.getExecutor(database).execute((SqlStatement)new AdjustChangeLogHistoryCollectionStatement(string2));
            atomicBoolean.set(true);
            Scope.getCurrentScope().getUI().sendMessage("INFO: A new collection '" + string2 + "' was created to track database changing Liquibase operations. The Pro property 'liquibase.dbclhistory.enabled=true' was configured on the CLI, or as Environment Variable or defaults file property, etc. To pause collecting history, set to 'false'. Learn more at https://docs.liquibase.com/DATABASECHANGELOGHISTORY");
        }
        object2 = databaseChangeLogHistoryServiceFactory.buildEntry((ChangeSet)object, string, commandScope, database);
        object = new DatabaseChangeLogHistoryEntryDocumentConverter();
        this.getExecutor(database).execute((SqlStatement)new InsertOneStatement(string2, ((DatabaseChangeLogHistoryEntryDocumentConverter)object).toDocument((DatabaseChangeLogHistoryEntry)object2), new Document()));
    }

    public boolean historyTableExists(Database database) {
        return this.getExecutor(database).queryForLong((SqlStatement)new CountCollectionByNameStatement(DatabaseChangelogHistoryConfiguration.getTableName((Database)database))) == 1L;
    }

    public List<DatabaseChangeLogHistoryEntry> getHistoryEntries(Database database, boolean bl) {
        Document document = new Document();
        DatabaseChangeLogHistoryEntryDocumentConverter databaseChangeLogHistoryEntryDocumentConverter = new DatabaseChangeLogHistoryEntryDocumentConverter();
        try {
            return (List)Scope.child(Collections.singletonMap("verbose", bl), () -> this.getExecutor(database).queryForList((SqlStatement)new FindAllStatement(DatabaseChangelogHistoryConfiguration.getTableName((Database)database), document, null), Document.class).stream().map(Document.class::cast).map(databaseChangeLogHistoryEntryDocumentConverter::fromDocument).collect(Collectors.toList()));
        }
        catch (Exception exception) {
            throw new UnexpectedLiquibaseException((Throwable)exception);
        }
    }

    public SnapshotControl getSnapshotControl(Database database) {
        return null;
    }

    private NoSqlExecutor getExecutor(Database database) {
        database = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        if (database instanceof LoggingExecutor) {
            throw new DatabaseException(String.format(mongoBundle.getString("command.unsupported"), "*sql"));
        }
        return (NoSqlExecutor)database;
    }
}

