/*
 * Decompiled with CFR 0.152.
 */
package com.liquibase.ext.diff.compare;

import com.liquibase.ext.database.CommercialMongoLiquibaseDatabase;
import com.liquibase.ext.structure.Collection;
import java.util.Set;
import liquibase.database.Database;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.compare.DatabaseObjectComparator;
import liquibase.diff.compare.DatabaseObjectComparatorChain;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.diff.compare.core.DefaultDatabaseObjectComparator;
import liquibase.structure.DatabaseObject;

public class CollectionComparator
implements DatabaseObjectComparator {
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (database instanceof CommercialMongoLiquibaseDatabase && Collection.class.isAssignableFrom(clazz)) {
            return 5;
        }
        return -1;
    }

    public boolean isSameObject(DatabaseObject databaseObject, DatabaseObject databaseObject2, Database database, DatabaseObjectComparatorChain databaseObjectComparatorChain) {
        if (!(databaseObject instanceof Collection) || !(databaseObject2 instanceof Collection)) {
            return false;
        }
        Collection collection = (Collection)databaseObject;
        Collection collection2 = (Collection)databaseObject2;
        if (!DefaultDatabaseObjectComparator.nameMatches((DatabaseObject)databaseObject, (DatabaseObject)databaseObject2, (Database)database)) {
            return false;
        }
        return DatabaseObjectComparatorFactory.getInstance().isSameObject((DatabaseObject)collection.getCatalog(), (DatabaseObject)collection2.getCatalog(), databaseObjectComparatorChain.getSchemaComparisons(), database);
    }

    public String[] hash(DatabaseObject databaseObject, Database database, DatabaseObjectComparatorChain databaseObjectComparatorChain) {
        return databaseObjectComparatorChain.hash(databaseObject, database);
    }

    public ObjectDifferences findDifferences(DatabaseObject databaseObject, DatabaseObject databaseObject2, Database database, CompareControl compareControl, DatabaseObjectComparatorChain databaseObjectComparatorChain, Set<String> set) {
        set.add("name");
        set.add("catalog");
        set.add("documentSchema");
        set.add("indexes");
        set.add("validator");
        compareControl = databaseObjectComparatorChain.findDifferences(databaseObject, databaseObject2, database, compareControl, set);
        compareControl.compare("name", databaseObject, databaseObject2, (ObjectDifferences.CompareFunction)new ObjectDifferences.DatabaseObjectNameCompareFunction(Collection.class, database));
        return compareControl;
    }
}

