/*
 * Decompiled with CFR 0.152.
 */
package com.liquibase.ext.database;

import com.liquibase.ext.statement.ProDropAllCollectionsStatement;
import com.liquibase.ext.structure.Collection;
import com.liquibase.ext.structure.DocumentSchema;
import com.liquibase.ext.structure.MongoIndex;
import com.liquibase.ext.structure.MongoView;
import com.liquibase.ext.structure.Validator;
import java.util.Arrays;
import java.util.List;
import liquibase.CatalogAndSchema;
import liquibase.Scope;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.database.Database;
import liquibase.database.OfflineConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.ExecutorService;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.statement.SqlStatement;
import liquibase.structure.AbstractDatabaseObject;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;

public class CommercialMongoLiquibaseDatabase
extends MongoLiquibaseDatabase {
    private static final List<Class<? extends AbstractDatabaseObject>> SUPPORTED_OBJECTS = Arrays.asList(Catalog.class, Collection.class, MongoView.class, MongoIndex.class, Validator.class, DocumentSchema.class);

    @Override
    public int getPriority() {
        return 10;
    }

    public boolean supportsDatabaseChangeLogHistory() {
        return true;
    }

    @Override
    public void dropDatabaseObjects(CatalogAndSchema catalogAndSchema) {
        catalogAndSchema = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", (Database)this);
        ProDropAllCollectionsStatement proDropAllCollectionsStatement = new ProDropAllCollectionsStatement();
        catalogAndSchema.execute((SqlStatement)proDropAllCollectionsStatement);
        ((ChangeLogHistoryServiceFactory)Scope.getCurrentScope().getSingleton(ChangeLogHistoryServiceFactory.class)).getChangeLogService((Database)this).destroy();
    }

    public boolean supports(Class<? extends DatabaseObject> clazz) {
        return SUPPORTED_OBJECTS.contains(clazz);
    }

    @Override
    public String getDatabaseProductVersion() {
        if (this.getConnection() instanceof OfflineConnection) {
            try {
                return this.getConnection().getDatabaseProductVersion();
            }
            catch (DatabaseException databaseException) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Unable to determine mongo database version!", (Throwable)databaseException);
            }
        }
        return super.getDatabaseProductVersion();
    }
}

