/*
 * Decompiled with CFR 0.152.
 */
package com.liquibase.ext.config;

import liquibase.configuration.AutoloadedConfigurations;
import liquibase.configuration.ConfigurationDefinition;
import liquibase.configuration.ConfigurationValueObfuscator;

public class OIDCMongoConfiguration
implements AutoloadedConfigurations {
    public static final ConfigurationDefinition<String> OIDC_APPLICATION_ID_URI;
    public static final ConfigurationDefinition<String> AUTHENTICATION_MECHANISM;
    public static final ConfigurationDefinition<String> ENVIRONMENT;
    public static final ConfigurationDefinition<String> OIDC_CLIENT_ID;

    static {
        ConfigurationDefinition.Builder builder = new ConfigurationDefinition.Builder("liquibase.mongodb");
        OIDC_APPLICATION_ID_URI = builder.define("oidc.oidcApplicationIDURI", String.class).setDescription("Application ID URI used for OIDC authentication in cloud providers (Azure, GCP, etc). Example: 'api://8d719796-c744-4352-aab9-47a52c363907' for Azure").setValueObfuscator(ConfigurationValueObfuscator.STANDARD).build();
        AUTHENTICATION_MECHANISM = builder.define("authenticationMechanism", String.class).setDescription("Authentication mechanism for MongoDB (e.g., MONGODB-OIDC). See available options at: https://www.mongodb.com/docs/drivers/java/sync/current/fundamentals/enterprise-auth/#std-label-mongodb-oidc").build();
        ENVIRONMENT = builder.define("oidc.environment", String.class).setDescription("Cloud provider environment for OIDC authentication (e.g., azure, gcp)").build();
        OIDC_CLIENT_ID = builder.define("oidc.oidcClientID", String.class).setDescription("Client ID of the User Assigned Identity for OIDC authentication").setValueObfuscator(ConfigurationValueObfuscator.STANDARD).build();
    }
}

