/*
 * Decompiled with CFR 0.152.
 */
package com.liquibase.ext.change;

import com.liquibase.ext.statement.MongoshStatement;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.exception.SetupException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.util.ObjectUtil;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtil;
import lombok.Generated;

@DatabaseChange(name="mongoFile", description="sqlFile equivalent for mongo scripts", priority=1)
public class MongoshFileChange
extends AbstractSQLChange {
    public static final String CHANGE_NAME = "mongoFile";
    private String path;
    private Boolean relativeToChangelogFile;

    @DatabaseChangeProperty(description="The file path of the mongo commands to load", exampleValue="my/path/file.js", requiredForDatabase={"all"})
    public String getPath() {
        return this.path;
    }

    public void finishInitialization() {
        if (this.path == null) {
            throw new SetupException("<mongoFile> - No path specified. Learn more at https://docs.liquibase.com/mongodb");
        }
    }

    @DatabaseChangeProperty(exampleValue="utf8")
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getConfirmationMessage() {
        return "Mongosh commands in file " + this.path + " executed";
    }

    public InputStream openSqlStream() {
        return this.openNoSqlStream();
    }

    public InputStream openNoSqlStream() {
        if (this.path == null) {
            return null;
        }
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        if (((Boolean)ObjectUtil.defaultIfNull((Object)this.getRelativeToChangelogFile(), (Object)Boolean.FALSE)).booleanValue()) {
            return resourceAccessor.get(this.getChangeSet().getChangeLog().getPhysicalFilePath()).resolveSibling(this.path).openInputStream();
        }
        return resourceAccessor.getExisting(this.path).openInputStream();
    }

    public void setNoSql(String string) {
        if (this.getChangeSet() != null && this.getChangeSet().getChangeLogParameters() != null) {
            string = this.getChangeSet().getChangeLogParameters().expandExpressions(string, this.getChangeSet().getChangeLog());
        }
        super.setSql(string);
    }

    public ValidationErrors validate(Database database) {
        database = new ValidationErrors();
        if (StringUtil.trimToNull((String)this.getPath()) == null) {
            database.addError("'path' is required. Learn more at https://docs.liquibase.com/mongodb");
        }
        return database;
    }

    public SqlStatement[] generateStatements(Database object) {
        object = new ArrayList();
        String string = StringUtil.trimToNull((String)this.getSql());
        if (string == null) {
            return SqlStatement.EMPTY_SQL_STATEMENT;
        }
        object.add(new MongoshStatement(this.normalizeLineEndings(string), this.getEndDelimiter()));
        return object.toArray(SqlStatement.EMPTY_SQL_STATEMENT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @DatabaseChangeProperty(isChangeProperty=false)
    public String getSql() {
        Object object = super.getSql();
        if (object != null) return object;
        try {
            object = this.openSqlStream();
            if (object == null) {
                if (object == null) return null;
                ((InputStream)object).close();
                return null;
            }
            try {
                String string;
                String string2 = StreamUtil.readStreamAsString((InputStream)object, (String)this.getEncoding());
                if (this.getChangeSet() != null && (string = this.getChangeSet().getChangeLogParameters()) != null) {
                    string2 = string.expandExpressions(string2, this.getChangeSet().getChangeLog());
                }
                string = string2;
                return string;
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
        }
        catch (IOException iOException) {
            throw new UnexpectedLiquibaseException((Throwable)iOException);
        }
    }

    public void setSql(String string) {
        this.setNoSql(string);
    }

    @Generated
    public MongoshFileChange() {
    }

    @Generated
    public void setPath(String string) {
        this.path = string;
    }

    @Generated
    public void setRelativeToChangelogFile(Boolean bl) {
        this.relativeToChangelogFile = bl;
    }

    @Generated
    public Boolean getRelativeToChangelogFile() {
        return this.relativeToChangelogFile;
    }
}

