/*
 * Decompiled with CFR 0.152.
 */
package com.liquibase.ext.change;

import com.liquibase.ext.statement.MongoshStatement;
import java.util.ArrayList;
import liquibase.change.AbstractSQLChange;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.statement.SqlStatement;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@DatabaseChange(name="mongo", description="mongo", priority=1)
public class MongoshChange
extends AbstractSQLChange {
    public static final String CHANGE_NAME = "mongo";
    private String mongo;

    @DatabaseChangeProperty(serializationType=LiquibaseSerializable.SerializationType.DIRECT_VALUE)
    public String getMongo() {
        return this.mongo;
    }

    public void setMongo(String string) {
        this.mongo = string;
    }

    public String getConfirmationMessage() {
        return "Mongsh command executed";
    }

    public SqlStatement[] generateStatements(Database object) {
        object = new ArrayList();
        String string = this.getMongo() == null ? StringUtils.trimToNull((String)this.getSql()) : StringUtils.trimToNull((String)this.getMongo());
        if (string == null) {
            return SqlStatement.EMPTY_SQL_STATEMENT;
        }
        string = this.normalizeLineEndings(string);
        object.add(new MongoshStatement(string, this.getEndDelimiter()));
        return object.toArray(SqlStatement.EMPTY_SQL_STATEMENT);
    }

    public ValidationErrors validate(Database database) {
        database = new ValidationErrors();
        if (StringUtils.trimToNull((String)this.getSql()) == null && StringUtils.trimToNull((String)this.getMongo()) == null) {
            database.addError("command is required. Learn more at https://docs.liquibase.com/mongodb");
        }
        return database;
    }

    @Generated
    public MongoshChange() {
    }
}

