/*
 * Decompiled with CFR 0.152.
 */
package com.liquibase.ext.change;

import com.liquibase.ext.statement.MongoshStatement;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.changelog.ChangeLogParameters;
import liquibase.database.Database;
import liquibase.exception.SetupException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.util.ObjectUtil;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtil;

@DatabaseChange(name="mongoFile", description="sqlFile equivalent for mongo scripts", priority=1)
public class MongoshFileChange
extends AbstractSQLChange {
    public static final String CHANGE_NAME = "mongoFile";
    private String path;
    private Boolean relativeToChangelogFile;

    @DatabaseChangeProperty(description="The file path of the mongo commands to load", exampleValue="my/path/file.js", requiredForDatabase={"all"})
    public String getPath() {
        return this.path;
    }

    public void setPath(String fileName) {
        this.path = fileName;
    }

    public Boolean isRelativeToChangelogFile() {
        return this.relativeToChangelogFile;
    }

    public void finishInitialization() throws SetupException {
        if (this.path == null) {
            throw new SetupException("<mongoFile> - No path specified. Learn more at https://docs.liquibase.com/mongodb");
        }
    }

    @DatabaseChangeProperty(exampleValue="utf8")
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getConfirmationMessage() {
        return "Mongosh commands in file " + this.path + " executed";
    }

    public InputStream openSqlStream() throws IOException {
        return this.openNoSqlStream();
    }

    public InputStream openNoSqlStream() throws IOException {
        if (this.path == null) {
            return null;
        }
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        if (((Boolean)ObjectUtil.defaultIfNull((Object)this.isRelativeToChangelogFile(), (Object)false)).booleanValue()) {
            return resourceAccessor.get(this.getChangeSet().getChangeLog().getPhysicalFilePath()).resolveSibling(this.path).openInputStream();
        }
        return resourceAccessor.getExisting(this.path).openInputStream();
    }

    public void setNoSql(String sql) {
        if (this.getChangeSet() != null && this.getChangeSet().getChangeLogParameters() != null) {
            sql = this.getChangeSet().getChangeLogParameters().expandExpressions(sql, this.getChangeSet().getChangeLog());
        }
        super.setSql(sql);
    }

    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors = new ValidationErrors();
        if (StringUtil.trimToNull((String)this.getPath()) == null) {
            validationErrors.addError("'path' is required. Learn more at https://docs.liquibase.com/mongodb");
        }
        return validationErrors;
    }

    public SqlStatement[] generateStatements(Database database) {
        ArrayList<MongoshStatement> returnStatements = new ArrayList<MongoshStatement>();
        String sql = StringUtil.trimToNull((String)this.getSql());
        if (sql == null) {
            return SqlStatement.EMPTY_SQL_STATEMENT;
        }
        returnStatements.add(new MongoshStatement(this.normalizeLineEndings(sql), this.getEndDelimiter()));
        return returnStatements.toArray(SqlStatement.EMPTY_SQL_STATEMENT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @DatabaseChangeProperty(isChangeProperty=false)
    public String getSql() {
        String sql = super.getSql();
        if (sql != null) return sql;
        try (InputStream sqlStream = this.openSqlStream();){
            ChangeLogParameters parameters;
            if (sqlStream == null) {
                String string2 = null;
                return string2;
            }
            String content = StreamUtil.readStreamAsString((InputStream)sqlStream, (String)this.getEncoding());
            if (this.getChangeSet() != null && (parameters = this.getChangeSet().getChangeLogParameters()) != null) {
                content = parameters.expandExpressions(content, this.getChangeSet().getChangeLog());
            }
            String string = content;
            return string;
        }
        catch (IOException e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
    }

    public void setSql(String sql) {
        this.setNoSql(sql);
    }

    public Boolean getRelativeToChangelogFile() {
        return this.relativeToChangelogFile;
    }

    public void setRelativeToChangelogFile(Boolean relativeToChangelogFile) {
        this.relativeToChangelogFile = relativeToChangelogFile;
    }
}

