/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cassandra.sqlgenerator;

import liquibase.Scope;
import liquibase.database.Database;
import liquibase.ext.cassandra.database.CassandraDatabase;
import liquibase.ext.cassandra.sqlgenerator.CreateDatabaseChangeLogLockTableGeneratorCassandra;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.InitializeDatabaseChangeLogLockTableGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InitializeDatabaseChangeLogLockTableStatement;
import liquibase.statement.core.InsertStatement;
import liquibase.statement.core.RawSqlStatement;

public class InitializeDatabaseChangeLogLockTableGeneratorCassandra
extends InitializeDatabaseChangeLogLockTableGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(InitializeDatabaseChangeLogLockTableStatement statement, Database database) {
        return super.supports((SqlStatement)statement, database) && database instanceof CassandraDatabase;
    }

    public Sql[] generateSql(InitializeDatabaseChangeLogLockTableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        SqlStatement[] statements;
        String databaseChangelogLockTableName = database.escapeTableName(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName(), database.getDatabaseChangeLogLockTableName().toUpperCase());
        InsertStatement insertStatement = new InsertStatement(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName(), database.getDatabaseChangeLogLockTableName().toUpperCase()).addColumnValue("ID", (Object)1).addColumnValue("LOCKED", (Object)Boolean.FALSE);
        if (CassandraDatabase.isAwsKeyspacesCompatibilityModeEnabled()) {
            Scope.getCurrentScope().getLog(InitializeDatabaseChangeLogLockTableGeneratorCassandra.class).fine("AWS Keyspaces compatibility mode enabled: using alternative queries to truncate changelog lock table");
            RawSqlStatement dropStatement = new RawSqlStatement("DROP TABLE " + databaseChangelogLockTableName);
            RawSqlStatement createStatement = CreateDatabaseChangeLogLockTableGeneratorCassandra.buildCreateTableStatement(databaseChangelogLockTableName);
            statements = new SqlStatement[]{dropStatement, createStatement, insertStatement};
        } else {
            RawSqlStatement deleteStatement = new RawSqlStatement("TRUNCATE TABLE " + databaseChangelogLockTableName);
            statements = new SqlStatement[]{deleteStatement, insertStatement};
        }
        return SqlGeneratorFactory.getInstance().generateSql(statements, database);
    }
}

