/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cassandra.sqlgenerator;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.ext.cassandra.database.CassandraDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.DeleteGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DeleteStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Table;

public class DeleteGeneratorCassandra
extends DeleteGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(DeleteStatement statement, Database database) {
        return super.supports((SqlStatement)statement, database) && database instanceof CassandraDatabase;
    }

    public Sql[] generateSql(DeleteStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        if (statement.getWhere() == null) {
            if (CassandraDatabase.isAwsKeyspacesCompatibilityModeEnabled()) {
                Scope.getCurrentScope().getLog(DeleteGeneratorCassandra.class).fine("AWS Keyspaces compatibility mode enabled: using alternative queries to truncate " + statement.getTableName());
                return this.buildDeleteStatements(statement, database, sqlGeneratorChain).toArray(new Sql[0]);
            }
            String sql = "TRUNCATE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName());
            return new Sql[]{new UnparsedSql(sql, new DatabaseObject[]{this.getAffectedTable(statement)})};
        }
        return super.generateSql(statement, database, sqlGeneratorChain);
    }

    private List<Sql> buildDeleteStatements(DeleteStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ArrayList<Sql> sqlStatements = new ArrayList<Sql>();
        String tableName = database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName());
        Table table = (Table)this.getAffectedTable(statement);
        PrimaryKey pk = table.getPrimaryKey();
        String pkColumnNames = pk.getColumnNames();
        String selectTableContent = "SELECT " + pkColumnNames + " FROM " + tableName;
        try {
            Statement stmt = ((CassandraDatabase)database).getStatement();
            ResultSet rs = stmt.executeQuery(selectTableContent);
            while (rs.next()) {
                DeleteStatement deleteRowStatement = new DeleteStatement(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName());
                statement.addWhereColumnName(pkColumnNames);
                for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                    statement.addWhereParameter(rs.getObject(i));
                }
                sqlStatements.add(super.generateSql(deleteRowStatement, database, sqlGeneratorChain)[0]);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException | DatabaseException e) {
            throw new UnexpectedLiquibaseException("Failed to build DELETE statements to truncate table " + tableName, e);
        }
        return sqlStatements;
    }
}

