/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cassandra.sqlgenerator;

import liquibase.database.Database;
import liquibase.ext.cassandra.database.CassandraDatabase;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.CreateDatabaseChangeLogLockTableGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CreateDatabaseChangeLogLockTableStatement;
import liquibase.statement.core.RawSqlStatement;

public class CreateDatabaseChangeLogLockTableGeneratorCassandra
extends CreateDatabaseChangeLogLockTableGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(CreateDatabaseChangeLogLockTableStatement statement, Database database) {
        return super.supports((SqlStatement)statement, database) && database instanceof CassandraDatabase;
    }

    public Sql[] generateSql(CreateDatabaseChangeLogLockTableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        RawSqlStatement createTableStatement = CreateDatabaseChangeLogLockTableGeneratorCassandra.buildCreateTableStatement(database.escapeTableName(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName(), database.getDatabaseChangeLogLockTableName()));
        return SqlGeneratorFactory.getInstance().generateSql((SqlStatement)createTableStatement, database);
    }

    protected static RawSqlStatement buildCreateTableStatement(String tableName) {
        return new RawSqlStatement("CREATE TABLE IF NOT EXISTS " + tableName + " (ID INT, LOCKED BOOLEAN, LOCKGRANTED timestamp, LOCKEDBY TEXT, PRIMARY KEY (ID))");
    }
}

