/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.ip2region;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import org.lionsoul.ip2region.xdb.Searcher;

public class SearchTest {
    public static void printHelp(String[] args) {
        System.out.print("ip2region xdb searcher\n");
        System.out.print("java -jar ip2region-{version}.jar [command] [command options]\n");
        System.out.print("Command: \n");
        System.out.print("  search    search input test\n");
        System.out.print("  bench     search bench test\n");
    }

    public static Searcher createSearcher(String dbPath, String cachePolicy) throws IOException {
        if ("file".equals(cachePolicy)) {
            return Searcher.newWithFileOnly(dbPath);
        }
        if ("vectorIndex".equals(cachePolicy)) {
            byte[] vIndex = Searcher.loadVectorIndexFromFile(dbPath);
            return Searcher.newWithVectorIndex(dbPath, vIndex);
        }
        if ("content".equals(cachePolicy)) {
            byte[] cBuff = Searcher.loadContentFromFile(dbPath);
            return Searcher.newWithBuffer(cBuff);
        }
        throw new IOException("invalid cache policy `" + cachePolicy + "`, options: file/vectorIndex/content");
    }

    public static void searchTest(String[] args) throws IOException {
        String dbPath = "";
        String cachePolicy = "vectorIndex";
        for (String r : args) {
            if (r.length() < 5 || r.indexOf("--") != 0) continue;
            int sIdx = r.indexOf(61);
            if (sIdx < 0) {
                System.out.printf("missing = for args pair `%s`\n", r);
                return;
            }
            String key = r.substring(2, sIdx);
            String val = r.substring(sIdx + 1);
            if ("db".equals(key)) {
                dbPath = val;
                continue;
            }
            if ("cache-policy".equals(key)) {
                cachePolicy = val;
                continue;
            }
            System.out.printf("undefined option `%s`\n", r);
            return;
        }
        if (dbPath.length() < 1) {
            System.out.print("java -jar ip2region-{version}.jar search [command options]\n");
            System.out.print("options:\n");
            System.out.print(" --db string              ip2region binary xdb file path\n");
            System.out.print(" --cache-policy string    cache policy: file/vectorIndex/content\n");
            return;
        }
        Searcher searcher = SearchTest.createSearcher(dbPath, cachePolicy);
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.printf("ip2region xdb searcher test program, cachePolicy: %s\ntype 'quit' to exit\n", cachePolicy);
        while (true) {
            System.out.print("ip2region>> ");
            String line = reader.readLine().trim();
            if (line.length() < 2) continue;
            if (line.equalsIgnoreCase("quit")) break;
            try {
                double sTime = System.nanoTime();
                String region = searcher.searchByStr(line);
                long cost = TimeUnit.NANOSECONDS.toMicros((long)((double)System.nanoTime() - sTime));
                System.out.printf("{region: %s, ioCount: %d, took: %d \u03bcs}\n", region, searcher.getIOCount(), cost);
            }
            catch (Exception e) {
                System.out.printf("{err: %s, ioCount: %d}\n", e, searcher.getIOCount());
            }
        }
        reader.close();
        searcher.close();
        System.out.println("searcher test program exited, thanks for trying");
    }

    public static void benchTest(String[] args) throws IOException {
        String line;
        String dbPath = "";
        String srcPath = "";
        String cachePolicy = "vectorIndex";
        for (String r : args) {
            if (r.length() < 5 || r.indexOf("--") != 0) continue;
            int sIdx = r.indexOf(61);
            if (sIdx < 0) {
                System.out.printf("missing = for args pair `%s`\n", r);
                return;
            }
            String key = r.substring(2, sIdx);
            String val = r.substring(sIdx + 1);
            if ("db".equals(key)) {
                dbPath = val;
                continue;
            }
            if ("src".equals(key)) {
                srcPath = val;
                continue;
            }
            if ("cache-policy".equals(key)) {
                cachePolicy = val;
                continue;
            }
            System.out.printf("undefined option `%s`\n", r);
            return;
        }
        if (dbPath.length() < 1 || srcPath.length() < 1) {
            System.out.print("java -jar ip2region-{version}.jar bench [command options]\n");
            System.out.print("options:\n");
            System.out.print(" --db string              ip2region binary xdb file path\n");
            System.out.print(" --src string             source ip text file path\n");
            System.out.print(" --cache-policy string    cache policy: file/vectorIndex/content\n");
            return;
        }
        Searcher searcher = SearchTest.createSearcher(dbPath, cachePolicy);
        long count = 0L;
        long costs = 0L;
        long tStart = System.nanoTime();
        BufferedReader reader = new BufferedReader(new FileReader(srcPath));
        while ((line = reader.readLine()) != null) {
            long eip;
            long sip;
            String l = line.trim();
            String[] ps = l.split("\\|", 3);
            if (ps.length != 3) {
                System.out.printf("invalid ip segment `%s`\n", l);
                return;
            }
            try {
                sip = Searcher.checkIpAddr(ps[0]);
            }
            catch (Exception e) {
                System.out.printf("check start ip `%s`: %s\n", ps[0], e);
                return;
            }
            try {
                eip = Searcher.checkIpAddr(ps[1]);
            }
            catch (Exception e) {
                System.out.printf("check end ip `%s`: %s\n", ps[1], e);
                return;
            }
            if (sip > eip) {
                System.out.printf("start ip(%s) should not be greater than end ip(%s)\n", ps[0], ps[1]);
                return;
            }
            long mip = sip + eip >> 1;
            for (long ip : new long[]{sip, sip + mip >> 1, mip, mip + eip >> 1, eip}) {
                long sTime = System.nanoTime();
                String region = searcher.search(ip);
                costs += System.nanoTime() - sTime;
                if (!ps[2].equals(region)) {
                    System.out.printf("failed search(%s) with (%s != %s)\n", Searcher.long2ip(ip), region, ps[2]);
                    return;
                }
                ++count;
            }
        }
        reader.close();
        searcher.close();
        long took = System.nanoTime() - tStart;
        System.out.printf("Bench finished, {cachePolicy: %s, total: %d, took: %ds, cost: %d \u03bcs/op}\n", cachePolicy, count, TimeUnit.NANOSECONDS.toSeconds(took), count == 0L ? 0L : TimeUnit.NANOSECONDS.toMicros(costs / count));
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            SearchTest.printHelp(args);
            return;
        }
        if ("search".equals(args[0])) {
            try {
                SearchTest.searchTest(args);
            }
            catch (IOException e) {
                System.out.printf("failed running search test: %s\n", e);
            }
        } else if ("bench".equals(args[0])) {
            try {
                SearchTest.benchTest(args);
            }
            catch (IOException e) {
                System.out.printf("failed running bench test: %s\n", e);
            }
        } else {
            SearchTest.printHelp(args);
        }
    }
}

