/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.jackson.model;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlText;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.linguafranca.pwdb.kdbx.jackson.JacksonGroup;
import org.linguafranca.pwdb.kdbx.jackson.converter.Base64ToByteConverter;
import org.linguafranca.pwdb.kdbx.jackson.converter.Base64ToUUIDConverter;
import org.linguafranca.pwdb.kdbx.jackson.converter.BooleanToStringConverter;
import org.linguafranca.pwdb.kdbx.jackson.converter.ByteToBase64Converter;
import org.linguafranca.pwdb.kdbx.jackson.converter.DateToStringConverter;
import org.linguafranca.pwdb.kdbx.jackson.converter.StringToBooleanConverter;
import org.linguafranca.pwdb.kdbx.jackson.converter.StringToDateConverter;
import org.linguafranca.pwdb.kdbx.jackson.converter.UUIDToBase64Converter;

@JacksonXmlRootElement(localName="KeePassFile")
public class KeePassFile {
    @JacksonXmlProperty(localName="Meta")
    public Meta meta;
    @JacksonXmlProperty(localName="Root")
    public Root root;

    public void createBinaries() {
        this.meta.binaries = new ArrayList<Binary>();
    }

    public static class CustomData {
        @JacksonXmlProperty(localName="Item")
        @JacksonXmlElementWrapper(useWrapping=false)
        protected List<CustomDataItem> items;

        public List<CustomDataItem> getItems() {
            return this.items;
        }

        public void setItems(List<CustomDataItem> items) {
            this.items = items;
        }

        public static class CustomDataItem {
            @JacksonXmlProperty(localName="Key")
            public String key;
            @JacksonXmlProperty(localName="Value")
            public String value;
            @JacksonXmlProperty(localName="LastModificationTime")
            @JsonDeserialize(converter=StringToDateConverter.class)
            @JsonSerialize(converter=DateToStringConverter.class)
            public Date lastModificationTime;
        }
    }

    public static class Icon {
        @JacksonXmlProperty(localName="UUID")
        @JsonDeserialize(converter=Base64ToUUIDConverter.class)
        @JsonSerialize(converter=UUIDToBase64Converter.class)
        protected UUID uuid;
        @JacksonXmlProperty(localName="Name")
        protected String name;
        @JacksonXmlProperty(localName="LastModificationTime")
        @JsonDeserialize(converter=StringToDateConverter.class)
        @JsonSerialize(converter=DateToStringConverter.class)
        protected Date lastModificationTime;
        @JacksonXmlProperty(localName="Data")
        @JsonDeserialize(converter=Base64ToByteConverter.class)
        @JsonSerialize(converter=ByteToBase64Converter.class)
        protected byte[] data;

        public String getName() {
            return this.uuid.toString();
        }
    }

    public static class Binary {
        @JacksonXmlText
        protected String value;
        @JacksonXmlProperty(localName="ID", isAttribute=true)
        protected Integer id;
        @JacksonXmlProperty(localName="Compressed", isAttribute=true)
        @JsonDeserialize(converter=StringToBooleanConverter.class)
        @JsonSerialize(converter=BooleanToStringConverter.class)
        protected Boolean compressed;

        public String getValue() {
            return this.value;
        }

        public Boolean getCompressed() {
            return this.compressed;
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer Id) {
            this.id = Id;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setCompressed(boolean compressed) {
            this.compressed = compressed;
        }
    }

    public static class Binaries {
    }

    @JsonPropertyOrder(value={"protectTitle", "protectUserName", "protectPassword", "protectURL", "protectNotes"})
    public static class MemoryProtection {
        @JacksonXmlProperty(localName="ProtectTitle")
        @JsonDeserialize(converter=StringToBooleanConverter.class)
        @JsonSerialize(converter=BooleanToStringConverter.class)
        protected Boolean protectTitle;
        @JacksonXmlProperty(localName="ProtectUserName")
        @JsonDeserialize(converter=StringToBooleanConverter.class)
        @JsonSerialize(converter=BooleanToStringConverter.class)
        protected Boolean protectUserName;
        @JacksonXmlProperty(localName="ProtectPassword")
        @JsonDeserialize(converter=StringToBooleanConverter.class)
        @JsonSerialize(converter=BooleanToStringConverter.class)
        protected Boolean protectPassword;
        @JacksonXmlProperty(localName="ProtectURL")
        @JsonDeserialize(converter=StringToBooleanConverter.class)
        @JsonSerialize(converter=BooleanToStringConverter.class)
        protected Boolean protectURL;
        @JacksonXmlProperty(localName="ProtectNotes")
        @JsonDeserialize(converter=StringToBooleanConverter.class)
        @JsonSerialize(converter=BooleanToStringConverter.class)
        protected Boolean protectNotes;

        public Boolean shouldProtect(String name) {
            switch (name) {
                case "Title": {
                    return this.protectTitle;
                }
                case "UserName": {
                    return this.protectUserName;
                }
                case "Password": {
                    return this.protectPassword;
                }
                case "URL": {
                    return this.protectURL;
                }
                case "Notes": {
                    return this.protectNotes;
                }
            }
            return false;
        }
    }

    @JsonPropertyOrder(value={"generator", "headerHash", "databaseName", "databaseNameChanged", "databaseDescription", "databaseDescriptionChanged", "defaultUserName", "defaultUserNameChanged", "maintenanceHistoryDays", "color", "masterKeyChanged", "masterKeyChangeRec", "masterKeyChangeForce", "masterKeyChangeForceOnce", "memoryProtection", "customIcons", "recycleBinEnabled", "recycleBinUUID", "recycleBinChanged", "entryTemplatesGroup", "entryTemplatesGroupChanged", "lastSelectedGroup", "lastTopVisibleGroup", "historyMaxItems", "historyMaxSize", "binaries"})
    public static class Meta {
        @JacksonXmlProperty(localName="Generator")
        public String generator;
        @JacksonXmlProperty(localName="HeaderHash")
        @JsonDeserialize(converter=Base64ToByteConverter.class)
        @JsonSerialize(converter=ByteToBase64Converter.class)
        public byte[] headerHash;
        @JacksonXmlProperty(localName="DatabaseName")
        public String databaseName;
        @JacksonXmlProperty(localName="DatabaseNameChanged")
        @JsonDeserialize(converter=StringToDateConverter.class)
        @JsonSerialize(converter=DateToStringConverter.class)
        public Date databaseNameChanged;
        @JacksonXmlProperty(localName="DatabaseDescription")
        public String databaseDescription;
        @JacksonXmlProperty(localName="DatabaseDescriptionChanged")
        @JsonDeserialize(converter=StringToDateConverter.class)
        @JsonSerialize(converter=DateToStringConverter.class)
        public Date databaseDescriptionChanged;
        @JacksonXmlProperty(localName="DefaultUserName")
        protected String defaultUserName;
        @JacksonXmlProperty(localName="DefaultUserNameChanged")
        @JsonDeserialize(converter=StringToDateConverter.class)
        @JsonSerialize(converter=DateToStringConverter.class)
        protected Date defaultUserNameChanged;
        @JacksonXmlProperty(localName="MaintenanceHistoryDays")
        protected int maintenanceHistoryDays;
        @JacksonXmlProperty(localName="Color")
        protected String color;
        @JacksonXmlProperty(localName="MasterKeyChanged")
        @JsonDeserialize(converter=StringToDateConverter.class)
        @JsonSerialize(converter=DateToStringConverter.class)
        protected Date masterKeyChanged;
        @JacksonXmlProperty(localName="MasterKeyChangeRec")
        protected int masterKeyChangeRec;
        @JacksonXmlProperty(localName="MasterKeyChangeForce")
        protected int masterKeyChangeForce;
        @JacksonXmlProperty(localName="MasterKeyChangeForceOnce")
        @JsonDeserialize(converter=StringToBooleanConverter.class)
        @JsonSerialize(converter=BooleanToStringConverter.class)
        protected Boolean masterKeyChangeForceOnce;
        @JacksonXmlProperty(localName="MemoryProtection")
        public MemoryProtection memoryProtection;
        @JacksonXmlElementWrapper(localName="CustomIcons")
        protected ArrayList<Icon> customIcons;
        @JacksonXmlProperty(localName="RecycleBinEnabled")
        @JsonDeserialize(converter=StringToBooleanConverter.class)
        @JsonSerialize(converter=BooleanToStringConverter.class)
        public Boolean recycleBinEnabled;
        @JacksonXmlProperty(localName="RecycleBinUUID")
        @JsonDeserialize(converter=Base64ToUUIDConverter.class)
        @JsonSerialize(converter=UUIDToBase64Converter.class)
        public UUID recycleBinUUID;
        @JacksonXmlProperty(localName="RecycleBinChanged")
        @JsonDeserialize(converter=StringToDateConverter.class)
        @JsonSerialize(converter=DateToStringConverter.class)
        public Date recycleBinChanged;
        @JacksonXmlProperty(localName="EntryTemplatesGroup")
        @JsonDeserialize(converter=Base64ToUUIDConverter.class)
        @JsonSerialize(converter=UUIDToBase64Converter.class)
        protected UUID entryTemplatesGroup;
        @JacksonXmlProperty(localName="EntryTemplatesGroupChanged")
        @JsonDeserialize(converter=StringToDateConverter.class)
        @JsonSerialize(converter=DateToStringConverter.class)
        protected Date entryTemplatesGroupChanged;
        @JacksonXmlProperty(localName="LastSelectedGroup")
        @JsonDeserialize(converter=Base64ToUUIDConverter.class)
        @JsonSerialize(converter=UUIDToBase64Converter.class)
        protected UUID lastSelectedGroup;
        @JacksonXmlProperty(localName="LastTopVisibleGroup")
        @JsonDeserialize(converter=Base64ToUUIDConverter.class)
        @JsonSerialize(converter=UUIDToBase64Converter.class)
        protected UUID lastTopVisibleGroup;
        @JacksonXmlProperty(localName="HistoryMaxItems")
        protected int historyMaxItems;
        @JacksonXmlProperty(localName="HistoryMaxSize")
        protected int historyMaxSize;
        @JacksonXmlProperty(localName="Binaries")
        public List<Binary> binaries;
        @JacksonXmlProperty(localName="CustomData")
        protected CustomData customData;
        @JacksonXmlProperty(localName="SettingsChanged")
        @JsonDeserialize(converter=StringToDateConverter.class)
        @JsonSerialize(converter=DateToStringConverter.class)
        protected Date settingsChanged;
    }

    @JsonPropertyOrder(value={"group", "deletedObject"})
    public static class Root {
        @JacksonXmlProperty(localName="Group")
        public JacksonGroup group;
        @JacksonXmlProperty(localName="DeletedObjects")
        protected Object deletedObject;
    }
}

