/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.jackson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.linguafranca.pwdb.PropertyValue;
import org.linguafranca.pwdb.base.AbstractEntry;
import org.linguafranca.pwdb.kdbx.Helpers;
import org.linguafranca.pwdb.kdbx.jackson.JacksonDatabase;
import org.linguafranca.pwdb.kdbx.jackson.JacksonGroup;
import org.linguafranca.pwdb.kdbx.jackson.JacksonHistory;
import org.linguafranca.pwdb.kdbx.jackson.JacksonIcon;
import org.linguafranca.pwdb.kdbx.jackson.converter.Base64ToUUIDConverter;
import org.linguafranca.pwdb.kdbx.jackson.converter.BooleanToStringConverter;
import org.linguafranca.pwdb.kdbx.jackson.converter.StringToBooleanConverter;
import org.linguafranca.pwdb.kdbx.jackson.converter.UUIDToBase64Converter;
import org.linguafranca.pwdb.kdbx.jackson.model.EntryClasses;
import org.linguafranca.pwdb.kdbx.jackson.model.KeePassFile;
import org.linguafranca.pwdb.kdbx.jackson.model.Times;

@JsonPropertyOrder(value={"uuid", "iconID", "customIconUUID", "foregroundColor", "backgroundColor", "overrideURL", "previousParentGroup", "tags", "times", "string", "binary", "autoType", "customData", "history"})
@JsonIgnoreProperties(value={"path", "username", "title", "notes", "url", "password"})
public class JacksonEntry
extends AbstractEntry<JacksonDatabase, JacksonGroup, JacksonEntry, JacksonIcon> {
    @JsonIgnore
    JacksonDatabase database;
    @JsonIgnore
    JacksonGroup parent;
    @JacksonXmlProperty(localName="UUID")
    @JsonDeserialize(converter=Base64ToUUIDConverter.class)
    @JsonSerialize(converter=UUIDToBase64Converter.class)
    protected UUID uuid;
    @JacksonXmlProperty(localName="IconID")
    protected int iconID = 0;
    @JacksonXmlProperty(localName="CustomIconUUID")
    @JsonDeserialize(converter=Base64ToUUIDConverter.class)
    @JsonSerialize(converter=UUIDToBase64Converter.class)
    protected UUID customIconUUID;
    @JacksonXmlProperty(localName="ForegroundColor")
    protected String foregroundColor;
    @JacksonXmlProperty(localName="BackgroundColor")
    protected String backgroundColor;
    @JacksonXmlProperty(localName="OverrideURL")
    protected String overrideURL;
    @JacksonXmlProperty(localName="PreviousParentGroup")
    @JsonDeserialize(converter=Base64ToUUIDConverter.class)
    @JsonSerialize(converter=UUIDToBase64Converter.class)
    protected UUID previousParentGroup;
    @JacksonXmlProperty(localName="Tags")
    protected String tags;
    @JacksonXmlProperty(localName="QualityCheck")
    @JsonDeserialize(converter=StringToBooleanConverter.class)
    @JsonSerialize(converter=BooleanToStringConverter.class)
    protected Boolean qualityCheck;
    @JacksonXmlProperty(localName="Times")
    protected Times times;
    @JacksonXmlProperty(localName="String")
    @JacksonXmlElementWrapper(useWrapping=false)
    protected List<EntryClasses.StringProperty> string = new ArrayList<EntryClasses.StringProperty>();
    @JacksonXmlProperty(localName="Binary")
    @JacksonXmlElementWrapper(useWrapping=false)
    protected List<EntryClasses.BinaryProperty> binary = new ArrayList<EntryClasses.BinaryProperty>();
    @JacksonXmlProperty(localName="AutoType")
    protected EntryClasses.AutoType autoType;
    @JacksonXmlProperty(localName="CustomData")
    protected KeePassFile.CustomData customData;
    @JacksonXmlProperty(localName="History")
    protected JacksonHistory history;

    protected JacksonEntry() {
        this.times = new Times();
        this.uuid = UUID.randomUUID();
    }

    public static JacksonEntry createEntry(JacksonDatabase database) {
        JacksonEntry result = new JacksonEntry();
        result.database = database;
        result.parent = null;
        for (String p : STANDARD_PROPERTY_NAMES) {
            result.string.add(new EntryClasses.StringProperty(p, database.getPropertyValueStrategy().newUnprotected().of((CharSequence)"")));
        }
        return result;
    }

    @JsonIgnore
    public String getProperty(String s) {
        EntryClasses.StringProperty sp = EntryClasses.getStringProperty(s, this.string);
        if (sp == null) {
            return null;
        }
        return sp.getValue().getValueAsString();
    }

    @JsonIgnore
    public void setProperty(String s, String s1) {
        EntryClasses.StringProperty sp = EntryClasses.getStringProperty(s, this.string);
        if (sp != null) {
            sp.setValue(this.database.getPropertyValueStrategy().newUnprotected().of((CharSequence)s1));
            return;
        }
        this.string.add(new EntryClasses.StringProperty(s, this.database.getPropertyValueStrategy().newUnprotected().of((CharSequence)s1)));
        this.touch();
    }

    @JsonIgnore
    public PropertyValue getPropertyValue(String name) {
        EntryClasses.StringProperty sp = EntryClasses.getStringProperty(name, this.string);
        return sp != null ? sp.getValue() : null;
    }

    @JsonIgnore
    public void setPropertyValue(String name, PropertyValue value) {
        EntryClasses.StringProperty sp = EntryClasses.getStringProperty(name, this.string);
        if (sp != null) {
            sp.setValue(value);
            return;
        }
        this.string.add(new EntryClasses.StringProperty(name, value));
        this.touch();
    }

    @JsonIgnore
    public boolean removeProperty(String name) throws IllegalArgumentException {
        if (STANDARD_PROPERTY_NAMES.contains(name)) {
            throw new IllegalArgumentException("may not remove property: " + name);
        }
        EntryClasses.StringProperty sp = EntryClasses.getStringProperty(name, this.string);
        if (sp == null) {
            return false;
        }
        this.string.remove(sp);
        this.touch();
        return true;
    }

    @JsonIgnore
    public List<String> getPropertyNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (EntryClasses.StringProperty property : this.string) {
            result.add(property.getKey());
        }
        return result;
    }

    public byte[] getBinaryProperty(String s) {
        EntryClasses.BinaryProperty bp = EntryClasses.getBinaryProp(s, this.binary);
        if (bp == null) {
            return null;
        }
        KeePassFile.Binary binary = null;
        for (KeePassFile.Binary b : this.database.getBinaries()) {
            if (!b.getId().equals(Integer.valueOf(EntryClasses.getBinaryContent(bp)))) continue;
            binary = b;
        }
        if (binary == null) {
            return null;
        }
        return Helpers.decodeBase64Content((byte[])binary.getValue().getBytes(), (boolean)binary.getCompressed());
    }

    public void setBinaryProperty(String s, byte[] bytes) {
        EntryClasses.BinaryProperty bp = EntryClasses.getBinaryProp(s, this.binary);
        if (bp != null) {
            this.binary.remove(bp);
        }
        Integer max = -1;
        for (KeePassFile.Binary binary : this.database.getBinaries()) {
            if (binary.getId() <= max) continue;
            max = binary.getId();
        }
        Integer n = max;
        Integer n2 = max = Integer.valueOf(max + 1);
        this.database.addBinary(bytes, max);
        EntryClasses.BinaryProperty binaryProperty = new EntryClasses.BinaryProperty();
        binaryProperty.setKey(s);
        EntryClasses.BinaryProperty.Value value = new EntryClasses.BinaryProperty.Value();
        value.setRef(String.valueOf(max));
        binaryProperty.setValue(value);
        this.binary.add(binaryProperty);
        this.touch();
    }

    @JsonIgnore
    public boolean removeBinaryProperty(String name) throws UnsupportedOperationException {
        EntryClasses.BinaryProperty bp = EntryClasses.getBinaryProp(name, this.binary);
        if (bp != null) {
            this.binary.remove(bp);
            this.touch();
            return true;
        }
        return false;
    }

    @JsonIgnore
    public List<String> getBinaryPropertyNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (EntryClasses.BinaryProperty property : this.binary) {
            result.add(property.getKey());
        }
        return result;
    }

    public JacksonGroup getParent() {
        return this.parent;
    }

    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    public JacksonIcon getIcon() {
        return new JacksonIcon(this.iconID);
    }

    public void setIcon(JacksonIcon icon) {
        this.iconID = icon.getIndex();
    }

    @JsonIgnore
    public Date getLastAccessTime() {
        return this.times.getLastAccessTime();
    }

    @JsonIgnore
    public Date getCreationTime() {
        return this.times.getCreationTime();
    }

    @JsonIgnore
    public boolean getExpires() {
        return this.times.getExpires();
    }

    @JsonIgnore
    public void setExpires(boolean expires) {
        this.times.setExpires(expires);
    }

    @JsonIgnore
    public Date getExpiryTime() {
        return this.times.getExpiryTime();
    }

    @JsonIgnore
    public void setExpiryTime(Date expiryTime) throws IllegalArgumentException {
        if (expiryTime == null) {
            throw new IllegalArgumentException("expiryTime may not be null");
        }
        this.times.setExpiryTime(expiryTime);
    }

    @JsonIgnore
    public Date getLastModificationTime() {
        return this.times.getLastModificationTime();
    }

    @JsonIgnore
    protected void touch() {
        this.times.setLastModificationTime(new Date());
        this.database.setDirty(true);
    }
}

