/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.quote.upload;

import jakarta.persistence.EntityNotFoundException;
import jakarta.transaction.Transactional;
import jakarta.validation.ConstraintViolationException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.hibernate.Hibernate;
import org.ligoj.app.plugin.prov.AbstractProvQuoteVmResource;
import org.ligoj.app.plugin.prov.AbstractQuoteVmEditionVo;
import org.ligoj.app.plugin.prov.ProvResource;
import org.ligoj.app.plugin.prov.ProvTagResource;
import org.ligoj.app.plugin.prov.TagEditionVo;
import org.ligoj.app.plugin.prov.dao.BaseMultiScopedRepository;
import org.ligoj.app.plugin.prov.dao.Optimizer;
import org.ligoj.app.plugin.prov.dao.ProvBudgetRepository;
import org.ligoj.app.plugin.prov.dao.ProvOptimizerRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteDatabaseRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteInstanceRepository;
import org.ligoj.app.plugin.prov.dao.ProvUsageRepository;
import org.ligoj.app.plugin.prov.model.AbstractMultiScoped;
import org.ligoj.app.plugin.prov.model.ProvBudget;
import org.ligoj.app.plugin.prov.model.ProvDatabasePrice;
import org.ligoj.app.plugin.prov.model.ProvInstancePrice;
import org.ligoj.app.plugin.prov.model.ProvOptimizer;
import org.ligoj.app.plugin.prov.model.ProvQuote;
import org.ligoj.app.plugin.prov.model.ProvQuoteDatabase;
import org.ligoj.app.plugin.prov.model.ProvQuoteInstance;
import org.ligoj.app.plugin.prov.model.ProvStoragePrice;
import org.ligoj.app.plugin.prov.model.ProvStorageType;
import org.ligoj.app.plugin.prov.model.ProvUsage;
import org.ligoj.app.plugin.prov.model.ResourceType;
import org.ligoj.app.plugin.prov.quote.database.ProvQuoteDatabaseResource;
import org.ligoj.app.plugin.prov.quote.database.QuoteDatabaseEditionVo;
import org.ligoj.app.plugin.prov.quote.instance.ProvQuoteInstanceResource;
import org.ligoj.app.plugin.prov.quote.instance.QuoteInstanceEditionVo;
import org.ligoj.app.plugin.prov.quote.storage.ProvQuoteStorageResource;
import org.ligoj.app.plugin.prov.quote.storage.QuoteStorageEditionVo;
import org.ligoj.app.plugin.prov.quote.storage.QuoteStorageLookup;
import org.ligoj.app.plugin.prov.quote.storage.QuoteStorageQuery;
import org.ligoj.app.plugin.prov.quote.upload.MergeMode;
import org.ligoj.app.plugin.prov.quote.upload.VmUpload;
import org.ligoj.app.resource.subscription.SubscriptionResource;
import org.ligoj.bootstrap.core.csv.CsvForBean;
import org.ligoj.bootstrap.core.model.AbstractNamedEntity;
import org.ligoj.bootstrap.core.validation.ValidationJsonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;

@Service
@Path(value="/service/prov")
@Produces(value={"application/json"})
@Transactional
public class ProvQuoteUploadResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProvQuoteUploadResource.class);
    private static final String CSV_FILE = "csv-file";
    public static final String DEFAULT_SEPARATOR = ";";
    public static final String DEFAULT_ENCODING = StandardCharsets.UTF_8.name();
    private static final List<String> MINIMAL_HEADERS_INSTANCE = List.of("name", "cpu", "ram", "os");
    private static final List<String> MINIMAL_HEADERS_DATABASE = List.of("name", "cpu", "ram", "engine");
    private static final String[] DEFAULT_HEADERS = new String[]{"name", "cpu", "ram", "os", "disk", "latency", "optimized", "tags"};
    private static final List<String> ACCEPTED_HEADERS = List.of("name:host(name)?|nom", "cpu:(vcpu|core|processor)s?", "gpu:gpu", "ram:memory", "workload:workload", "physical:metal", "os:(system|operating[ -_]?system)", "disk:(storage|size|disque|scheibe)", "latency:(disk|storage|disque|scheibe)latency", "optimized:(disk|storage|disque|scheibe)?optimized", "type:(instance|vm)[-_ ]?type", "internet:public", "minQuantity:(min[-_ ]?(quantity)?|quantity[-_ ]?min)", "maxQuantity:(max[-_ ]?(quantity)?|quantity[-_ ]?max)", "maxVariableCost:max[-_ ]?(variable)?[-_ ]?cost", "ephemeral:preemptive", "location:region", "usage:(use|env|environment)", "budget:(finops|capex|upfront)", "optimizer:(greenops|green|carbon|target)", "license:licence", "software:package", "description:note", "tags:(tag|label|labels|etiquette|etikett)", "cpuMax:(max[-_ ]?cpu|cpu[-_ ]?max)", "gpuMax:(max[-_ ]?gpu|gpu[-_ ]?max)", "ramRate:ramRate", "cpuRate:cpuRate", "gpuRate:gpuRate", "networkRate:networkRate", "storageRate:storageRate", "ramMax:(max[-_ ]?(ram|memory)|(ram|memory)[-_ ]?max)", "diskMax:(max[-_ ]?(size|disk|storage|disque|scheibe)|(size|disk|storage|disque|scheibe)[-_ ]?max)", "processor:proc", "engine:db", "edition:version", "tenancy:tenancy");
    private static final List<Function<String[], String>> LAYER_MATCHERS = List.of(a -> a[0], a -> a[1], a -> a[0] + ".*", a -> a[1] + ".*", a -> ".*" + a[0], a -> ".*" + a[1], a -> ".*" + a[0] + ".*", a -> ".*" + a[1] + ".*");
    @Autowired
    private CsvForBean csvForBean;
    @Autowired
    protected ProvResource resource;
    @Autowired
    private ProvQuoteStorageResource storageResource;
    @Autowired
    private SubscriptionResource subscriptionResource;
    @Autowired
    private ProvUsageRepository usageRepository;
    @Autowired
    private ProvBudgetRepository budgetRepository;
    @Autowired
    private ProvOptimizerRepository optimizerRepository;
    @Autowired
    private ProvQuoteInstanceResource qiResource;
    @Autowired
    private ProvQuoteDatabaseResource qbResource;
    @Autowired
    private ProvTagResource tagResource;
    @Autowired
    private ProvQuoteInstanceRepository qiRepository;
    @Autowired
    private ProvQuoteDatabaseRepository qbRepository;
    private final Map<MergeMode, BiFunction<QuoteInstanceEditionVo, UploadContext, Integer>> mergersInstance = Map.of(MergeMode.INSERT, this::modeInsert, MergeMode.KEEP, this::modeKeep, MergeMode.UPDATE, this::modeUpdate);
    private final Map<MergeMode, BiFunction<QuoteDatabaseEditionVo, UploadContext, Integer>> mergersDatabase = Map.of(MergeMode.INSERT, this::modeInsert, MergeMode.KEEP, this::modeKeep, MergeMode.UPDATE, this::modeUpdate);

    private Integer modeInsert(QuoteInstanceEditionVo vo, UploadContext context) {
        ProvQuoteInstance qi = new ProvQuoteInstance();
        if (context.previousQi.containsKey(vo.getName())) {
            throw new DataIntegrityViolationException("name");
        }
        context.previousQi.put(vo.getName(), qi);
        qi.setId(this.qiResource.saveOrUpdate(context.quote, qi, vo).getId());
        vo.setId((Integer)qi.getId());
        return (Integer)qi.getId();
    }

    private Integer modeInsert(QuoteDatabaseEditionVo vo, UploadContext context) {
        ProvQuoteDatabase qb = new ProvQuoteDatabase();
        context.previousQb.put(vo.getName(), qb);
        qb.setId(this.qbResource.saveOrUpdate(context.quote, qb, vo).getId());
        vo.setId((Integer)qb.getId());
        return (Integer)qb.getId();
    }

    private <Q extends AbstractQuoteVmEditionVo> void nextName(Q vo, Map<String, ?> previous) {
        Object name = vo.getName();
        int counter = 0;
        while (previous.containsKey(name)) {
            name = vo.getName() + " " + ++counter;
        }
        vo.setName((String)name);
    }

    private Integer modeKeep(QuoteInstanceEditionVo vo, UploadContext context) {
        this.nextName(vo, context.previousQi);
        return this.modeInsert(vo, context);
    }

    private Integer modeKeep(QuoteDatabaseEditionVo vo, UploadContext context) {
        this.nextName(vo, context.previousQb);
        return this.modeInsert(vo, context);
    }

    private Integer modeUpdate(QuoteInstanceEditionVo vo, UploadContext context) {
        ProvQuoteInstance qi = context.previousQi.get(vo.getName());
        if (qi == null) {
            return this.modeInsert(vo, context);
        }
        vo.setId((Integer)qi.getId());
        this.qiResource.saveOrUpdate(context.quote, qi, vo);
        return null;
    }

    private Integer modeUpdate(QuoteDatabaseEditionVo vo, UploadContext context) {
        ProvQuoteDatabase qi = context.previousQb.get(vo.getName());
        if (qi == null) {
            return this.modeInsert(vo, context);
        }
        vo.setId((Integer)qi.getId());
        this.qbResource.saveOrUpdate(context.quote, qi, vo);
        return null;
    }

    private String cleanHeader(String header) {
        return StringUtils.unwrap((String)header, (char)'\"').trim();
    }

    private String[] checkHeaders(String ... headers) {
        HashMap mapped = new HashMap();
        HashSet mappedUser = new HashSet();
        LAYER_MATCHERS.forEach(layer -> {
            HashMap layerMapped = new HashMap();
            Arrays.stream(headers).forEach(h -> ACCEPTED_HEADERS.stream().map(mapping -> mapping.split(":")).filter(mapping -> !mapped.containsKey(mapping[0]) && !mappedUser.contains(h)).filter(mapping -> this.match((Function<String[], String>)layer, (String[])mapping, this.cleanHeader((String)h))).forEach(patterns -> {
                String previous = layerMapped.put(patterns[0], h);
                if (previous != null) {
                    throw new ValidationJsonException(CSV_FILE, (Serializable)((Object)"ambiguous-header"), new Serializable[]{"header", patterns[0], "name1", previous, "name2", h});
                }
            }));
            mapped.putAll(layerMapped);
            mappedUser.addAll(layerMapped.values());
        });
        CollectionUtils.removeAll(MINIMAL_HEADERS_INSTANCE, mapped.keySet()).stream().findFirst().flatMap(hi -> CollectionUtils.removeAll(MINIMAL_HEADERS_DATABASE, mapped.keySet()).stream().findFirst()).ifPresent(hd -> {
            throw new ValidationJsonException(CSV_FILE, (Serializable)((Object)"missing-header"), new Serializable[]{"header", hd});
        });
        return (String[])Arrays.stream(headers).map(MapUtils.invertMap(mapped)::get).map(StringUtils::trimToEmpty).toArray(String[]::new);
    }

    private boolean match(Function<String[], String> c, String[] namePattern, String value) {
        return Pattern.compile(c.apply(namePattern), 2).matcher(value.trim()).matches();
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="{subscription:\\d+}/upload")
    public void upload(@PathParam(value="subscription") int subscription, @Multipart(value="csv-file") String uploadedFile, @Multipart(value="headers", required=false) String[] headers, @Multipart(value="headers-included", required=false) Boolean headersIncluded, @Multipart(value="usage", required=false) String defaultUsage, @Multipart(value="budget", required=false) String defaultBudget, @Multipart(value="optimizer", required=false) String defaultOptimizer, @Multipart(value="mergeUpload", required=false) MergeMode mode, @Multipart(value="memoryUnit", required=false) Integer ramMultiplier, @Multipart(value="errorContinue", required=false) Boolean errorContinue, @Multipart(value="encoding", required=false) String encoding, @Multipart(value="createMissingUsage", required=false) Boolean createUsage, @Multipart(value="createMissingBudget", required=false) Boolean createBudget, @Multipart(value="createMissingOptimizer", required=false) Boolean createOptimizer, @Multipart(value="separator", required=false) String separator) throws IOException {
        ByteArrayInputStream fileNoHeader;
        String[] headersArray;
        log.info("Upload provisioning requested...");
        this.subscriptionResource.checkVisible(Integer.valueOf(subscription));
        ProvQuote quote = (ProvQuote)this.resource.getRepository().findBy("subscription.id", subscription);
        String safeEncoding = (String)ObjectUtils.getIfNull((Object)encoding, (Object)DEFAULT_ENCODING);
        if (headersIncluded == null || headersIncluded.booleanValue()) {
            BufferedReader br = new BufferedReader(new StringReader(uploadedFile));
            headersArray = Objects.toString(br.readLine()).split(separator);
            fileNoHeader = new ByteArrayInputStream(IOUtils.toByteArray((Reader)br, (String)safeEncoding));
        } else {
            headersArray = ArrayUtils.isEmpty((Object[])headers) ? DEFAULT_HEADERS : headers;
            fileNoHeader = new ByteArrayInputStream(uploadedFile.getBytes(safeEncoding));
        }
        String[] headersArray2 = this.checkHeaders(headersArray);
        String headersString = StringUtils.chop((String)ArrayUtils.toString((Object)headersArray2)).substring(1).replace(",", separator) + "\n";
        InputStreamReader reader = new InputStreamReader((InputStream)new SequenceInputStream(new ByteArrayInputStream(headersString.getBytes(safeEncoding)), fileNoHeader), safeEncoding);
        log.info("Upload provisioning : reading, using header {}", (Object)headersString);
        List list = this.csvForBean.toBean(VmUpload.class, (Reader)reader);
        log.info("Upload provisioning : importing {} entries", (Object)list.size());
        AtomicInteger cursor = new AtomicInteger(0);
        ConcurrentMap previousQi = this.qiRepository.findAll(quote).stream().collect(Collectors.toConcurrentMap(AbstractNamedEntity::getName, Function.identity()));
        ConcurrentMap previousQb = this.qbRepository.findAll(quote).stream().collect(Collectors.toConcurrentMap(AbstractNamedEntity::getName, Function.identity()));
        Hibernate.initialize(quote.getUsages());
        Hibernate.initialize(quote.getBudgets());
        Hibernate.initialize(quote.getOptimizers());
        UploadContext context = new UploadContext();
        context.quote = quote;
        context.previousQi = previousQi;
        context.previousQb = previousQb;
        list.stream().filter(Objects::nonNull).filter(i -> i.getName() != null).forEach(i -> {
            try {
                this.persist(subscription, defaultUsage, defaultBudget, defaultOptimizer, mode, ramMultiplier, list.size(), cursor, context, BooleanUtils.isTrue((Boolean)createUsage), BooleanUtils.isTrue((Boolean)createBudget), BooleanUtils.isTrue((Boolean)createOptimizer), (VmUpload)i);
            }
            catch (ValidationJsonException e) {
                this.handleUploadError(BooleanUtils.isTrue((Boolean)errorContinue), (RuntimeException)((Object)this.handleValidationError((VmUpload)i, e)));
            }
            catch (ConstraintViolationException e) {
                this.handleUploadError(BooleanUtils.isTrue((Boolean)errorContinue), (RuntimeException)((Object)this.handleValidationError((VmUpload)i, new ValidationJsonException(e))));
            }
            catch (RuntimeException e) {
                log.error("Unmanaged error during import of {}", (Object)i.getName(), (Object)e);
                this.handleUploadError(BooleanUtils.isTrue((Boolean)errorContinue), e);
            }
        });
        log.info("Upload provisioning : flushing");
    }

    private void handleUploadError(boolean onErrorContinue, RuntimeException e) {
        if (!onErrorContinue) {
            throw e;
        }
    }

    private <V extends AbstractQuoteVmEditionVo> V copy(int subscription, UploadContext context, String defaultUsage, String defaultBudget, String defaultOptimizer, Integer ramMultiplier, boolean createUsage, boolean createBudget, boolean createOptimizer, VmUpload u, V vo) {
        vo.setName(u.getName());
        vo.setDescription(u.getDescription());
        vo.setCpu(this.qiResource.round((Double)ObjectUtils.getIfNull((Object)u.getCpu(), (Object)0.0)));
        vo.setGpu(u.getGpu());
        vo.setProcessor(u.getProcessor());
        vo.setLicense(Optional.ofNullable(u.getLicense()).map(StringUtils::upperCase).orElse(null));
        vo.setInternet(u.getInternet());
        vo.setMaxQuantity(Optional.of(u.getMaxQuantity()).filter(q -> q > 0).orElse(null));
        vo.setMinQuantity(u.getMinQuantity());
        vo.setLocation(u.getLocation());
        vo.setCpuRate(u.getCpuRate());
        vo.setGpuRate(u.getGpuRate());
        vo.setRamRate(u.getRamRate());
        vo.setNetworkRate(u.getNetworkRate());
        vo.setStorageRate(u.getStorageRate());
        vo.setWorkload(u.getWorkload());
        vo.setPhysical(u.getPhysical());
        vo.setRam((Integer)ObjectUtils.getIfNull((Object)ramMultiplier, (Object)1) * ((Number)ObjectUtils.getIfNull((Object)u.getRam(), (Object)0)).intValue());
        vo.setSubscription(subscription);
        vo.setType(u.getType());
        vo.setCpuMax(u.getCpuMax());
        vo.setGpuMax(u.getGpuMax());
        vo.setRamMax(u.getRamMax() == null ? null : Integer.valueOf((Integer)ObjectUtils.getIfNull((Object)ramMultiplier, (Object)1) * u.getRamMax().intValue()));
        this.completeUsage(context, defaultUsage, createUsage, u, vo);
        this.completeBudget(context, defaultBudget, createBudget, u, vo);
        this.completeOptimizer(context, defaultOptimizer, createOptimizer, u, vo);
        return vo;
    }

    private ValidationJsonException handleValidationError(VmUpload i, ValidationJsonException e) {
        String failedEntry = (String)ObjectUtils.getIfNull((Object)i.getName(), (Object)"<unknown>");
        log.info("Upload provisioning failed for entry {}", (Object)failedEntry, (Object)e);
        Map errors = e.getErrors();
        new ArrayList(errors.keySet()).stream().peek(p -> errors.put("csv-file." + p, (List)errors.get(p))).forEach(errors::remove);
        errors.put(CSV_FILE, List.of(Map.of("parameters", (Serializable)((Object)Map.of("name", failedEntry)), "rule", "csv-invalid-entry")));
        return e;
    }

    private QuoteInstanceEditionVo newInstanceVo(VmUpload upload) {
        QuoteInstanceEditionVo vo = new QuoteInstanceEditionVo();
        vo.setMaxVariableCost(upload.getMaxVariableCost());
        vo.setOs(upload.getOs());
        vo.setLicense(Optional.ofNullable(upload.getLicense()).map(StringUtils::upperCase).orElse(null));
        vo.setSoftware(upload.getSoftware());
        vo.setTenancy(upload.getTenancy());
        vo.setEphemeral(upload.isEphemeral());
        return vo;
    }

    private QuoteDatabaseEditionVo newDatabaseVo(VmUpload upload) {
        QuoteDatabaseEditionVo vo = new QuoteDatabaseEditionVo();
        vo.setEngine(upload.getEngine());
        vo.setEdition(upload.getEdition());
        return vo;
    }

    private void persist(int subscription, String defaultUsage, String defaultBudget, String defaultOptimizer, MergeMode mode, Integer ramMultiplier, int size, AtomicInteger cursor, UploadContext context, boolean createUsage, boolean createBudget, boolean createOptimizer, VmUpload i) {
        if (StringUtils.isNotEmpty((CharSequence)i.getEngine())) {
            BiFunction<QuoteDatabaseEditionVo, UploadContext, Integer> merger = this.mergersDatabase.get(ObjectUtils.getIfNull((Object)((Object)mode), (Object)((Object)MergeMode.KEEP)));
            QuoteDatabaseEditionVo vo = this.copy(subscription, context, defaultUsage, defaultBudget, defaultOptimizer, ramMultiplier, createUsage, createBudget, createOptimizer, i, this.newDatabaseVo(i));
            vo.setPrice((Integer)((ProvDatabasePrice)this.qbResource.validateLookup("database", this.qbResource.lookup(context.quote, vo), vo.getName())).getId());
            this.persist(i, subscription, merger, context, vo, QuoteStorageQuery::setDatabase, ResourceType.DATABASE);
        } else {
            BiFunction<QuoteInstanceEditionVo, UploadContext, Integer> merger = this.mergersInstance.get(ObjectUtils.getIfNull((Object)((Object)mode), (Object)((Object)MergeMode.KEEP)));
            QuoteInstanceEditionVo vo = this.copy(subscription, context, defaultUsage, defaultBudget, defaultOptimizer, ramMultiplier, createUsage, createBudget, createOptimizer, i, this.newInstanceVo(i));
            vo.setPrice((Integer)((ProvInstancePrice)this.qiResource.validateLookup("instance", this.qiResource.lookup(context.quote, vo), vo.getName())).getId());
            this.persist(i, subscription, merger, context, vo, QuoteStorageQuery::setInstance, ResourceType.INSTANCE);
        }
        this.increment(cursor, size);
    }

    private <V extends AbstractQuoteVmEditionVo> void completeUsage(UploadContext context, String defaultValue, boolean create, VmUpload u, V vo) {
        vo.setUsage(this.completeProfile(context, defaultValue, create, u.getUsage(), this.usageRepository, context.quote.getUsages(), name -> {
            ProvUsage profile = new ProvUsage();
            profile.setRate(AbstractProvQuoteVmResource.USAGE_DEFAULT.getRate());
            return profile;
        }));
    }

    private <V extends AbstractQuoteVmEditionVo> void completeOptimizer(UploadContext context, String defaultValue, boolean create, VmUpload u, V vo) {
        vo.setOptimizer(this.completeProfile(context, defaultValue, create, u.getOptimizer(), this.optimizerRepository, context.quote.getOptimizers(), name -> {
            ProvOptimizer profile = new ProvOptimizer();
            profile.setMode(Optimizer.COST);
            return profile;
        }));
    }

    private <V extends AbstractQuoteVmEditionVo> void completeBudget(UploadContext context, String defaultValue, boolean create, VmUpload u, V vo) {
        vo.setBudget(this.completeProfile(context, defaultValue, create, u.getBudget(), this.budgetRepository, context.quote.getBudgets(), name -> new ProvBudget()));
    }

    private <G extends AbstractMultiScoped> String completeProfile(UploadContext context, String defaultProfile, boolean createProfile, String uploadName, BaseMultiScopedRepository<G> repository, List<G> allProfiles, Function<String, G> creator) {
        String name = Optional.ofNullable(uploadName).orElse(defaultProfile);
        if (name == null) {
            return null;
        }
        AbstractMultiScoped profile = allProfiles.stream().filter(u -> u.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
        if (profile == null) {
            if (!createProfile) {
                throw new EntityNotFoundException(name);
            }
            profile = (AbstractMultiScoped)((Object)creator.apply(name));
            profile.setName(name);
            profile.setConfiguration(context.quote);
            repository.saveAndFlush((Object)profile);
            allProfiles.add((G)((Object)profile));
        }
        return profile.getName();
    }

    private void increment(AtomicInteger cursor, int size) {
        int percent = (int)((double)cursor.incrementAndGet() * 100.0 / (double)size);
        if (cursor.get() > 1 && percent / 10 > (int)((double)(cursor.get() - 1) * 100.0 / (double)size) / 10) {
            log.info("Upload provisioning : importing {} entries, {}%", (Object)size, (Object)percent);
        }
    }

    private <V extends AbstractQuoteVmEditionVo> void persist(VmUpload upload, int subscription, BiFunction<V, UploadContext, Integer> merger, UploadContext context, V vo, ObjIntConsumer<QuoteStorageEditionVo> diskConsumer, ResourceType resourceType) {
        Integer id = merger.apply(vo, context);
        if (id == null) {
            return;
        }
        List<Integer> disks = IntStream.range(0, upload.getDisk().size()).filter(index -> upload.getDisk().get(index) > 0.0).mapToObj(index -> {
            int size = upload.getDisk().get(index).intValue();
            Integer sizeMax = upload.getDiskMax().size() > index ? Integer.valueOf(upload.getDiskMax().get(index).intValue()) : null;
            QuoteStorageEditionVo svo = new QuoteStorageEditionVo();
            svo.setName(vo.getName() + String.valueOf(index == 0 ? "" : Integer.valueOf(index)));
            diskConsumer.accept(svo, id);
            svo.setSize(size);
            svo.setSizeMax(sizeMax);
            svo.setLatency(this.getItem(upload.getLatency(), index));
            svo.setOptimized(this.getItem(upload.getOptimized(), index));
            svo.setType(((ProvStorageType)((ProvStoragePrice)((Object)((Object)((QuoteStorageLookup)this.storageResource.lookup(context.quote, (QuoteStorageQuery)svo).stream().findFirst().orElseThrow(() -> new ValidationJsonException("storage", (Serializable)((Object)"NotNull"), new Serializable[0]))).getPrice()))).getType()).getCode());
            svo.setSubscription(subscription);
            return this.storageResource.create(svo).getId();
        }).toList();
        Arrays.stream(StringUtils.split((String)((String)ObjectUtils.getIfNull((Object)upload.getTags(), (Object)"")), (String)",;|")).map(StringUtils::trimToNull).filter(Objects::nonNull).forEach(t -> {
            TagEditionVo tag = new TagEditionVo();
            String[] parts = StringUtils.splitPreserveAllTokens((String)(t + ":"), (char)':');
            tag.setName(parts[0].trim());
            tag.setValue(StringUtils.trimToNull((String)parts[1]));
            tag.setResource(id);
            tag.setType(resourceType);
            this.tagResource.create(subscription, tag);
            tag.setType(ResourceType.STORAGE);
            disks.forEach(d -> {
                tag.setResource((Integer)d);
                this.tagResource.create(subscription, tag);
            });
        });
    }

    private <T> T getItem(List<T> items, int index) {
        if (items.isEmpty()) {
            return null;
        }
        return items.get(Math.min(items.size() - 1, index));
    }

    private static class UploadContext {
        private Map<String, ProvQuoteInstance> previousQi;
        private Map<String, ProvQuoteDatabase> previousQb;
        private ProvQuote quote;

        private UploadContext() {
        }
    }
}

