/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.quote.support;

import jakarta.transaction.Transactional;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.ligoj.app.plugin.prov.AbstractProvQuoteResource;
import org.ligoj.app.plugin.prov.Floating;
import org.ligoj.app.plugin.prov.ProvResource;
import org.ligoj.app.plugin.prov.UpdatedCost;
import org.ligoj.app.plugin.prov.dao.BaseProvQuoteRepository;
import org.ligoj.app.plugin.prov.dao.BaseProvTypeRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteSupportRepository;
import org.ligoj.app.plugin.prov.dao.ProvSupportPriceRepository;
import org.ligoj.app.plugin.prov.dao.ProvSupportTypeRepository;
import org.ligoj.app.plugin.prov.model.Costed;
import org.ligoj.app.plugin.prov.model.ProvQuote;
import org.ligoj.app.plugin.prov.model.ProvQuoteSupport;
import org.ligoj.app.plugin.prov.model.ProvSupportPrice;
import org.ligoj.app.plugin.prov.model.ProvSupportType;
import org.ligoj.app.plugin.prov.model.Rate;
import org.ligoj.app.plugin.prov.model.ResourceType;
import org.ligoj.app.plugin.prov.model.SupportType;
import org.ligoj.app.plugin.prov.quote.support.QuoteSupportEditionVo;
import org.ligoj.app.plugin.prov.quote.support.QuoteSupportLookup;
import org.ligoj.bootstrap.core.DescribedBean;
import org.ligoj.bootstrap.core.IDescribableBean;
import org.ligoj.bootstrap.core.dao.RestRepository;
import org.ligoj.bootstrap.core.json.TableItem;
import org.ligoj.bootstrap.core.json.datatable.DataTableAttributes;
import org.ligoj.bootstrap.core.validation.ValidationJsonException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
@Path(value="/service/prov")
@Produces(value={"application/json"})
@Transactional
public class ProvQuoteSupportResource
extends AbstractProvQuoteResource<ProvSupportType, ProvSupportPrice, ProvQuoteSupport, QuoteSupportEditionVo> {
    @Autowired
    private ProvSupportTypeRepository stRepository;
    @Autowired
    private ProvSupportPriceRepository spRepository;
    @Autowired
    private ProvQuoteSupportRepository qsRepository;

    @Override
    @DELETE
    @Path(value="{subscription:\\d+}/support")
    @Consumes(value={"application/json"})
    public UpdatedCost deleteAll(@PathParam(value="subscription") int subscription) {
        return super.deleteAll(subscription);
    }

    @Override
    @POST
    @Path(value="support")
    @Consumes(value={"application/json"})
    public UpdatedCost create(QuoteSupportEditionVo vo) {
        return this.saveOrUpdate(new ProvQuoteSupport(), vo);
    }

    @Override
    @PUT
    @Path(value="support")
    @Consumes(value={"application/json"})
    public UpdatedCost update(QuoteSupportEditionVo vo) {
        return this.saveOrUpdate((ProvQuoteSupport)this.resource.findConfigured(this.qsRepository, (Integer)vo.getId()), vo);
    }

    @Override
    public Floating refresh(ProvQuoteSupport qs) {
        ProvQuote quote = qs.getConfiguration();
        qs.setPrice((ProvSupportPrice)this.validateLookup("support-plan", this.lookup(quote, qs.getSeats(), qs.getAccessApi(), qs.getAccessEmail(), qs.getAccessChat(), qs.getAccessPhone(), qs.getLevel()).stream().findFirst().orElse(null), qs.getName()));
        return this.updateCost(qs).round();
    }

    private ProvSupportPrice findByTypeName(int subscription, String name) {
        return this.assertFound(this.spRepository.findByTypeName(subscription, name), name);
    }

    private UpdatedCost saveOrUpdate(ProvQuoteSupport entity, QuoteSupportEditionVo vo) {
        DescribedBean.copy((IDescribableBean)vo, (IDescribableBean)entity);
        int subscription = vo.getSubscription();
        ProvQuote quote = this.getQuoteFromSubscription(subscription);
        entity.setName(vo.getName());
        entity.setDescription(vo.getDescription());
        entity.setConfiguration(quote);
        entity.setPrice(this.findByTypeName(subscription, vo.getType()));
        entity.setSeats(vo.getSeats());
        entity.setAccessApi(vo.getAccessApi());
        entity.setAccessEmail(vo.getAccessEmail());
        entity.setAccessChat(vo.getAccessChat());
        entity.setAccessPhone(vo.getAccessPhone());
        entity.setLevel(vo.getLevel());
        ProvSupportType type = (ProvSupportType)entity.getPrice().getType();
        if (this.lookup(quote, vo.getSeats(), vo.getAccessApi(), vo.getAccessEmail(), vo.getAccessChat(), vo.getAccessPhone(), vo.getLevel()).stream().map(qs -> (ProvSupportType)((ProvSupportPrice)qs.getPrice()).getType()).noneMatch(arg_0 -> ((ProvSupportType)type).equals(arg_0))) {
            throw new ValidationJsonException("type", (Serializable)((Object)"type-incompatible-requirements"), new Serializable[]{type.getName()});
        }
        UpdatedCost update = this.newUpdateCost(entity);
        super.saveOrUpdate(entity, vo);
        return update;
    }

    protected UpdatedCost newUpdateCost(ProvQuoteSupport entity) {
        return this.newUpdateCost(this.qsRepository, entity, this::updateCost);
    }

    @Override
    public <T extends Costed> void addCost(T entity, double old, double oldMax, double oldInitial, double oldMaxInitial, double oldCo2, double oldMaxCo2) {
        ProvQuote quote = (ProvQuote)entity.getConfiguration();
        quote.setCost(this.round(quote.getCost() + entity.getCost() - old));
        quote.setMaxCost(this.round(quote.getMaxCost() + entity.getMaxCost() - oldMax));
        quote.setCo2(this.round(quote.getCo2() + entity.getCo2() - oldCo2));
        quote.setMaxCo2(this.round(quote.getMaxCo2() + entity.getMaxCo2() - oldMaxCo2));
        quote.setCostSupport(this.round(quote.getCostSupport() + entity.getCost() - old));
        quote.setMaxCostSupport(this.round(quote.getMaxCostSupport() + entity.getMaxCost() - oldMax));
    }

    @Override
    @DELETE
    @Path(value="support/{id:\\d+}")
    @Consumes(value={"application/json"})
    public UpdatedCost delete(@PathParam(value="id") int id) {
        return super.delete(id);
    }

    @GET
    @Path(value="{subscription:\\d+}/support-type")
    @Consumes(value={"application/json"})
    public TableItem<ProvSupportType> findType(@PathParam(value="subscription") int subscription, @Context UriInfo uriInfo) {
        this.subscriptionResource.checkVisible(Integer.valueOf(subscription));
        return this.paginationJson.applyPagination(uriInfo, this.stRepository.findAll(subscription, DataTableAttributes.getSearch((UriInfo)uriInfo).toUpperCase(), (Pageable)this.paginationJson.getPageRequest(uriInfo, ProvResource.ORM_COLUMNS)), Function.identity());
    }

    @GET
    @Path(value="{subscription:\\d+}/support-lookup")
    @Consumes(value={"application/json"})
    public List<QuoteSupportLookup> lookup(@PathParam(value="subscription") int subscription, @QueryParam(value="seats") Integer seats, @QueryParam(value="access-api") SupportType accessApi, @QueryParam(value="access-email") SupportType accessEmail, @QueryParam(value="access-chat") SupportType accessChat, @QueryParam(value="access-phone") SupportType accessPhone, @QueryParam(value="level") Rate level) {
        return this.lookup(this.getQuoteFromSubscription(subscription), seats, accessApi, accessEmail, accessChat, accessPhone, level);
    }

    private List<QuoteSupportLookup> lookup(ProvQuote quote, Integer seats, SupportType accessApi, SupportType accessEmail, SupportType accessChat, SupportType accessPhone, Rate level) {
        String node = quote.getSubscription().getNode().getRefined().getId();
        return this.spRepository.findAll(node).stream().filter(sp -> ((ProvSupportType)sp.getType()).getSeats() == null || seats != null).filter(sp -> this.filter(accessApi, ((ProvSupportType)sp.getType()).getAccessApi())).filter(sp -> this.filter(accessChat, ((ProvSupportType)sp.getType()).getAccessChat())).filter(sp -> this.filter(accessEmail, ((ProvSupportType)sp.getType()).getAccessEmail())).filter(sp -> this.filter(accessPhone, ((ProvSupportType)sp.getType()).getAccessPhone())).filter(sp -> this.filter(level, ((ProvSupportType)sp.getType()).getLevel())).map(sp -> this.newPrice(quote, (ProvSupportPrice)sp, seats)).sorted((p1, p2) -> (int)(p1.getCost() - p2.getCost())).toList();
    }

    public boolean filter(SupportType quote, SupportType provided) {
        return quote == null || provided == SupportType.ALL || quote == provided;
    }

    public boolean filter(Rate quote, Rate provided) {
        return quote == null || provided != null && quote.ordinal() <= provided.ordinal();
    }

    private QuoteSupportLookup newPrice(ProvQuote quote, ProvSupportPrice price, Integer seats) {
        QuoteSupportLookup result = new QuoteSupportLookup();
        int[] rates = this.toIntArray(price.getRate());
        int[] limits = this.toIntArray(price.getLimit());
        result.setCost(this.round(this.getCost(seats, quote.getCostNoSupport(), price, rates, limits)));
        result.setPrice(price);
        result.setSeats(seats);
        return result;
    }

    @Override
    public Floating getCost(ProvQuoteSupport entity) {
        ProvQuote quote = entity.getConfiguration();
        ProvSupportPrice price = entity.getPrice();
        int[] rates = this.toIntArray(price.getRate());
        int[] limits = this.toIntArray(price.getLimit());
        Integer seats = entity.getSeats();
        return new Floating(this.getCost(seats, quote.getCostNoSupport(), price, rates, limits), this.getCost(seats, quote.getMaxCostNoSupport(), price, rates, limits), quote.getInitialCost(), quote.getMaxInitialCost(), quote.isUnboundCost(), 0.0, 0.0).round();
    }

    private Double getCost(Integer seats, double cost, ProvSupportPrice price, int[] rates, int[] limits) {
        int nb = Math.max(1, Optional.ofNullable(((ProvSupportType)price.getType()).getSeats()).map(s -> (int)Math.ceil((double)seats.intValue() / (double)s.intValue())).orElse(1));
        return (double)nb * (this.computeRates(cost, price.getMin(), rates, limits) + price.getCost());
    }

    private int[] toIntArray(String rawString) {
        return Arrays.stream(StringUtils.split((String)((String)ObjectUtils.getIfNull((Object)rawString, (Object)"")), (String)",")).mapToInt(Integer::parseInt).toArray();
    }

    public double computeRates(double cost, int min, int[] rates, int[] limits) {
        double support = 0.0;
        int i = rates.length;
        while (i-- > 0) {
            support += Math.max(0.0, Math.min(cost, i > limits.length - 1 ? 2.147483647E9 : (double)limits[i]) - (double)(i == 0 ? 0 : limits[i - 1])) / 100.0 * (double)rates[i];
        }
        return Math.max((double)min, support);
    }

    @Override
    protected ResourceType getType() {
        return ResourceType.SUPPORT;
    }

    @Override
    public RestRepository<ProvSupportPrice, Integer> getIpRepository() {
        return this.spRepository;
    }

    @Override
    public BaseProvQuoteRepository<ProvQuoteSupport> getQiRepository() {
        return this.qsRepository;
    }

    @Override
    public BaseProvTypeRepository<ProvSupportType> getItRepository() {
        return this.stRepository;
    }
}

