/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.quote.storage;

import jakarta.transaction.Transactional;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.ligoj.app.plugin.prov.AbstractProvQuoteResource;
import org.ligoj.app.plugin.prov.AbstractProvQuoteVmResource;
import org.ligoj.app.plugin.prov.Floating;
import org.ligoj.app.plugin.prov.ProvResource;
import org.ligoj.app.plugin.prov.UpdatedCost;
import org.ligoj.app.plugin.prov.dao.BaseProvQuoteRepository;
import org.ligoj.app.plugin.prov.dao.BaseProvTypeRepository;
import org.ligoj.app.plugin.prov.dao.ProvLocationRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteContainerRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteDatabaseRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteFunctionRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteInstanceRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteStorageRepository;
import org.ligoj.app.plugin.prov.dao.ProvStoragePriceRepository;
import org.ligoj.app.plugin.prov.dao.ProvStorageTypeRepository;
import org.ligoj.app.plugin.prov.model.AbstractQuote;
import org.ligoj.app.plugin.prov.model.AbstractQuoteVm;
import org.ligoj.app.plugin.prov.model.ProvLocation;
import org.ligoj.app.plugin.prov.model.ProvQuote;
import org.ligoj.app.plugin.prov.model.ProvQuoteContainer;
import org.ligoj.app.plugin.prov.model.ProvQuoteDatabase;
import org.ligoj.app.plugin.prov.model.ProvQuoteFunction;
import org.ligoj.app.plugin.prov.model.ProvQuoteInstance;
import org.ligoj.app.plugin.prov.model.ProvQuoteStorage;
import org.ligoj.app.plugin.prov.model.ProvStoragePrice;
import org.ligoj.app.plugin.prov.model.ProvStorageType;
import org.ligoj.app.plugin.prov.model.QuoteStorage;
import org.ligoj.app.plugin.prov.model.ResourceType;
import org.ligoj.app.plugin.prov.quote.storage.QuoteStorageEditionVo;
import org.ligoj.app.plugin.prov.quote.storage.QuoteStorageLookup;
import org.ligoj.app.plugin.prov.quote.storage.QuoteStorageQuery;
import org.ligoj.bootstrap.core.DescribedBean;
import org.ligoj.bootstrap.core.IDescribableBean;
import org.ligoj.bootstrap.core.dao.RestRepository;
import org.ligoj.bootstrap.core.json.TableItem;
import org.ligoj.bootstrap.core.json.datatable.DataTableAttributes;
import org.ligoj.bootstrap.core.validation.ValidationJsonException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
@Path(value="/service/prov")
@Produces(value={"application/json"})
@Transactional
public class ProvQuoteStorageResource
extends AbstractProvQuoteResource<ProvStorageType, ProvStoragePrice, ProvQuoteStorage, QuoteStorageEditionVo> {
    @Autowired
    private ProvQuoteInstanceRepository qiRepository;
    @Autowired
    private ProvQuoteDatabaseRepository qbRepository;
    @Autowired
    private ProvQuoteContainerRepository qcRepository;
    @Autowired
    private ProvQuoteFunctionRepository qfRepository;
    @Autowired
    private ProvQuoteStorageRepository qsRepository;
    @Autowired
    private ProvStorageTypeRepository stRepository;
    @Autowired
    private ProvStoragePriceRepository spRepository;
    @Autowired
    private ProvLocationRepository locationRepository;

    @Override
    @POST
    @Path(value="storage")
    @Consumes(value={"application/json"})
    public UpdatedCost create(QuoteStorageEditionVo vo) {
        return this.saveOrUpdate(new ProvQuoteStorage(), vo);
    }

    @Override
    @PUT
    @Path(value="storage")
    @Consumes(value={"application/json"})
    public UpdatedCost update(QuoteStorageEditionVo vo) {
        return this.saveOrUpdate((ProvQuoteStorage)this.resource.findConfigured(this.qsRepository, vo.getId()), vo);
    }

    @Override
    public Floating refresh(ProvQuoteStorage qs) {
        ProvQuote quote = qs.getConfiguration();
        qs.setPrice((ProvStoragePrice)((Object)this.validateLookup("storage", this.lookup(quote, qs).stream().findFirst().orElse(null), qs.getName())));
        return this.updateCost(qs);
    }

    private ProvStoragePrice findByTypeCode(int subscription, String code, ProvLocation location, ProvQuote quote) {
        return this.assertFound(this.spRepository.findByTypeCode(subscription, code, (Integer)Optional.ofNullable(location).orElse(quote.getLocation()).getId()), code);
    }

    private UpdatedCost saveOrUpdate(ProvQuoteStorage entity, QuoteStorageEditionVo vo) {
        this.checkInstance(vo);
        DescribedBean.copy((IDescribableBean)vo, (IDescribableBean)entity);
        int subscription = vo.getSubscription();
        ProvQuote quote = this.getQuoteFromSubscription(subscription);
        String node = quote.getSubscription().getNode().getRefined().getId();
        entity.setConfiguration(quote);
        entity.setLocation(this.resource.findLocation(node, vo.getLocation()));
        entity.setLatency(vo.getLatency());
        entity.setOptimized(vo.getOptimized());
        entity.setSize(vo.getSize());
        entity.setQuantity((Integer)ObjectUtils.getIfNull((Object)vo.getQuantity(), (Object)1));
        entity.setSizeMax(vo.getSizeMax());
        entity.setQuoteInstance(this.checkInstance(subscription, vo.getInstance()));
        entity.setQuoteDatabase(this.checkDatabase(subscription, vo.getDatabase()));
        entity.setQuoteContainer(this.checkContainer(subscription, vo.getContainer()));
        entity.setQuoteFunction(this.checkFunction(subscription, vo.getFunction()));
        ProvLocation resolvedLocation = Objects.requireNonNullElseGet(entity.getLocation(), () -> ((AbstractQuote)Objects.requireNonNullElse(entity.getQuoteResource(), entity)).getResolvedLocation());
        entity.setPrice(this.findByTypeCode(subscription, vo.getType(), resolvedLocation, quote));
        ProvStorageType type = (ProvStorageType)entity.getPrice().getType();
        if (this.lookup(quote, entity).stream().map(qs -> (ProvStorageType)((ProvStoragePrice)((Object)((Object)qs.getPrice()))).getType()).noneMatch(arg_0 -> ((ProvStorageType)type).equals(arg_0))) {
            throw new ValidationJsonException("type", (Serializable)((Object)"type-incompatible-requirements"), new Serializable[]{type.getCode()});
        }
        UpdatedCost cost = this.refreshCost(entity);
        Optional.ofNullable(entity.getQuoteResource()).ifPresent(qi -> cost.getRelated().put(qi.getResourceType(), Collections.singletonMap((Integer)qi.getId(), qi.toFloating())));
        super.saveOrUpdate(entity, vo);
        return this.resource.refreshSupportCost(cost, quote);
    }

    public UpdatedCost refreshCost(ProvQuoteStorage entity) {
        return this.newUpdateCost(this.qsRepository, entity, this::updateCost);
    }

    private void checkInstance(QuoteStorageEditionVo vo) {
        Stream.of(vo.getInstance(), vo.getDatabase(), vo.getContainer(), vo.getFunction()).filter(Objects::nonNull).skip(1L).findFirst().ifPresent(id -> {
            throw new ValidationJsonException("instance", (Serializable)((Object)"ambiguous-instance-database-container-function"), new Serializable[]{id});
        });
    }

    private ProvQuoteInstance checkInstance(int subscription, Integer qi) {
        return qi == null ? null : this.resource.findConfigured(this.qiRepository, qi, subscription);
    }

    private ProvQuoteDatabase checkDatabase(int subscription, Integer qb) {
        return qb == null ? null : this.resource.findConfigured(this.qbRepository, qb, subscription);
    }

    private ProvQuoteContainer checkContainer(int subscription, Integer qc) {
        return qc == null ? null : this.resource.findConfigured(this.qcRepository, qc, subscription);
    }

    private ProvQuoteFunction checkFunction(int subscription, Integer qf) {
        return qf == null ? null : this.resource.findConfigured(this.qfRepository, qf, subscription);
    }

    @Override
    @DELETE
    @Path(value="{subscription:\\d+}/storage")
    @Consumes(value={"application/json"})
    public UpdatedCost deleteAll(@PathParam(value="subscription") int subscription) {
        return super.deleteAll(subscription);
    }

    @Override
    @DELETE
    @Path(value="storage/{id:\\d+}")
    @Consumes(value={"application/json"})
    public UpdatedCost delete(@PathParam(value="id") int id) {
        return super.delete(id);
    }

    @GET
    @Path(value="{subscription:\\d+}/storage-type")
    @Consumes(value={"application/json"})
    public TableItem<ProvStorageType> findType(@PathParam(value="subscription") int subscription, @Context UriInfo uriInfo) {
        this.subscriptionResource.checkVisible(Integer.valueOf(subscription));
        return this.paginationJson.applyPagination(uriInfo, this.stRepository.findAll(subscription, DataTableAttributes.getSearch((UriInfo)uriInfo).toUpperCase(), (Pageable)this.paginationJson.getPageRequest(uriInfo, ProvResource.ORM_COLUMNS)), Function.identity());
    }

    @GET
    @Path(value="{subscription:\\d+}/storage-lookup")
    @Consumes(value={"application/json"})
    public List<QuoteStorageLookup> lookup(@PathParam(value="subscription") int subscription, @BeanParam QuoteStorageQuery query) {
        return this.lookup(this.getQuoteFromSubscription(subscription), query);
    }

    private List<QuoteStorageLookup> lookup(ProvQuote quote, ProvQuoteStorage qs) {
        return this.lookup(quote, qs, qs.getQuoteInstance(), qs.getQuoteDatabase(), qs.getQuoteContainer(), qs.getQuoteFunction());
    }

    public List<QuoteStorageLookup> lookup(ProvQuote configuration, QuoteStorageQuery query) {
        ProvQuoteInstance qi = this.checkInstance((Integer)configuration.getSubscription().getId(), query.getInstance());
        ProvQuoteDatabase qb = this.checkDatabase((Integer)configuration.getSubscription().getId(), query.getDatabase());
        ProvQuoteContainer qc = this.checkContainer((Integer)configuration.getSubscription().getId(), query.getContainer());
        ProvQuoteFunction qf = this.checkFunction((Integer)configuration.getSubscription().getId(), query.getFunction());
        return this.lookup(configuration, query, qi, qb, qc, qf);
    }

    private int getLocation(String node, QuoteStorage query, int defaultLocation) {
        return query.getLocationName() == null ? defaultLocation : this.normalize(this.locationRepository.toId(node, query.getLocationName()));
    }

    private List<QuoteStorageLookup> lookup(ProvQuote configuration, QuoteStorage query, ProvQuoteInstance qi, ProvQuoteDatabase qb, ProvQuoteContainer qc, ProvQuoteFunction qf) {
        int qsLoc;
        int qLoc;
        String node = configuration.getSubscription().getNode().getRefined().getId();
        AbstractQuoteVm attachment = Stream.of(qi, qb, qc, qf).filter(Objects::nonNull).findFirst().orElse(null);
        if (attachment == null) {
            qLoc = 0;
            qsLoc = this.getLocation(node, query, (Integer)configuration.getLocation().getId());
        } else {
            qLoc = attachment.getLocation() == null ? ((Integer)configuration.getLocation().getId()).intValue() : ((Integer)attachment.getLocation().getId()).intValue();
            qsLoc = this.getLocation(node, query, qLoc);
        }
        return this.spRepository.findLowestPrice(node, query.getSize(), this.normalize(query.getLatency()), this.normalize(qi), this.normalize(qb), qb == null ? "" : this.normalize(qb.getPrice().getStorageEngine()), this.normalize(qc), this.normalize(qf), query.getOptimized(), qsLoc, qLoc, (Pageable)PageRequest.of((int)0, (int)10)).stream().map(spx -> (ProvStoragePrice)((Object)((Object)spx[0]))).map(sp -> this.newPrice((ProvStoragePrice)((Object)sp), query.getSize(), this.getCost((ProvStoragePrice)((Object)sp), query.getSize()))).toList();
    }

    private QuoteStorageLookup newPrice(ProvStoragePrice sp, int size, double cost) {
        QuoteStorageLookup result = new QuoteStorageLookup();
        result.setCost(cost);
        result.setPrice(sp);
        result.setSize(size);
        return result;
    }

    @Override
    protected Floating getCost(ProvQuoteStorage qs) {
        double quantity = ((Integer)ObjectUtils.getIfNull((Object)qs.getQuantity(), (Object)1)).intValue();
        double base = this.getCost(qs.getPrice(), qs.getSize()) * quantity;
        double baseCo2 = this.getCo2(qs.getPrice(), qs.getSize()) * quantity;
        return Optional.ofNullable(qs.getQuoteResource()).map(qr -> AbstractProvQuoteVmResource.computeFloat(base, baseCo2, 0.0, qr)).orElseGet(() -> new Floating(base, baseCo2));
    }

    private double getCost(ProvStoragePrice storagePrice, int size) {
        double increment = (Double)ObjectUtils.getIfNull((Object)((ProvStorageType)storagePrice.getType()).getIncrement(), (Object)1.0);
        return this.round(Math.ceil(this.round(Math.max((double)size, ((ProvStorageType)storagePrice.getType()).getMinimal()) / increment)) * increment * storagePrice.getCostGb() + storagePrice.getCost());
    }

    private double getCo2(ProvStoragePrice storagePrice, int size) {
        double increment = (Double)ObjectUtils.getIfNull((Object)((ProvStorageType)storagePrice.getType()).getIncrement(), (Object)1.0);
        return this.round(Math.ceil(this.round(Math.max((double)size, ((ProvStorageType)storagePrice.getType()).getMinimal()) / increment)) * increment * 0.0 + storagePrice.getCo2());
    }

    @Override
    protected ResourceType getType() {
        return ResourceType.STORAGE;
    }

    @Override
    public RestRepository<ProvStoragePrice, Integer> getIpRepository() {
        return this.spRepository;
    }

    @Override
    public BaseProvQuoteRepository<ProvQuoteStorage> getQiRepository() {
        return this.qsRepository;
    }

    @Override
    public BaseProvTypeRepository<ProvStorageType> getItRepository() {
        return this.stRepository;
    }
}

