/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.quote.instance;

import jakarta.transaction.Transactional;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.ligoj.app.plugin.prov.Floating;
import org.ligoj.app.plugin.prov.ProvResource;
import org.ligoj.app.plugin.prov.QuoteVo;
import org.ligoj.app.plugin.prov.TagVo;
import org.ligoj.app.plugin.prov.model.AbstractCodedEntity;
import org.ligoj.app.plugin.prov.model.AbstractPrice;
import org.ligoj.app.plugin.prov.model.AbstractQuote;
import org.ligoj.app.plugin.prov.model.ProvQuoteStorage;
import org.ligoj.app.plugin.prov.model.ResourceType;
import org.ligoj.app.resource.plugin.AbstractToolPluginResource;
import org.ligoj.app.resource.subscription.SubscriptionResource;
import org.ligoj.bootstrap.core.INamableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Path(value="/service/prov")
@Produces(value={"application/json"})
@Transactional
public class ProvQuoteInstanceExportResource {
    @Autowired
    protected ProvResource resource;
    @Autowired
    private SubscriptionResource subscriptionResource;

    @GET
    @Path(value="{subscription:\\d+}/{file:.*-instances-inline-storage-.*\\.csv}")
    @Produces(value={"application/octet-stream"})
    public Response exportInline(@PathParam(value="subscription") int subscription, @PathParam(value="file") String file) {
        QuoteVo vo = this.resource.getConfiguration(this.subscriptionResource.checkVisible(Integer.valueOf(subscription)));
        return AbstractToolPluginResource.download(output -> {
            try (PrintWriter writer = new PrintWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));){
                HashMap qsByQi = new HashMap();
                HashMap qsByQb = new HashMap();
                HashMap qsByQc = new HashMap();
                HashMap qsByQf = new HashMap();
                Map<Integer, List<TagVo>> itags = vo.getTags().get((Object)ResourceType.INSTANCE);
                Map<Integer, List<TagVo>> dtags = vo.getTags().get((Object)ResourceType.DATABASE);
                Map<Integer, List<TagVo>> ctags = vo.getTags().get((Object)ResourceType.CONTAINER);
                Map<Integer, List<TagVo>> ftags = vo.getTags().get((Object)ResourceType.FUNCTION);
                Map<Integer, List<TagVo>> stags = vo.getTags().get((Object)ResourceType.STORAGE);
                vo.getStorages().stream().filter(qs -> qs.getInstance() != null).forEach(qs -> qsByQi.computeIfAbsent(qs.getInstance(), ArrayList::new).add(qs));
                vo.getStorages().stream().filter(qs -> qs.getDatabase() != null).forEach(qs -> qsByQb.computeIfAbsent(qs.getDatabase(), ArrayList::new).add(qs));
                vo.getStorages().stream().filter(qs -> qs.getContainer() != null).forEach(qs -> qsByQc.computeIfAbsent(qs.getContainer(), ArrayList::new).add(qs));
                vo.getStorages().stream().filter(qs -> qs.getFunction() != null).forEach(qs -> qsByQf.computeIfAbsent(qs.getFunction(), ArrayList::new).add(qs));
                int max = Stream.of(qsByQi, qsByQb, qsByQc).mapToInt(qsBy -> qsBy.values().stream().mapToInt(List::size).max().orElse(0)).max().orElse(0);
                writer.format("%s" + ";%s".repeat(34), "resource-type", "name", "cpu", "cpuMax", "gpu", "gpuMax", "ram", "ramMax", "os", "usage", "budget", "optimizer", "term", "location", "min", "max", "maxVariableCost", "workload", "processor", "physical", "ephemeral", "type", "engine", "edition", "internet", "license", "cost", "tags", "disk", "diskMax", "diskType", "diskLatency", "diskOptimized", "diskCost", "diskTags");
                IntStream.range(1, max).forEach(i -> writer.format(";disk%d;disk%dMax;disk%dType;disk%dLatency;disk%dOptimized;disk%dCost;disk%dTags", i, i, i, i, i, i, i));
                vo.getInstances().forEach(qi -> {
                    writer.format("\n%s" + ";%s".repeat(27), new Object[]{ResourceType.INSTANCE, this.toString((INamableBean<?>)qi), this.toString(qi.getCpu()), this.toString(qi.getCpuMax()), this.toString(qi.getGpu()), this.toString(qi.getGpuMax()), this.toString(qi.getRam()), this.toString(qi.getRamMax()), qi.getOs(), this.toString((INamableBean<?>)qi.getUsage()), this.toString((INamableBean<?>)qi.getBudget()), this.toString((INamableBean<?>)qi.getOptimizer()), this.toString((INamableBean<?>)qi.getPrice().getTerm()), this.toString((INamableBean<?>)qi.getLocation()), qi.getMinQuantity(), this.toString(qi.getMaxQuantity()), this.toString(qi.getMaxVariableCost()), this.toString(qi.getWorkload()), this.toString(qi.getProcessor()), this.toString(qi.getPhysical()), qi.isEphemeral(), this.toType((AbstractQuote<?>)qi), "", "", qi.getInternet(), this.toString(qi.getLicense()), this.toString(qi.getCost()), this.toString((INamableBean<Integer>)qi, itags)});
                    this.writeStorage(writer, qsByQi, stags, (Integer)qi.getId());
                });
                vo.getDatabases().forEach(qi -> {
                    writer.format("\n%s" + ";%s".repeat(27), new Object[]{ResourceType.DATABASE, this.toString((INamableBean<?>)qi), this.toString(qi.getCpu()), this.toString(qi.getCpuMax()), this.toString(qi.getGpu()), this.toString(qi.getGpuMax()), this.toString(qi.getRam()), this.toString(qi.getRamMax()), "", this.toString((INamableBean<?>)qi.getUsage()), this.toString((INamableBean<?>)qi.getBudget()), this.toString((INamableBean<?>)qi.getOptimizer()), this.toString((INamableBean<?>)qi.getPrice().getTerm()), this.toString((INamableBean<?>)qi.getLocation()), qi.getMinQuantity(), this.toString(qi.getMaxQuantity()), "", this.toString(qi.getWorkload()), this.toString(qi.getProcessor()), this.toString(qi.getPhysical()), "", this.toType((AbstractQuote<?>)qi), qi.getEngine(), this.toString(qi.getEdition()), qi.getInternet(), this.toString(qi.getLicense()), this.toString(qi.getCost()), this.toString((INamableBean<Integer>)qi, dtags)});
                    this.writeStorage(writer, qsByQb, stags, (Integer)qi.getId());
                });
                vo.getContainers().forEach(qc -> {
                    writer.format("\n%s" + ";%s".repeat(27), new Object[]{ResourceType.CONTAINER, this.toString((INamableBean<?>)qc), this.toString(qc.getCpu()), this.toString(qc.getCpuMax()), this.toString(qc.getGpu()), this.toString(qc.getGpuMax()), this.toString(qc.getRam()), this.toString(qc.getRamMax()), qc.getOs(), this.toString((INamableBean<?>)qc.getUsage()), this.toString((INamableBean<?>)qc.getBudget()), this.toString((INamableBean<?>)qc.getOptimizer()), this.toString((INamableBean<?>)qc.getPrice().getTerm()), this.toString((INamableBean<?>)qc.getLocation()), qc.getMinQuantity(), this.toString(qc.getMaxQuantity()), this.toString(qc.getMaxVariableCost()), this.toString(qc.getWorkload()), this.toString(qc.getProcessor()), this.toString(qc.getPhysical()), qc.isEphemeral(), this.toType((AbstractQuote<?>)qc), "", "", qc.getInternet(), this.toString(qc.getLicense()), this.toString(qc.getCost()), this.toString((INamableBean<Integer>)qc, ctags)});
                    this.writeStorage(writer, qsByQc, stags, (Integer)qc.getId());
                });
                vo.getFunctions().forEach(qf -> {
                    writer.format("\n%s" + ";%s".repeat(27), new Object[]{ResourceType.FUNCTION, this.toString((INamableBean<?>)qf), this.toString(qf.getCpu()), this.toString(qf.getCpuMax()), this.toString(qf.getGpu()), this.toString(qf.getGpuMax()), this.toString(qf.getRam()), this.toString(qf.getRamMax()), qf.getRuntime(), this.toString((INamableBean<?>)qf.getUsage()), this.toString((INamableBean<?>)qf.getBudget()), this.toString((INamableBean<?>)qf.getOptimizer()), this.toString((INamableBean<?>)qf.getPrice().getTerm()), this.toString((INamableBean<?>)qf.getLocation()), qf.getNbRequests(), "", "", this.toString(qf.getWorkload()), this.toString(qf.getProcessor()), this.toString(qf.getPhysical()), qf.isEphemeral(), this.toType((AbstractQuote<?>)qf), "", "", qf.getInternet(), "", this.toString(qf.getCost()), this.toString((INamableBean<Integer>)qf, ftags)});
                    this.writeStorage(writer, qsByQf, stags, (Integer)qf.getId());
                });
                writer.flush();
            }
        }, (String)file).build();
    }

    private void writeStorage(PrintWriter writer, Map<Integer, List<ProvQuoteStorage>> qsByQi, Map<Integer, List<TagVo>> stags, Integer qi) {
        qsByQi.getOrDefault(qi, Collections.emptyList()).forEach(qs -> writer.format(";%s".repeat(7), qs.getSize(), this.toString(qs.getSizeMax()), this.toType((AbstractQuote<?>)qs), this.toString((Object)qs.getLatency()), this.toString((Object)qs.getOptimized()), this.toString(qs.getCost()), this.toString((INamableBean<Integer>)qs, stags)));
    }

    @GET
    @Path(value="{subscription:\\d+}/{file:.*-split-.*\\.csv}")
    @Produces(value={"application/octet-stream"})
    public Response exportSplit(@PathParam(value="subscription") int subscription, @PathParam(value="file") String file) {
        QuoteVo vo = this.resource.getConfiguration(this.subscriptionResource.checkVisible(Integer.valueOf(subscription)));
        return AbstractToolPluginResource.download(output -> {
            try (PrintWriter writer = new PrintWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));){
                writer.format("%s" + ";%s".repeat(33), "name", "cpu", "cpuMax", "gpu", "gpuMax", "ram", "ramMax", "os", "usage", "budget", "optimizer", "term", "location", "min", "max", "maxVariableCost", "workload", "processor", "physical", "ephemeral", "type", "internet", "license", "cost", "tags", "disk", "diskMax", "instance", "database", "latency", "optimized", "engine", "edition", "seats");
                Map<Integer, List<TagVo>> iTags = vo.getTags().get((Object)ResourceType.INSTANCE);
                vo.getInstances().forEach(qi -> writer.format("\n%s" + ";%s".repeat(24), new Object[]{this.toString((INamableBean<?>)qi), this.toString(qi.getCpu()), this.toString(qi.getCpuMax()), this.toString(qi.getGpu()), this.toString(qi.getGpuMax()), this.toString(qi.getRam()), this.toString(qi.getRamMax()), qi.getOs(), this.toString((INamableBean<?>)qi.getUsage()), this.toString((INamableBean<?>)qi.getBudget()), this.toString((INamableBean<?>)qi.getOptimizer()), this.toString((INamableBean<?>)qi.getPrice().getTerm()), this.toString((INamableBean<?>)qi.getLocation()), qi.getMinQuantity(), this.toString(qi.getMaxQuantity()), this.toString(qi.getMaxVariableCost()), this.toString(qi.getWorkload()), this.toString(qi.getProcessor()), this.toString(qi.getPhysical()), qi.isEphemeral(), this.toType((AbstractQuote<?>)qi), qi.getInternet(), this.toString(qi.getLicense()), this.toString(qi.getCost()), this.toString((INamableBean<Integer>)qi, iTags)}));
                Map<Integer, List<TagVo>> cTags = vo.getTags().get((Object)ResourceType.CONTAINER);
                vo.getContainers().forEach(qc -> writer.format("\n%s" + ";%s".repeat(24), new Object[]{this.toString((INamableBean<?>)qc), this.toString(qc.getCpu()), this.toString(qc.getCpuMax()), this.toString(qc.getGpu()), this.toString(qc.getGpuMax()), this.toString(qc.getRam()), this.toString(qc.getRamMax()), qc.getOs(), this.toString((INamableBean<?>)qc.getUsage()), this.toString((INamableBean<?>)qc.getBudget()), this.toString((INamableBean<?>)qc.getOptimizer()), this.toString((INamableBean<?>)qc.getPrice().getTerm()), this.toString((INamableBean<?>)qc.getLocation()), qc.getMinQuantity(), this.toString(qc.getMaxQuantity()), this.toString(qc.getMaxVariableCost()), this.toString(qc.getWorkload()), this.toString(qc.getProcessor()), this.toString(qc.getPhysical()), qc.isEphemeral(), this.toType((AbstractQuote<?>)qc), qc.getInternet(), this.toString(qc.getLicense()), this.toString(qc.getCost()), this.toString((INamableBean<Integer>)qc, cTags)}));
                Map<Integer, List<TagVo>> fTags = vo.getTags().get((Object)ResourceType.FUNCTION);
                vo.getFunctions().forEach(qf -> writer.format("\n%s" + ";%s".repeat(24), new Object[]{this.toString((INamableBean<?>)qf), this.toString(qf.getCpu()), this.toString(qf.getCpuMax()), this.toString(qf.getGpu()), this.toString(qf.getGpuMax()), this.toString(qf.getRam()), this.toString(qf.getRamMax()), qf.getRuntime(), this.toString((INamableBean<?>)qf.getUsage()), this.toString((INamableBean<?>)qf.getBudget()), this.toString((INamableBean<?>)qf.getOptimizer()), this.toString((INamableBean<?>)qf.getPrice().getTerm()), this.toString((INamableBean<?>)qf.getLocation()), qf.getNbRequests(), "", "", this.toString(qf.getWorkload()), this.toString(qf.getProcessor()), this.toString(qf.getPhysical()), qf.isEphemeral(), this.toType((AbstractQuote<?>)qf), qf.getInternet(), "", this.toString(qf.getCost()), this.toString((INamableBean<Integer>)qf, fTags)}));
                Map<Integer, List<TagVo>> dTags = vo.getTags().get((Object)ResourceType.DATABASE);
                vo.getDatabases().forEach(qi -> writer.format("\n%s" + ";%s".repeat(24) + ";;;;;;%s;%s", this.toString((INamableBean<?>)qi), this.toString(qi.getCpu()), this.toString(qi.getCpuMax()), this.toString(qi.getGpu()), this.toString(qi.getGpuMax()), this.toString(qi.getRam()), this.toString(qi.getRamMax()), "", this.toString((INamableBean<?>)qi.getUsage()), this.toString((INamableBean<?>)qi.getBudget()), this.toString((INamableBean<?>)qi.getOptimizer()), this.toString((INamableBean<?>)qi.getPrice().getTerm()), this.toString((INamableBean<?>)qi.getLocation()), qi.getMinQuantity(), this.toString(qi.getMaxQuantity()), "", this.toString(qi.getWorkload()), this.toString(qi.getProcessor()), this.toString(qi.getPhysical()), "", this.toType((AbstractQuote<?>)qi), "", this.toString(qi.getLicense()), this.toString(qi.getCost()), this.toString((INamableBean<Integer>)qi, dTags), qi.getEngine(), this.toString(qi.getEdition())));
                Map<Integer, List<TagVo>> sTags = vo.getTags().get((Object)ResourceType.STORAGE);
                vo.getStorages().forEach(qs -> writer.format("\n%s;;;;;;;;;;;;;%s;;;;;;;%s;;" + ";%s".repeat(8), this.toString((INamableBean<?>)qs), this.toString((INamableBean<?>)qs.getLocation()), this.toType((AbstractQuote<?>)qs), this.toString(qs.getCost()), this.toString((INamableBean<Integer>)qs, sTags), qs.getSize(), this.toString(qs.getSizeMax()), this.toString((INamableBean<?>)qs.getQuoteInstance()), this.toString((INamableBean<?>)qs.getQuoteDatabase()), this.toString((Object)qs.getLatency()), this.toString((Object)qs.getOptimized())));
                Map<Integer, List<TagVo>> s2Tags = vo.getTags().get((Object)ResourceType.SUPPORT);
                vo.getSupports().forEach(qs -> writer.format("\n%s;;;;;;;;;;;;;;;;;;;;%s;;;%s;%s;;;;;;;;%s", this.toString((INamableBean<?>)qs), this.toType((AbstractQuote<?>)qs), this.toString(qs.getCost()), this.toString((INamableBean<Integer>)qs, s2Tags), this.toString(qs.getSeats())));
                writer.flush();
            }
        }, (String)file).build();
    }

    private String toType(AbstractQuote<?> resource) {
        return ((AbstractCodedEntity)((AbstractPrice)((Object)resource.getPrice())).getType()).getCode();
    }

    private String toString(INamableBean<?> optional) {
        return optional == null ? "" : optional.getName();
    }

    private String toString(Object optional) {
        return optional == null ? "" : optional.toString();
    }

    private String toString(INamableBean<Integer> qi, Map<Integer, List<TagVo>> tags) {
        return tags == null ? "" : this.toString((Collection)tags.get(qi.getId()));
    }

    private String toString(Collection<?> optional) {
        return CollectionUtils.emptyIfNull(optional).stream().map(Object::toString).collect(Collectors.joining(","));
    }

    private String toString(Double optional) {
        return optional == null ? "" : String.valueOf(Floating.round(optional)).replace('.', ',').replaceFirst(",0$", "");
    }
}

