/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.quote.function;

import jakarta.transaction.Transactional;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import lombok.Generated;
import org.ligoj.app.plugin.prov.AbstractProvQuoteVmResource;
import org.ligoj.app.plugin.prov.Floating;
import org.ligoj.app.plugin.prov.UpdatedCost;
import org.ligoj.app.plugin.prov.dao.Optimizer;
import org.ligoj.app.plugin.prov.dao.ProvFunctionPriceRepository;
import org.ligoj.app.plugin.prov.dao.ProvFunctionTypeRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteFunctionRepository;
import org.ligoj.app.plugin.prov.model.ProvFunctionPrice;
import org.ligoj.app.plugin.prov.model.ProvFunctionType;
import org.ligoj.app.plugin.prov.model.ProvInstancePriceTerm;
import org.ligoj.app.plugin.prov.model.ProvQuote;
import org.ligoj.app.plugin.prov.model.ProvQuoteFunction;
import org.ligoj.app.plugin.prov.model.QuoteFunction;
import org.ligoj.app.plugin.prov.model.ResourceType;
import org.ligoj.app.plugin.prov.quote.function.QuoteFunctionEditionVo;
import org.ligoj.app.plugin.prov.quote.function.QuoteFunctionLookup;
import org.ligoj.app.plugin.prov.quote.function.QuoteFunctionQuery;
import org.ligoj.bootstrap.core.json.TableItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
@Path(value="/service/prov")
@Produces(value={"application/json"})
@Transactional
public class ProvQuoteFunctionResource
extends AbstractProvQuoteVmResource<ProvFunctionType, ProvFunctionPrice, ProvQuoteFunction, QuoteFunctionEditionVo, QuoteFunctionLookup, QuoteFunction> {
    private static final double MILLIS_PER_MONTH = 2.628E9;
    private static final double CONCURRENCY_PER_MONTH = 2628.0;
    @Autowired
    private ProvFunctionPriceRepository ipRepository;
    @Autowired
    private ProvQuoteFunctionRepository qiRepository;
    @Autowired
    private ProvFunctionTypeRepository itRepository;

    @Override
    protected ResourceType getType() {
        return ResourceType.FUNCTION;
    }

    @Override
    @POST
    @Path(value="function")
    @Consumes(value={"application/json"})
    public UpdatedCost create(QuoteFunctionEditionVo vo) {
        return this.saveOrUpdate(new ProvQuoteFunction(), vo);
    }

    @Override
    @PUT
    @Path(value="function")
    @Consumes(value={"application/json"})
    public UpdatedCost update(QuoteFunctionEditionVo vo) {
        return super.update(vo);
    }

    @Override
    @DELETE
    @Path(value="{subscription:\\d+}/function")
    @Consumes(value={"application/json"})
    public UpdatedCost deleteAll(@PathParam(value="subscription") int subscription) {
        return super.deleteAll(subscription);
    }

    @Override
    @DELETE
    @Path(value="function/{id:\\d+}")
    @Consumes(value={"application/json"})
    public UpdatedCost delete(@PathParam(value="id") int id) {
        return super.delete(id);
    }

    @GET
    @Path(value="{subscription:\\d+}/function-lookup")
    @Consumes(value={"application/json"})
    public QuoteFunctionLookup lookup(@PathParam(value="subscription") int subscription, @BeanParam QuoteFunctionQuery query) {
        return (QuoteFunctionLookup)this.lookupInternal(subscription, query);
    }

    @Override
    protected List<Object[]> findLowestPrice(ProvQuote configuration, QuoteFunction query, List<Integer> types, List<Integer> terms, int location, double rate, double duration, double initialCost, Optimizer optimizer) {
        if (optimizer == Optimizer.CO2) {
            return this.ipRepository.findLowestCo2(types, terms, location, rate, duration, initialCost, query.getDuration(), (Pageable)PageRequest.of((int)0, (int)1));
        }
        return this.ipRepository.findLowestCost(types, terms, location, rate, duration, initialCost, query.getDuration(), (Pageable)PageRequest.of((int)0, (int)1));
    }

    @Override
    protected List<Object[]> findLowestDynamicPrice(ProvQuote configuration, QuoteFunction query, List<Integer> types, List<Integer> terms, double cpu, double gpu, double ram, int location, double rate, int duration, double initialCost, Optimizer optimizer) {
        List<Object[]> result1 = this.findLowestDynamicPrice(query, types, terms, cpu, ram, location, rate, duration, initialCost, optimizer, Math.floor(query.getConcurrency()), Math.floor(query.getConcurrency()));
        if (!result1.isEmpty() && query.getConcurrency() != Math.floor(query.getConcurrency())) {
            List<Object[]> result2 = this.findLowestDynamicPrice(query, types, terms, cpu, ram, location, rate, duration, initialCost, optimizer, query.getConcurrency(), Math.ceil(query.getConcurrency()));
            if (this.toTotalCost(result1.getFirst()) > this.toTotalCost(result2.getFirst())) {
                return result2;
            }
        }
        return result1;
    }

    private List<Object[]> findLowestDynamicPrice(QuoteFunction query, List<Integer> types, List<Integer> terms, double cpu, double ram, int location, double rate, int duration, double initialCost, Optimizer optimizer, double realConcurrency, double reservedConcurrency) {
        if (optimizer == Optimizer.CO2) {
            return this.ipRepository.findLowestDynamicCo2(types, terms, Math.ceil(Math.max(1.0, cpu)), Math.max(1.0, ram) / 1024.0, location, rate, this.round(rate * (double)duration), duration, initialCost, query.getNbRequests(), realConcurrency, reservedConcurrency, query.getDuration(), 2628.0, 1.0, (Pageable)PageRequest.of((int)0, (int)1));
        }
        return this.ipRepository.findLowestDynamicCost(types, terms, Math.ceil(Math.max(1.0, cpu)), Math.max(1.0, ram) / 1024.0, location, rate, this.round(rate * (double)duration), duration, initialCost, query.getNbRequests(), realConcurrency, reservedConcurrency, query.getDuration(), 2628.0, 1.0, (Pageable)PageRequest.of((int)0, (int)1));
    }

    @Override
    @GET
    @Path(value="{subscription:\\d+}/function-price-term")
    @Consumes(value={"application/json"})
    public TableItem<ProvInstancePriceTerm> findPriceTerms(@PathParam(value="subscription") int subscription, @Context UriInfo uriInfo) {
        return super.findPriceTerms(subscription, uriInfo);
    }

    @Override
    @GET
    @Path(value="{subscription:\\d+}/function-type")
    @Consumes(value={"application/json"})
    public TableItem<ProvFunctionType> findAllTypes(@PathParam(value="subscription") int subscription, @Context UriInfo uriInfo) {
        return super.findAllTypes(subscription, uriInfo);
    }

    @Override
    protected QuoteFunctionLookup newPrice(Object[] rs) {
        QuoteFunctionLookup result = new QuoteFunctionLookup();
        result.setPrice((ProvFunctionPrice)rs[0]);
        result.setCost(this.round((Double)rs[2]));
        result.setCo2(this.round((Double)rs[4]));
        return result;
    }

    @Override
    protected void saveOrUpdateSpec(ProvQuoteFunction entity, QuoteFunctionEditionVo vo) {
        entity.setRuntime(vo.getRuntime());
        entity.setConcurrency(vo.getConcurrency());
        entity.setDuration(vo.getDuration());
        entity.setNbRequests(vo.getNbRequests());
    }

    @Override
    protected Floating getCost(ProvQuoteFunction qi, ProvFunctionPrice ip) {
        Floating baseCost = super.getCost(qi, ip).multiply(Math.max(1.0, qi.getConcurrency()));
        double rate = this.getRate(qi, ip);
        double duration = Math.ceil(Math.max(ip.getMinDuration(), (double)qi.getDuration()) / ip.getIncrementDuration()) * ip.getIncrementDuration();
        double billedReqDuration = duration * qi.getNbRequests();
        double costRamConcurrency = Math.min(qi.getConcurrency() * rate, billedReqDuration / 2628.0) * ip.getCostRamRequestConcurrency();
        double costRamRequest = Math.max(0.0, billedReqDuration / 2628.0 - qi.getConcurrency() * rate) * ip.getCostRamRequest();
        double costRequest = ip.getCostRequests() * qi.getNbRequests();
        double co2Request = ip.getCo2Requests() * qi.getNbRequests();
        return baseCost.add(ProvQuoteFunctionResource.computeFloat(costRamRequest, 0.0, 0.0, qi)).add(ProvQuoteFunctionResource.computeFloat(costRamConcurrency, 0.0, 0.0, qi)).add(ProvQuoteFunctionResource.computeFloat(costRequest, co2Request, 0.0, qi));
    }

    @Override
    @Generated
    public ProvFunctionPriceRepository getIpRepository() {
        return this.ipRepository;
    }

    @Generated
    public ProvQuoteFunctionRepository getQiRepository() {
        return this.qiRepository;
    }

    @Override
    @Generated
    public ProvFunctionTypeRepository getItRepository() {
        return this.itRepository;
    }
}

