/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.quote.container;

import jakarta.transaction.Transactional;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import lombok.Generated;
import org.ligoj.app.plugin.prov.AbstractProvQuoteInstanceOsResource;
import org.ligoj.app.plugin.prov.ProvisioningService;
import org.ligoj.app.plugin.prov.UpdatedCost;
import org.ligoj.app.plugin.prov.dao.Optimizer;
import org.ligoj.app.plugin.prov.dao.ProvContainerPriceRepository;
import org.ligoj.app.plugin.prov.dao.ProvContainerTypeRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteContainerRepository;
import org.ligoj.app.plugin.prov.model.ProvContainerPrice;
import org.ligoj.app.plugin.prov.model.ProvContainerType;
import org.ligoj.app.plugin.prov.model.ProvInstancePriceTerm;
import org.ligoj.app.plugin.prov.model.ProvQuote;
import org.ligoj.app.plugin.prov.model.ProvQuoteContainer;
import org.ligoj.app.plugin.prov.model.QuoteContainer;
import org.ligoj.app.plugin.prov.model.ResourceType;
import org.ligoj.app.plugin.prov.model.VmOs;
import org.ligoj.app.plugin.prov.quote.container.QuoteContainerEditionVo;
import org.ligoj.app.plugin.prov.quote.container.QuoteContainerLookup;
import org.ligoj.app.plugin.prov.quote.container.QuoteContainerQuery;
import org.ligoj.bootstrap.core.json.TableItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
@Path(value="/service/prov")
@Produces(value={"application/json"})
@Transactional
public class ProvQuoteContainerResource
extends AbstractProvQuoteInstanceOsResource<ProvContainerType, ProvContainerPrice, ProvQuoteContainer, QuoteContainerEditionVo, QuoteContainerLookup, QuoteContainer> {
    @Autowired
    private ProvContainerPriceRepository ipRepository;
    @Autowired
    private ProvQuoteContainerRepository qiRepository;
    @Autowired
    private ProvContainerTypeRepository itRepository;

    @Override
    protected ResourceType getType() {
        return ResourceType.CONTAINER;
    }

    @Override
    @POST
    @Path(value="container")
    @Consumes(value={"application/json"})
    public UpdatedCost create(QuoteContainerEditionVo vo) {
        return this.saveOrUpdate(new ProvQuoteContainer(), vo);
    }

    @Override
    @PUT
    @Path(value="container")
    @Consumes(value={"application/json"})
    public UpdatedCost update(QuoteContainerEditionVo vo) {
        return super.update(vo);
    }

    @Override
    @DELETE
    @Path(value="{subscription:\\d+}/container")
    @Consumes(value={"application/json"})
    public UpdatedCost deleteAll(@PathParam(value="subscription") int subscription) {
        return super.deleteAll(subscription);
    }

    @Override
    @DELETE
    @Path(value="container/{id:\\d+}")
    @Consumes(value={"application/json"})
    public UpdatedCost delete(@PathParam(value="id") int id) {
        return super.delete(id);
    }

    @GET
    @Path(value="{subscription:\\d+}/container-lookup")
    @Consumes(value={"application/json"})
    public QuoteContainerLookup lookup(@PathParam(value="subscription") int subscription, @BeanParam QuoteContainerQuery query) {
        return (QuoteContainerLookup)this.lookupInternal(subscription, query);
    }

    @Override
    protected List<Object[]> findLowestPrice(ProvQuote configuration, QuoteContainer query, List<Integer> types, List<Integer> terms, int location, double rate, double duration, double initialCost, Optimizer optimizer) {
        ProvisioningService service = this.getService(configuration);
        VmOs os = service.getCatalogOs(query.getOs());
        String licenseR = this.normalize(this.getLicense(configuration, query.getLicense(), os, x$0 -> this.canByol((VmOs)((Object)x$0))));
        if (optimizer == Optimizer.CO2) {
            return this.ipRepository.findLowestCo2(types, terms, os, location, rate, duration, licenseR, initialCost, (Pageable)PageRequest.of((int)0, (int)1));
        }
        return this.ipRepository.findLowestCost(types, terms, os, location, rate, duration, licenseR, initialCost, (Pageable)PageRequest.of((int)0, (int)1));
    }

    @Override
    protected List<Object[]> findLowestDynamicPrice(ProvQuote configuration, QuoteContainer query, List<Integer> types, List<Integer> terms, double cpu, double gpu, double ram, int location, double rate, int duration, double initialCost, Optimizer optimizer) {
        ProvisioningService service = this.getService(configuration);
        VmOs os = service.getCatalogOs(query.getOs());
        String licenseR = this.normalize(this.getLicense(configuration, query.getLicense(), os, x$0 -> this.canByol((VmOs)((Object)x$0))));
        if (optimizer == Optimizer.CO2) {
            return this.ipRepository.findLowestDynamicCo2(types, terms, Math.ceil(Math.max(1.0, cpu)), gpu, Math.ceil(this.round(ram / 1024.0)), os, location, rate, this.round(rate * (double)duration), duration, licenseR, initialCost, (Pageable)PageRequest.of((int)0, (int)1));
        }
        return this.ipRepository.findLowestDynamicCost(types, terms, Math.ceil(Math.max(1.0, cpu)), gpu, Math.ceil(this.round(ram / 1024.0)), os, location, rate, this.round(rate * (double)duration), duration, licenseR, initialCost, (Pageable)PageRequest.of((int)0, (int)1));
    }

    @Override
    @GET
    @Path(value="{subscription:\\d+}/container-price-term")
    @Consumes(value={"application/json"})
    public TableItem<ProvInstancePriceTerm> findPriceTerms(@PathParam(value="subscription") int subscription, @Context UriInfo uriInfo) {
        return super.findPriceTerms(subscription, uriInfo);
    }

    @Override
    @GET
    @Path(value="{subscription:\\d+}/container-license/{os}")
    public List<String> findLicenses(@PathParam(value="subscription") int subscription, @PathParam(value="os") VmOs os) {
        return super.findLicenses(subscription, os);
    }

    @Override
    @GET
    @Path(value="{subscription:\\d+}/container-os")
    public List<String> findOs(@PathParam(value="subscription") int subscription) {
        return super.findOs(subscription);
    }

    @Override
    @GET
    @Path(value="{subscription:\\d+}/container-type")
    @Consumes(value={"application/json"})
    public TableItem<ProvContainerType> findAllTypes(@PathParam(value="subscription") int subscription, @Context UriInfo uriInfo) {
        return super.findAllTypes(subscription, uriInfo);
    }

    @Override
    protected QuoteContainerLookup newPrice(Object[] rs) {
        QuoteContainerLookup result = new QuoteContainerLookup();
        result.setPrice((ProvContainerPrice)rs[0]);
        result.setCost(this.round((Double)rs[2]));
        result.setCo2(this.round((Double)rs[4]));
        return result;
    }

    @Override
    @Generated
    public ProvContainerPriceRepository getIpRepository() {
        return this.ipRepository;
    }

    @Generated
    public ProvQuoteContainerRepository getQiRepository() {
        return this.qiRepository;
    }

    @Override
    @Generated
    public ProvContainerTypeRepository getItRepository() {
        return this.itRepository;
    }
}

