/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.ligoj.app.model.Configurable;
import org.ligoj.app.plugin.prov.model.ProvQuote;
import org.ligoj.app.plugin.prov.model.ResourceType;
import org.ligoj.bootstrap.core.INamableBean;
import org.ligoj.bootstrap.core.model.AbstractPersistable;

@Entity
@Table(name="LIGOJ_PROV_NETWORK", uniqueConstraints={@UniqueConstraint(columnNames={"source", "source_type", "target", "target_type", "port", "configuration"})})
@JsonIgnoreProperties(value={"id"})
public class ProvNetwork
extends AbstractPersistable<Integer>
implements Configurable<ProvQuote, Integer>,
INamableBean<Integer> {
    private static final long serialVersionUID = 1L;
    @Size(min=1, max=255)
    private @Size(min=1, max=255) String name;
    @NotNull
    private Integer source;
    @NotNull
    private ResourceType sourceType;
    @NotNull
    private Integer target;
    @NotNull
    private ResourceType targetType;
    @Range(min=1L, max=65535L)
    private @Range(min=1L, max=65535L) Integer port;
    @PositiveOrZero
    private Integer rate;
    @PositiveOrZero
    private Integer throughput;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JsonIgnore
    private ProvQuote configuration;

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getSource() {
        return this.source;
    }

    @Generated
    public ResourceType getSourceType() {
        return this.sourceType;
    }

    @Generated
    public Integer getTarget() {
        return this.target;
    }

    @Generated
    public ResourceType getTargetType() {
        return this.targetType;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public Integer getRate() {
        return this.rate;
    }

    @Generated
    public Integer getThroughput() {
        return this.throughput;
    }

    @Generated
    public ProvQuote getConfiguration() {
        return this.configuration;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setSource(Integer source) {
        this.source = source;
    }

    @Generated
    public void setSourceType(ResourceType sourceType) {
        this.sourceType = sourceType;
    }

    @Generated
    public void setTarget(Integer target) {
        this.target = target;
    }

    @Generated
    public void setTargetType(ResourceType targetType) {
        this.targetType = targetType;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setRate(Integer rate) {
        this.rate = rate;
    }

    @Generated
    public void setThroughput(Integer throughput) {
        this.throughput = throughput;
    }

    @JsonIgnore
    @Generated
    public void setConfiguration(ProvQuote configuration) {
        this.configuration = configuration;
    }
}

