/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.dao;

import java.util.List;
import org.ligoj.app.plugin.prov.dao.BaseProvTermPriceRepository;
import org.ligoj.app.plugin.prov.model.ProvFunctionPrice;
import org.ligoj.app.plugin.prov.model.ProvFunctionType;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;

public interface ProvFunctionPriceRepository
extends BaseProvTermPriceRepository<ProvFunctionType, ProvFunctionPrice> {
    public static final String DYNAMIC_QUERY = "SELECT  ip,\n    (  CASE WHEN ip.period = 0 THEN CAST(:globalRate AS Double) ELSE (ip.period * CEIL(:duration / ip.period)) END\n     * (  ip.cost\n        + (  CEIL(GREATEST(ip.minCpu, :cpu) / ip.incrementCpu)\n           * ip.incrementCpu\n           * ip.costCpu\n           * CAST(:reservedConcurrency AS Double)\n          )\n       )\n    )\n  + (  CEIL(GREATEST(GREATEST(ip.minCpu, :cpu) * COALESCE(ip.minRamRatio, 0.0), :ram) / ip.incrementRam)\n     * ip.incrementRam\n     * (\n         (  ip.costRam\n          * CASE WHEN ip.period = 0 THEN CAST(:globalRate AS Double) ELSE (ip.period * CEIL(:duration / ip.period)) END\n          * CAST(:reservedConcurrency AS Double)\n         )\n       + (  CASE WHEN ip.period = 0 THEN :duration ELSE (ip.period * CEIL(:duration / ip.period)) END\n          * (\n              (  LEAST(CEIL(GREATEST(ip.minDuration, :requestDuration) / ip.incrementDuration)\n                    * ip.incrementDuration\n                    * :nbRequests\n                    / :concurrencyMonth,\n                      :realConcurrency\n                    * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END\n                 )\n            * ip.costRamRequestConcurrency\n           )\n         + (  GREATEST(CEIL(GREATEST(ip.minDuration, :requestDuration) / ip.incrementDuration)\n                    * ip.incrementDuration\n                    * :nbRequests\n                    / :concurrencyMonth\n                  -   :realConcurrency\n                    * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END,\n                    0.0\n                 )\n            * ip.costRamRequest\n           )\n         )\n      )\n    )\n    )\n  + (  :nbRequests\n     * ip.costRequests\n  \t  * CASE WHEN ip.period = 0 THEN :duration ELSE (ip.period * CEIL(:duration / ip.period)) END\n ) AS totalCost,\n\n    (  CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END\n     * (  ip.cost\n        + (  CEIL(GREATEST(ip.minCpu, :cpu) / ip.incrementCpu)\n           * ip.incrementCpu\n           * ip.costCpu\n           * CAST(:reservedConcurrency AS Double)\n          )\n       )\n    )\n  + (  CEIL(GREATEST(GREATEST(ip.minCpu, :cpu) * COALESCE(ip.minRamRatio, 0.0), :ram) / ip.incrementRam)\n     * ip.incrementRam\n     * (\n         (  ip.costRam\n          * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END\n          * CAST(:reservedConcurrency AS Double)\n         )\n       + (\n           (  LEAST(CEIL(GREATEST(ip.minDuration, :requestDuration) / ip.incrementDuration)\n                 * ip.incrementDuration\n                 * :nbRequests\n                 / :concurrencyMonth,\n                   :realConcurrency\n                 * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END\n              )\n         * ip.costRamRequestConcurrency\n        )\n      + (  GREATEST(CEIL(GREATEST(ip.minDuration, :requestDuration) / ip.incrementDuration)\n                 * ip.incrementDuration\n                 * :nbRequests\n                 / :concurrencyMonth\n               -   :realConcurrency\n                 * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END,\n                 0.0\n               )\n         * ip.costRamRequest\n        )\n      )\n    )\n    )\n  + ( :nbRequests * ip.costRequests ) AS monthlyCost,\n\n    (  CASE WHEN ip.period = 0 THEN CAST(:globalRate AS Double) ELSE (ip.period * CEIL(:duration / ip.period)) END\n     * (  ip.co2\n        + (  CEIL(GREATEST(ip.minCpu, :cpu) / ip.incrementCpu)\n           * ip.incrementCpu\n           * ip.co2Cpu\n           * CAST(:reservedConcurrency AS Double)\n          )\n       )\n    )\n  + (  CEIL(GREATEST(GREATEST(ip.minCpu, :cpu) * COALESCE(ip.minRamRatio, 0.0), :ram) / ip.incrementRam)\n     * ip.incrementRam\n     * (\n         (  ip.co2Ram\n          * CASE WHEN ip.period = 0 THEN CAST(:globalRate AS Double) ELSE (ip.period * CEIL(:duration / ip.period)) END\n          * CAST(:reservedConcurrency AS Double)\n         )\n       + (  CASE WHEN ip.period = 0 THEN :duration ELSE (ip.period * CEIL(:duration / ip.period)) END\n          * (\n              (  LEAST(CEIL(GREATEST(ip.minDuration, :requestDuration) / ip.incrementDuration)\n                    * ip.incrementDuration\n                    * :nbRequests\n                    / :concurrencyMonth,\n                      :realConcurrency\n                    * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END\n                 )\n            * ip.co2RamRequestConcurrency\n           )\n         + (  GREATEST(CEIL(GREATEST(ip.minDuration, :requestDuration) / ip.incrementDuration)\n                    * ip.incrementDuration\n                    * :nbRequests\n                    / :concurrencyMonth\n                  -   :realConcurrency\n                    * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END,\n                    0.0\n                 )\n            * ip.co2RamRequest\n           )\n         )\n      )\n    )\n    )\n  + (  :nbRequests\n     * ip.co2Requests\n  \t  * CASE WHEN ip.period = 0 THEN :duration ELSE (ip.period * CEIL(:duration / ip.period)) END\n ) AS totalCo2,\n\n    (  CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END\n     * (  ip.co2\n        + (  CEIL(GREATEST(ip.minCpu, :cpu) / ip.incrementCpu)\n           * ip.incrementCpu\n           * ip.co2Cpu\n           * CAST(:reservedConcurrency AS Double)\n          )\n       )\n    )\n  + (  CEIL(GREATEST(GREATEST(ip.minCpu, :cpu) * COALESCE(ip.minRamRatio, 0.0), :ram) / ip.incrementRam)\n     * ip.incrementRam\n     * (\n         (  ip.co2Ram\n          * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END\n          * CAST(:reservedConcurrency AS Double)\n         )\n       + (\n           (  LEAST(CEIL(GREATEST(ip.minDuration, :requestDuration) / ip.incrementDuration)\n                 * ip.incrementDuration\n                 * :nbRequests\n                 / :concurrencyMonth,\n                   :realConcurrency\n                 * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END\n              )\n         * ip.co2RamRequestConcurrency\n        )\n      + (  GREATEST(CEIL(GREATEST(ip.minDuration, :requestDuration) / ip.incrementDuration)\n                 * ip.incrementDuration\n                 * :nbRequests\n                 / :concurrencyMonth\n               -   :realConcurrency\n                 * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END,\n                 0.0\n               )\n         * ip.co2RamRequest\n        )\n      )\n    )\n    )\n  + ( :nbRequests * ip.co2Requests ) AS monthlyCo2\n\nFROM ProvFunctionPrice ip WHERE\n     ip.location.id = :location\n AND ip.incrementCpu IS NOT NULL\n AND ip.incrementRam IS NOT NULL\n AND (ip.maxCpu IS NULL or ip.maxCpu >= :cpu)\n AND (ip.maxRam IS NULL OR ip.maxRam >= :ram)\n AND (ip.maxDuration IS NULL OR ip.maxDuration >= :requestDuration)\n AND (ip.maxRamRatio IS NULL OR GREATEST(ip.minCpu, :cpu) * ip.maxRamRatio <= :ram)\n AND (ip.costRamRequestConcurrency = 0.0 AND :reservedConcurrency = 0.0 OR ip.costRamRequestConcurrency > 0.0 AND :reservedConcurrency > 0.0)\n AND (ip.initialCost IS NULL OR :initialCost >= ip.initialCost)\n AND (ip.type.id IN :types) AND (ip.term.id IN :terms)\n";
    public static final String LOWEST_QUERY = "SELECT ip,\n (CASE\n  WHEN ip.period = 0 THEN (ip.cost * :rate * :duration)\n  ELSE (ip.costPeriod * ceil(:duration/ip.period)) END) AS totalCost,\n (CASE\n  WHEN ip.period = 0 THEN (ip.cost * :rate)\n  ELSE ip.cost END) AS monthlyCost,\n (CASE\n  WHEN ip.period = 0 THEN (ip.co2 * :rate * :duration)\n  ELSE (ip.co2Period * ceil(:duration/ip.period)) END) AS totalCo2,\n (CASE\n  WHEN ip.period = 0 THEN (ip.co2 * :rate)\n  ELSE ip.co2 END) AS monthlyCo2\n FROM #{#entityName} ip WHERE\n      ip.location.id = :location\n  AND ip.incrementCpu IS NULL\n  AND (ip.type.id IN :types)\n  AND (ip.term.id IN :terms)\n  AND (ip.initialCost IS NULL OR :initialCost >= ip.initialCost)\n  AND (ip.maxDuration IS NULL OR ip.maxDuration >= :requestDuration)\n";

    @Query(value="SELECT  ip,\n    (  CASE WHEN ip.period = 0 THEN CAST(:globalRate AS Double) ELSE (ip.period * CEIL(:duration / ip.period)) END\n     * (  ip.cost\n        + (  CEIL(GREATEST(ip.minCpu, :cpu) / ip.incrementCpu)\n           * ip.incrementCpu\n           * ip.costCpu\n           * CAST(:reservedConcurrency AS Double)\n          )\n       )\n    )\n  + (  CEIL(GREATEST(GREATEST(ip.minCpu, :cpu) * COALESCE(ip.minRamRatio, 0.0), :ram) / ip.incrementRam)\n     * ip.incrementRam\n     * (\n         (  ip.costRam\n          * CASE WHEN ip.period = 0 THEN CAST(:globalRate AS Double) ELSE (ip.period * CEIL(:duration / ip.period)) END\n          * CAST(:reservedConcurrency AS Double)\n         )\n       + (  CASE WHEN ip.period = 0 THEN :duration ELSE (ip.period * CEIL(:duration / ip.period)) END\n          * (\n              (  LEAST(CEIL(GREATEST(ip.minDuration, :requestDuration) / ip.incrementDuration)\n                    * ip.incrementDuration\n                    * :nbRequests\n                    / :concurrencyMonth,\n                      :realConcurrency\n                    * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END\n                 )\n            * ip.costRamRequestConcurrency\n           )\n         + (  GREATEST(CEIL(GREATEST(ip.minDuration, :requestDuration) / ip.incrementDuration)\n                    * ip.incrementDuration\n                    * :nbRequests\n                    / :concurrencyMonth\n                  -   :realConcurrency\n                    * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END,\n                    0.0\n                 )\n            * ip.costRamRequest\n           )\n         )\n      )\n    )\n    )\n  + (  :nbRequests\n     * ip.costRequests\n  \t  * CASE WHEN ip.period = 0 THEN :duration ELSE (ip.period * CEIL(:duration / ip.period)) END\n ) AS totalCost,\n\n    (  CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END\n     * (  ip.cost\n        + (  CEIL(GREATEST(ip.minCpu, :cpu) / ip.incrementCpu)\n           * ip.incrementCpu\n           * ip.costCpu\n           * CAST(:reservedConcurrency AS Double)\n          )\n       )\n    )\n  + (  CEIL(GREATEST(GREATEST(ip.minCpu, :cpu) * COALESCE(ip.minRamRatio, 0.0), :ram) / ip.incrementRam)\n     * ip.incrementRam\n     * (\n         (  ip.costRam\n          * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END\n          * CAST(:reservedConcurrency AS Double)\n         )\n       + (\n           (  LEAST(CEIL(GREATEST(ip.minDuration, :requestDuration) / ip.incrementDuration)\n                 * ip.incrementDuration\n                 * :nbRequests\n                 / :concurrencyMonth,\n                   :realConcurrency\n                 * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END\n              )\n         * ip.costRamRequestConcurrency\n        )\n      + (  GREATEST(CEIL(GREATEST(ip.minDuration, :requestDuration) / ip.incrementDuration)\n                 * ip.incrementDuration\n                 * :nbRequests\n                 / :concurrencyMonth\n               -   :realConcurrency\n                 * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END,\n                 0.0\n               )\n         * ip.costRamRequest\n        )\n      )\n    )\n    )\n  + ( :nbRequests * ip.costRequests ) AS monthlyCost,\n\n    (  CASE WHEN ip.period = 0 THEN CAST(:globalRate AS Double) ELSE (ip.period * CEIL(:duration / ip.period)) END\n     * (  ip.co2\n        + (  CEIL(GREATEST(ip.minCpu, :cpu) / ip.incrementCpu)\n           * ip.incrementCpu\n           * ip.co2Cpu\n           * CAST(:reservedConcurrency AS Double)\n          )\n       )\n    )\n  + (  CEIL(GREATEST(GREATEST(ip.minCpu, :cpu) * COALESCE(ip.minRamRatio, 0.0), :ram) / ip.incrementRam)\n     * ip.incrementRam\n     * (\n         (  ip.co2Ram\n          * CASE WHEN ip.period = 0 THEN CAST(:globalRate AS Double) ELSE (ip.period * CEIL(:duration / ip.period)) END\n          * CAST(:reservedConcurrency AS Double)\n         )\n       + (  CASE WHEN ip.period = 0 THEN :duration ELSE (ip.period * CEIL(:duration / ip.period)) END\n          * (\n              (  LEAST(CEIL(GREATEST(ip.minDuration, :requestDuration) / ip.incrementDuration)\n                    * ip.incrementDuration\n                    * :nbRequests\n                    / :concurrencyMonth,\n                      :realConcurrency\n                    * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END\n                 )\n            * ip.co2RamRequestConcurrency\n           )\n         + (  GREATEST(CEIL(GREATEST(ip.minDuration, :requestDuration) / ip.incrementDuration)\n                    * ip.incrementDuration\n                    * :nbRequests\n                    / :concurrencyMonth\n                  -   :realConcurrency\n                    * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END,\n                    0.0\n                 )\n            * ip.co2RamRequest\n           )\n         )\n      )\n    )\n    )\n  + (  :nbRequests\n     * ip.co2Requests\n  \t  * CASE WHEN ip.period = 0 THEN :duration ELSE (ip.period * CEIL(:duration / ip.period)) END\n ) AS totalCo2,\n\n    (  CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END\n     * (  ip.co2\n        + (  CEIL(GREATEST(ip.minCpu, :cpu) / ip.incrementCpu)\n           * ip.incrementCpu\n           * ip.co2Cpu\n           * CAST(:reservedConcurrency AS Double)\n          )\n       )\n    )\n  + (  CEIL(GREATEST(GREATEST(ip.minCpu, :cpu) * COALESCE(ip.minRamRatio, 0.0), :ram) / ip.incrementRam)\n     * ip.incrementRam\n     * (\n         (  ip.co2Ram\n          * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END\n          * CAST(:reservedConcurrency AS Double)\n         )\n       + (\n           (  LEAST(CEIL(GREATEST(ip.minDuration, :requestDuration) / ip.incrementDuration)\n                 * ip.incrementDuration\n                 * :nbRequests\n                 / :concurrencyMonth,\n                   :realConcurrency\n                 * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END\n              )\n         * ip.co2RamRequestConcurrency\n        )\n      + (  GREATEST(CEIL(GREATEST(ip.minDuration, :requestDuration) / ip.incrementDuration)\n                 * ip.incrementDuration\n                 * :nbRequests\n                 / :concurrencyMonth\n               -   :realConcurrency\n                 * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END,\n                 0.0\n               )\n         * ip.co2RamRequest\n        )\n      )\n    )\n    )\n  + ( :nbRequests * ip.co2Requests ) AS monthlyCo2\n\nFROM ProvFunctionPrice ip WHERE\n     ip.location.id = :location\n AND ip.incrementCpu IS NOT NULL\n AND ip.incrementRam IS NOT NULL\n AND (ip.maxCpu IS NULL or ip.maxCpu >= :cpu)\n AND (ip.maxRam IS NULL OR ip.maxRam >= :ram)\n AND (ip.maxDuration IS NULL OR ip.maxDuration >= :requestDuration)\n AND (ip.maxRamRatio IS NULL OR GREATEST(ip.minCpu, :cpu) * ip.maxRamRatio <= :ram)\n AND (ip.costRamRequestConcurrency = 0.0 AND :reservedConcurrency = 0.0 OR ip.costRamRequestConcurrency > 0.0 AND :reservedConcurrency > 0.0)\n AND (ip.initialCost IS NULL OR :initialCost >= ip.initialCost)\n AND (ip.type.id IN :types) AND (ip.term.id IN :terms)\n ORDER BY totalCost ASC, totalCo2 ASC, ip.type.id DESC, ip.maxCpu ASC\n")
    public List<Object[]> findLowestDynamicCost(List<Integer> var1, List<Integer> var2, double var3, double var5, int var7, double var8, double var10, double var12, double var14, double var16, double var18, double var20, double var22, double var24, double var26, Pageable var28);

    @Query(value="SELECT  ip,\n    (  CASE WHEN ip.period = 0 THEN CAST(:globalRate AS Double) ELSE (ip.period * CEIL(:duration / ip.period)) END\n     * (  ip.cost\n        + (  CEIL(GREATEST(ip.minCpu, :cpu) / ip.incrementCpu)\n           * ip.incrementCpu\n           * ip.costCpu\n           * CAST(:reservedConcurrency AS Double)\n          )\n       )\n    )\n  + (  CEIL(GREATEST(GREATEST(ip.minCpu, :cpu) * COALESCE(ip.minRamRatio, 0.0), :ram) / ip.incrementRam)\n     * ip.incrementRam\n     * (\n         (  ip.costRam\n          * CASE WHEN ip.period = 0 THEN CAST(:globalRate AS Double) ELSE (ip.period * CEIL(:duration / ip.period)) END\n          * CAST(:reservedConcurrency AS Double)\n         )\n       + (  CASE WHEN ip.period = 0 THEN :duration ELSE (ip.period * CEIL(:duration / ip.period)) END\n          * (\n              (  LEAST(CEIL(GREATEST(ip.minDuration, :requestDuration) / ip.incrementDuration)\n                    * ip.incrementDuration\n                    * :nbRequests\n                    / :concurrencyMonth,\n                      :realConcurrency\n                    * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END\n                 )\n            * ip.costRamRequestConcurrency\n           )\n         + (  GREATEST(CEIL(GREATEST(ip.minDuration, :requestDuration) / ip.incrementDuration)\n                    * ip.incrementDuration\n                    * :nbRequests\n                    / :concurrencyMonth\n                  -   :realConcurrency\n                    * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END,\n                    0.0\n                 )\n            * ip.costRamRequest\n           )\n         )\n      )\n    )\n    )\n  + (  :nbRequests\n     * ip.costRequests\n  \t  * CASE WHEN ip.period = 0 THEN :duration ELSE (ip.period * CEIL(:duration / ip.period)) END\n ) AS totalCost,\n\n    (  CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END\n     * (  ip.cost\n        + (  CEIL(GREATEST(ip.minCpu, :cpu) / ip.incrementCpu)\n           * ip.incrementCpu\n           * ip.costCpu\n           * CAST(:reservedConcurrency AS Double)\n          )\n       )\n    )\n  + (  CEIL(GREATEST(GREATEST(ip.minCpu, :cpu) * COALESCE(ip.minRamRatio, 0.0), :ram) / ip.incrementRam)\n     * ip.incrementRam\n     * (\n         (  ip.costRam\n          * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END\n          * CAST(:reservedConcurrency AS Double)\n         )\n       + (\n           (  LEAST(CEIL(GREATEST(ip.minDuration, :requestDuration) / ip.incrementDuration)\n                 * ip.incrementDuration\n                 * :nbRequests\n                 / :concurrencyMonth,\n                   :realConcurrency\n                 * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END\n              )\n         * ip.costRamRequestConcurrency\n        )\n      + (  GREATEST(CEIL(GREATEST(ip.minDuration, :requestDuration) / ip.incrementDuration)\n                 * ip.incrementDuration\n                 * :nbRequests\n                 / :concurrencyMonth\n               -   :realConcurrency\n                 * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END,\n                 0.0\n               )\n         * ip.costRamRequest\n        )\n      )\n    )\n    )\n  + ( :nbRequests * ip.costRequests ) AS monthlyCost,\n\n    (  CASE WHEN ip.period = 0 THEN CAST(:globalRate AS Double) ELSE (ip.period * CEIL(:duration / ip.period)) END\n     * (  ip.co2\n        + (  CEIL(GREATEST(ip.minCpu, :cpu) / ip.incrementCpu)\n           * ip.incrementCpu\n           * ip.co2Cpu\n           * CAST(:reservedConcurrency AS Double)\n          )\n       )\n    )\n  + (  CEIL(GREATEST(GREATEST(ip.minCpu, :cpu) * COALESCE(ip.minRamRatio, 0.0), :ram) / ip.incrementRam)\n     * ip.incrementRam\n     * (\n         (  ip.co2Ram\n          * CASE WHEN ip.period = 0 THEN CAST(:globalRate AS Double) ELSE (ip.period * CEIL(:duration / ip.period)) END\n          * CAST(:reservedConcurrency AS Double)\n         )\n       + (  CASE WHEN ip.period = 0 THEN :duration ELSE (ip.period * CEIL(:duration / ip.period)) END\n          * (\n              (  LEAST(CEIL(GREATEST(ip.minDuration, :requestDuration) / ip.incrementDuration)\n                    * ip.incrementDuration\n                    * :nbRequests\n                    / :concurrencyMonth,\n                      :realConcurrency\n                    * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END\n                 )\n            * ip.co2RamRequestConcurrency\n           )\n         + (  GREATEST(CEIL(GREATEST(ip.minDuration, :requestDuration) / ip.incrementDuration)\n                    * ip.incrementDuration\n                    * :nbRequests\n                    / :concurrencyMonth\n                  -   :realConcurrency\n                    * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END,\n                    0.0\n                 )\n            * ip.co2RamRequest\n           )\n         )\n      )\n    )\n    )\n  + (  :nbRequests\n     * ip.co2Requests\n  \t  * CASE WHEN ip.period = 0 THEN :duration ELSE (ip.period * CEIL(:duration / ip.period)) END\n ) AS totalCo2,\n\n    (  CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END\n     * (  ip.co2\n        + (  CEIL(GREATEST(ip.minCpu, :cpu) / ip.incrementCpu)\n           * ip.incrementCpu\n           * ip.co2Cpu\n           * CAST(:reservedConcurrency AS Double)\n          )\n       )\n    )\n  + (  CEIL(GREATEST(GREATEST(ip.minCpu, :cpu) * COALESCE(ip.minRamRatio, 0.0), :ram) / ip.incrementRam)\n     * ip.incrementRam\n     * (\n         (  ip.co2Ram\n          * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END\n          * CAST(:reservedConcurrency AS Double)\n         )\n       + (\n           (  LEAST(CEIL(GREATEST(ip.minDuration, :requestDuration) / ip.incrementDuration)\n                 * ip.incrementDuration\n                 * :nbRequests\n                 / :concurrencyMonth,\n                   :realConcurrency\n                 * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END\n              )\n         * ip.co2RamRequestConcurrency\n        )\n      + (  GREATEST(CEIL(GREATEST(ip.minDuration, :requestDuration) / ip.incrementDuration)\n                 * ip.incrementDuration\n                 * :nbRequests\n                 / :concurrencyMonth\n               -   :realConcurrency\n                 * CASE WHEN ip.period = 0 THEN CAST(:rate AS Double) ELSE CAST(:rateFull AS Double) END,\n                 0.0\n               )\n         * ip.co2RamRequest\n        )\n      )\n    )\n    )\n  + ( :nbRequests * ip.co2Requests ) AS monthlyCo2\n\nFROM ProvFunctionPrice ip WHERE\n     ip.location.id = :location\n AND ip.incrementCpu IS NOT NULL\n AND ip.incrementRam IS NOT NULL\n AND (ip.maxCpu IS NULL or ip.maxCpu >= :cpu)\n AND (ip.maxRam IS NULL OR ip.maxRam >= :ram)\n AND (ip.maxDuration IS NULL OR ip.maxDuration >= :requestDuration)\n AND (ip.maxRamRatio IS NULL OR GREATEST(ip.minCpu, :cpu) * ip.maxRamRatio <= :ram)\n AND (ip.costRamRequestConcurrency = 0.0 AND :reservedConcurrency = 0.0 OR ip.costRamRequestConcurrency > 0.0 AND :reservedConcurrency > 0.0)\n AND (ip.initialCost IS NULL OR :initialCost >= ip.initialCost)\n AND (ip.type.id IN :types) AND (ip.term.id IN :terms)\n ORDER BY totalCo2 ASC, totalCost ASC, ip.type.id DESC, ip.maxCpu ASC\n")
    public List<Object[]> findLowestDynamicCo2(List<Integer> var1, List<Integer> var2, double var3, double var5, int var7, double var8, double var10, double var12, double var14, double var16, double var18, double var20, double var22, double var24, double var26, Pageable var28);

    @Query(value="SELECT ip,\n (CASE\n  WHEN ip.period = 0 THEN (ip.cost * :rate * :duration)\n  ELSE (ip.costPeriod * ceil(:duration/ip.period)) END) AS totalCost,\n (CASE\n  WHEN ip.period = 0 THEN (ip.cost * :rate)\n  ELSE ip.cost END) AS monthlyCost,\n (CASE\n  WHEN ip.period = 0 THEN (ip.co2 * :rate * :duration)\n  ELSE (ip.co2Period * ceil(:duration/ip.period)) END) AS totalCo2,\n (CASE\n  WHEN ip.period = 0 THEN (ip.co2 * :rate)\n  ELSE ip.co2 END) AS monthlyCo2\n FROM #{#entityName} ip WHERE\n      ip.location.id = :location\n  AND ip.incrementCpu IS NULL\n  AND (ip.type.id IN :types)\n  AND (ip.term.id IN :terms)\n  AND (ip.initialCost IS NULL OR :initialCost >= ip.initialCost)\n  AND (ip.maxDuration IS NULL OR ip.maxDuration >= :requestDuration)\n  ORDER BY totalCost ASC, totalCo2 ASC, ip.type.id DESC\n")
    public List<Object[]> findLowestCost(List<Integer> var1, List<Integer> var2, int var3, double var4, double var6, double var8, double var10, Pageable var12);

    @Query(value="SELECT ip,\n (CASE\n  WHEN ip.period = 0 THEN (ip.cost * :rate * :duration)\n  ELSE (ip.costPeriod * ceil(:duration/ip.period)) END) AS totalCost,\n (CASE\n  WHEN ip.period = 0 THEN (ip.cost * :rate)\n  ELSE ip.cost END) AS monthlyCost,\n (CASE\n  WHEN ip.period = 0 THEN (ip.co2 * :rate * :duration)\n  ELSE (ip.co2Period * ceil(:duration/ip.period)) END) AS totalCo2,\n (CASE\n  WHEN ip.period = 0 THEN (ip.co2 * :rate)\n  ELSE ip.co2 END) AS monthlyCo2\n FROM #{#entityName} ip WHERE\n      ip.location.id = :location\n  AND ip.incrementCpu IS NULL\n  AND (ip.type.id IN :types)\n  AND (ip.term.id IN :terms)\n  AND (ip.initialCost IS NULL OR :initialCost >= ip.initialCost)\n  AND (ip.maxDuration IS NULL OR ip.maxDuration >= :requestDuration)\n  ORDER BY totalCo2 ASC, totalCost ASC, ip.type.id DESC\n")
    public List<Object[]> findLowestCo2(List<Integer> var1, List<Integer> var2, int var3, double var4, double var6, double var8, double var10, Pageable var12);

    @Override
    @Query(value="SELECT COUNT(id) FROM ProvFunctionPrice WHERE type.node.id = :node AND (co2 > 0 OR co2Requests > 0 OR co2Cpu > 0)")
    public int countCo2DataByNode(String var1);
}

