/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.dao;

import java.util.List;
import org.ligoj.app.plugin.prov.dao.Co2Price;
import org.ligoj.app.plugin.prov.model.AbstractInstanceType;
import org.ligoj.app.plugin.prov.model.AbstractTermPrice;
import org.ligoj.bootstrap.core.dao.RestRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.NoRepositoryBean;

@NoRepositoryBean
public interface BaseProvTermPriceRepository<T extends AbstractInstanceType, P extends AbstractTermPrice<T>>
extends RestRepository<P, Integer>,
Co2Price {
    public static final String LOWEST_QUERY_TERM = "SELECT ip,\n (CASE\n  WHEN ip.period = 0 THEN (ip.cost * :rate * :duration)\n  ELSE (ip.costPeriod * ceil(:duration/ip.period)) END) AS totalCost,\n (CASE\n  WHEN ip.period = 0 THEN (ip.cost * :rate)\n  ELSE ip.cost END) AS monthlyCost,\n (CASE\n  WHEN ip.period = 0 THEN (ip.co2 * :rate * :duration)\n  ELSE (ip.co2Period * ceil(:duration/ip.period)) END) AS totalCo2,\n (CASE\n  WHEN ip.period = 0 THEN (ip.co2 * :rate)\n  ELSE ip.co2 END) AS monthlyCo2\n FROM #{#entityName} ip WHERE\n      ip.location.id = :location\n  AND ip.incrementCpu IS NULL\n  AND (ip.type.id IN :types)\n  AND (ip.term.id IN :terms)\n  AND (ip.initialCost IS NULL OR :initialCost >= ip.initialCost)\n";

    @Query(value="FROM #{#entityName} WHERE location.name = :location AND type.node.id = :node")
    public List<P> findAll(String var1, String var2);

    @Query(value="FROM #{#entityName} e INNER JOIN e.term tm WHERE e.location.name = :location AND e.type.node.id = :node AND (tm.name LIKE CONCAT(:term1, '%') OR tm.name LIKE CONCAT(:term2, '%'))")
    public List<P> findByLocation(String var1, String var2, String var3, String var4);
}

