/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.dao;

import java.util.List;
import javax.cache.annotation.CacheKey;
import org.ligoj.app.plugin.prov.dao.BaseProvTypeRepository;
import org.ligoj.app.plugin.prov.dao.Co2Type;
import org.ligoj.app.plugin.prov.model.AbstractInstanceType;
import org.ligoj.app.plugin.prov.model.Rate;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.NoRepositoryBean;

@NoRepositoryBean
public interface BaseProvInstanceTypeRepository<T extends AbstractInstanceType>
extends BaseProvTypeRepository<T>,
Co2Type {
    public static final String BASE_CRITERIA = "SELECT id FROM #{#entityName} WHERE\n       :node = node.id\n  AND (:type = 0 OR id = :type)\n  AND (baseline=0.0 OR :baseline <= baseline)\n  AND (:physical = FALSE OR physical = :physical)\n  AND (:autoScale = FALSE OR autoScale = :autoScale)\n  AND (:edge = FALSE OR edge = :edge)\n  AND (cpuRate IS NULL OR cpuRate >= :cpuRate)\n  AND (ramRate IS NULL OR ramRate >= :ramRate)\n  AND (networkRate IS NULL OR networkRate >= :networkRate)\n  AND (storageRate IS NULL OR storageRate >= :storageRate)\n  AND (:co2Mode = FALSE OR watt > 0)\n  AND (:processor = ''\n   OR (processor IS NOT NULL AND UPPER(processor) LIKE CONCAT('%', CONCAT(UPPER(:processor), '%'))))\n";

    @Query(value="SELECT DISTINCT processor FROM #{#entityName} AS t WHERE processor IS NOT NULL  AND t.node.id = :node ORDER BY processor           ")
    public List<String> findProcessors(String var1);

    @Query(value="SELECT id FROM #{#entityName} WHERE\n       :node = node.id\n  AND (:type = 0 OR id = :type)\n  AND (baseline=0.0 OR :baseline <= baseline)\n  AND (:physical = FALSE OR physical = :physical)\n  AND (:autoScale = FALSE OR autoScale = :autoScale)\n  AND (:edge = FALSE OR edge = :edge)\n  AND (cpuRate IS NULL OR cpuRate >= :cpuRate)\n  AND (ramRate IS NULL OR ramRate >= :ramRate)\n  AND (networkRate IS NULL OR networkRate >= :networkRate)\n  AND (storageRate IS NULL OR storageRate >= :storageRate)\n  AND (:co2Mode = FALSE OR watt > 0)\n  AND (:processor = ''\n   OR (processor IS NOT NULL AND UPPER(processor) LIKE CONCAT('%', CONCAT(UPPER(:processor), '%'))))\n  AND (cpu BETWEEN :cpu AND :limitCpu)\n  AND (ram BETWEEN :ram AND :limitRam)\n  AND (:gpu=0.0 OR (gpu IS NOT NULL AND (gpu BETWEEN :gpu AND :limitGpu) AND gpuRate >= :gpuRate))\n")
    public List<Integer> findValidTypes(String var1, double var2, double var4, double var6, double var8, double var10, double var12, double var14, boolean var16, int var17, String var18, boolean var19, Rate var20, Rate var21, Rate var22, Rate var23, Rate var24, boolean var25, boolean var26);

    @Query(value="SELECT id FROM #{#entityName} WHERE\n       :node = node.id\n  AND (:type = 0 OR id = :type)\n  AND (baseline=0.0 OR :baseline <= baseline)\n  AND (:physical = FALSE OR physical = :physical)\n  AND (:autoScale = FALSE OR autoScale = :autoScale)\n  AND (:edge = FALSE OR edge = :edge)\n  AND (cpuRate IS NULL OR cpuRate >= :cpuRate)\n  AND (ramRate IS NULL OR ramRate >= :ramRate)\n  AND (networkRate IS NULL OR networkRate >= :networkRate)\n  AND (storageRate IS NULL OR storageRate >= :storageRate)\n  AND (:co2Mode = FALSE OR watt > 0)\n  AND (:processor = ''\n   OR (processor IS NOT NULL AND UPPER(processor) LIKE CONCAT('%', CONCAT(UPPER(:processor), '%'))))\n  AND cpu = 0\n  AND (gpuRate IS NULL OR gpuRate >= :gpuRate)\n")
    public List<Integer> findDynamicTypes(@CacheKey String var1, @CacheKey double var2, @CacheKey boolean var4, @CacheKey int var5, @CacheKey String var6, @CacheKey boolean var7, @CacheKey Rate var8, @CacheKey Rate var9, @CacheKey Rate var10, @CacheKey Rate var11, @CacheKey Rate var12, boolean var13, boolean var14);

    @Query(value="SELECT CASE WHEN COUNT(id) > 0 THEN TRUE ELSE FALSE END FROM #{#entityName} WHERE\n  :node = node.id\n  AND cpu = 0")
    public boolean hasDynamicalTypes(String var1);

    @Override
    @Query(value="SELECT CASE WHEN COUNT(id) > 0 THEN TRUE ELSE FALSE END FROM #{#entityName} WHERE\n  :node = node.id\n  AND watt > 0")
    public boolean hasCo2Data(String var1);
}

