/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov.catalog;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceContextType;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.ligoj.app.dao.NodeRepository;
import org.ligoj.app.model.Node;
import org.ligoj.app.plugin.prov.Floating;
import org.ligoj.app.plugin.prov.ProvResource;
import org.ligoj.app.plugin.prov.catalog.AbstractUpdateContext;
import org.ligoj.app.plugin.prov.catalog.Co2Data;
import org.ligoj.app.plugin.prov.catalog.Co2RegionData;
import org.ligoj.app.plugin.prov.catalog.ImportCatalogResource;
import org.ligoj.app.plugin.prov.dao.BaseProvQuoteRepository;
import org.ligoj.app.plugin.prov.dao.BaseProvTermPriceRepository;
import org.ligoj.app.plugin.prov.dao.BaseProvTypeRepository;
import org.ligoj.app.plugin.prov.dao.ProvContainerPriceRepository;
import org.ligoj.app.plugin.prov.dao.ProvContainerTypeRepository;
import org.ligoj.app.plugin.prov.dao.ProvDatabasePriceRepository;
import org.ligoj.app.plugin.prov.dao.ProvDatabaseTypeRepository;
import org.ligoj.app.plugin.prov.dao.ProvFunctionPriceRepository;
import org.ligoj.app.plugin.prov.dao.ProvFunctionTypeRepository;
import org.ligoj.app.plugin.prov.dao.ProvInstancePriceRepository;
import org.ligoj.app.plugin.prov.dao.ProvInstancePriceTermRepository;
import org.ligoj.app.plugin.prov.dao.ProvInstanceTypeRepository;
import org.ligoj.app.plugin.prov.dao.ProvLocationRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteContainerRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteDatabaseRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteFunctionRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteInstanceRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteStorageRepository;
import org.ligoj.app.plugin.prov.dao.ProvStoragePriceRepository;
import org.ligoj.app.plugin.prov.dao.ProvStorageTypeRepository;
import org.ligoj.app.plugin.prov.dao.ProvSupportPriceRepository;
import org.ligoj.app.plugin.prov.dao.ProvSupportTypeRepository;
import org.ligoj.app.plugin.prov.model.AbstractCodedEntity;
import org.ligoj.app.plugin.prov.model.AbstractInstanceType;
import org.ligoj.app.plugin.prov.model.AbstractPrice;
import org.ligoj.app.plugin.prov.model.AbstractQuote;
import org.ligoj.app.plugin.prov.model.AbstractTermPrice;
import org.ligoj.app.plugin.prov.model.AbstractTermPriceVm;
import org.ligoj.app.plugin.prov.model.ImportCatalogStatus;
import org.ligoj.app.plugin.prov.model.ProvInstancePriceTerm;
import org.ligoj.app.plugin.prov.model.ProvLocation;
import org.ligoj.app.plugin.prov.model.ProvStoragePrice;
import org.ligoj.app.plugin.prov.model.Rate;
import org.ligoj.app.plugin.prov.model.VmOs;
import org.ligoj.bootstrap.core.dao.RestRepository;
import org.ligoj.bootstrap.core.dao.csv.CsvForJpa;
import org.ligoj.bootstrap.resource.system.configuration.ConfigurationResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.domain.Persistable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.repository.CrudRepository;

public abstract class AbstractImportCatalogResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractImportCatalogResource.class);
    protected static final TypeReference<Map<String, String>> MAP_STR = new TypeReference<Map<String, String>>(){};
    protected static final TypeReference<Map<String, ProvLocation>> MAP_LOCATION = new TypeReference<Map<String, ProvLocation>>(){};
    protected static final TypeReference<Map<String, Double>> MAP_DOUBLE = new TypeReference<Map<String, Double>>(){};
    protected static final String BY_NODE = "node";
    public static final String CONF_HOURS_MONTH = ProvResource.SERVICE_KEY + ":hours-month";
    @PersistenceContext(type=PersistenceContextType.TRANSACTION, unitName="pu")
    protected EntityManager em;
    @Autowired
    protected ObjectMapper objectMapper;
    @Autowired
    protected ConfigurationResource configuration;
    @Autowired
    protected NodeRepository nodeRepository;
    @Autowired
    protected ProvLocationRepository locationRepository;
    @Autowired
    protected ProvDatabaseTypeRepository dtRepository;
    @Autowired
    protected ProvDatabasePriceRepository dpRepository;
    @Autowired
    protected ProvQuoteDatabaseRepository qdRepository;
    @Autowired
    protected ProvStoragePriceRepository spRepository;
    @Autowired
    protected ProvQuoteStorageRepository qsRepository;
    @Autowired
    protected ProvStorageTypeRepository stRepository;
    @Autowired
    protected ProvSupportTypeRepository st2Repository;
    @Autowired
    protected ProvSupportPriceRepository sp2Repository;
    @Autowired
    protected ProvContainerPriceRepository cpRepository;
    @Autowired
    protected ProvContainerTypeRepository ctRepository;
    @Autowired
    protected ProvQuoteContainerRepository qcRepository;
    @Autowired
    protected ProvFunctionPriceRepository fpRepository;
    @Autowired
    protected ProvFunctionTypeRepository ftRepository;
    @Autowired
    protected ProvQuoteFunctionRepository qfRepository;
    @Autowired
    protected ProvInstancePriceTermRepository iptRepository;
    @Autowired
    protected ProvInstancePriceRepository ipRepository;
    @Autowired
    protected ProvInstanceTypeRepository itRepository;
    @Autowired
    protected ProvQuoteInstanceRepository qiRepository;
    @Autowired
    protected ImportCatalogResource importCatalogResource;
    @Autowired
    protected CsvForJpa csvForBean;
    private final Map<String, Map<String, Rate>> mapRate = new HashMap<String, Map<String, Rate>>();

    protected <U extends AbstractUpdateContext> U initContext(U context, String node, boolean force) {
        context.setNode((Node)this.nodeRepository.findOneExpected((Serializable)((Object)node)));
        context.setHoursMonth(this.configuration.get(CONF_HOURS_MONTH, 730));
        context.setForce(force);
        return context;
    }

    protected Rate getRate(String type, String name) {
        Map<String, Rate> map = this.mapRate.get(type);
        String[] fragments = StringUtils.split((String)Objects.toString(name, "__"), (String)".-");
        String size = fragments[0];
        String model = StringUtils.rightPad((String)size, (int)2, (char)'_').substring(0, 2);
        return Arrays.stream(new String[]{name, size, model, model.substring(0, 1), "default"}).map(map::get).filter(Objects::nonNull).findFirst().orElse(Rate.MEDIUM);
    }

    protected void initRate(String type) throws IOException {
        HashMap mapping = new HashMap();
        this.mapRate.put(type, mapping);
        mapping.putAll((Map)this.objectMapper.readValue(IOUtils.toString((InputStream)new ClassPathResource("rate-" + type + ".json").getInputStream(), (Charset)StandardCharsets.UTF_8), (TypeReference)new TypeReference<Map<String, Rate>>(this){}));
    }

    protected double round3Decimals(double value) {
        return Floating.round(value);
    }

    protected <T> Map<String, T> toMap(String path, TypeReference<Map<String, T>> type) throws IOException {
        return (Map)this.objectMapper.readValue(IOUtils.toString((InputStream)new ClassPathResource(path).getInputStream(), (Charset)StandardCharsets.UTF_8), type);
    }

    protected Double toPercent(String raw) {
        if (Strings.CS.endsWith((CharSequence)raw, (CharSequence)"%")) {
            return Double.valueOf(raw.substring(0, raw.length() - 1));
        }
        return null;
    }

    protected boolean isEnabledType(AbstractUpdateContext context, String type) {
        return context.getValidInstanceType().matcher(type).matches();
    }

    protected boolean isEnabledContainerType(AbstractUpdateContext context, String type) {
        return type != null && context.getValidContainerType().matcher(type).matches();
    }

    protected boolean isEnabledDatabaseType(AbstractUpdateContext context, String type) {
        return type != null && context.getValidDatabaseType().matcher(type).matches();
    }

    protected VmOs toVmOs(String osName) {
        return VmOs.valueOf(osName.toUpperCase(Locale.ENGLISH));
    }

    protected boolean isEnabledOs(AbstractUpdateContext context, VmOs os) {
        return this.isEnabledOs(context, os.name());
    }

    protected boolean isEnabledEngine(AbstractUpdateContext context, String engine) {
        return context.getValidDatabaseEngine().matcher(engine).matches();
    }

    protected boolean isEnabledOs(AbstractUpdateContext context, String os) {
        String osName = os.toUpperCase(Locale.ENGLISH);
        return context.getValidOs().matcher(osName).matches() && EnumUtils.isValidEnum(VmOs.class, (String)osName);
    }

    protected boolean isEnabledRegion(AbstractUpdateContext context, ProvLocation region) {
        return this.isEnabledRegion(context, region.getName());
    }

    protected boolean isEnabledRegion(AbstractUpdateContext context, String region) {
        return context.getValidRegion().matcher(region).matches();
    }

    protected ProvLocation installRegion(AbstractUpdateContext context, String name, String description) {
        ProvLocation entity = context.getRegions().computeIfAbsent(name, r -> {
            ProvLocation newRegion = new ProvLocation();
            newRegion.setNode(context.getNode());
            newRegion.setName((String)r);
            return newRegion;
        });
        return this.copyAsNeeded(context, entity, (ProvLocation r) -> {
            ProvLocation regionStats = context.getMapRegionById().getOrDefault(name, new ProvLocation());
            r.setContinentM49(regionStats.getContinentM49());
            r.setCountryA2(regionStats.getCountryA2());
            r.setCountryM49(regionStats.getCountryM49());
            r.setPlacement(regionStats.getPlacement());
            r.setRegionM49(regionStats.getRegionM49());
            r.setSubRegion(regionStats.getSubRegion());
            r.setLatitude(regionStats.getLatitude());
            r.setLongitude(regionStats.getLongitude());
            r.setPreferred(regionStats.isPreferred());
            r.setDescription((String)ObjectUtils.getIfNull((Object)description, (Object)regionStats.getName()));
        });
    }

    protected ProvLocation installRegion(AbstractUpdateContext context, String name) {
        return this.installRegion(context, name, null);
    }

    protected ProvLocation getRegionByHumanName(AbstractUpdateContext context, String humanName) {
        return context.getRegions().values().stream().filter(r -> humanName.equals(r.getDescription())).filter(r -> this.isEnabledRegion(context, (ProvLocation)((Object)r))).findAny().orElse(null);
    }

    protected void nextStep(AbstractUpdateContext context, String phase) {
        this.nextStep(context, phase, null, 1);
    }

    protected void nextStep(AbstractUpdateContext context, String phase, String location, int step) {
        this.nextStep(context.getNode(), phase, location, step);
    }

    private void nextStep(Node node, String phase, String location, int step) {
        log.info("Next step node={}, phase={}, region={}, step={}", new Object[]{node.getId(), phase, location, step});
        this.importCatalogResource.nextStep((Serializable)((Object)node.getId()), t -> {
            this.importCatalogResource.updateStats((ImportCatalogStatus)((Object)t));
            t.setWorkload(this.getWorkload((ImportCatalogStatus)((Object)t)));
            t.setDone(t.getDone() + step);
            t.setPhase(phase);
            t.setLocation(location);
        });
    }

    protected int getWorkload(ImportCatalogStatus status) {
        return 0;
    }

    protected <T extends AbstractCodedEntity, P extends AbstractPrice<T>> P saveAsNeeded(AbstractUpdateContext context, P price, double oldCost, double newCost, ObjDoubleConsumer<Double> updateCost, Consumer<P> persister) {
        context.getPrices().add(price.getCode());
        return this.saveAsNeededInternal(context, price, oldCost, newCost, updateCost, persister);
    }

    protected <T extends AbstractCodedEntity, P extends AbstractPrice<T>> P saveAsNeededInternal(AbstractUpdateContext context, P price, double oldCost, double newCost, ObjDoubleConsumer<Double> updateCost, Consumer<P> persister) {
        double newCostR = this.round3Decimals(newCost);
        if (context.isForce() || price.isNew() && !this.em.contains(price) || oldCost != newCostR) {
            updateCost.accept(newCostR, newCost);
            persister.accept(price);
        }
        return price;
    }

    protected <T extends AbstractInstanceType, P extends AbstractTermPrice<T>> P saveAsNeeded(AbstractUpdateContext context, P price, double newCost, BaseProvTermPriceRepository<T, P> repository) {
        return (P)this.saveAsNeeded(context, price, price.getCost(), newCost, (cR, c) -> {
            price.setCost((double)cR);
            price.setCostPeriod(this.round3Decimals(c * Math.max(1.0, price.getTerm().getPeriod())));
            this.setCo2(context, price);
        }, arg_0 -> repository.save(arg_0));
    }

    private String newCarbonData(DoubleUnaryOperator converter, double ... watt) {
        return Arrays.stream(watt).map(converter).map(this::round3Decimals).mapToObj(String::valueOf).collect(Collectors.joining(","));
    }

    protected <P extends AbstractTermPrice<?>> void setCo2(AbstractUpdateContext context, P price) {
        Co2Data v = this.getCo2(context, ((AbstractCodedEntity)price.getType()).getCode());
        double conversion = this.toConversion(context, price.getLocation().getName());
        this.setCo2(context, price, v, conversion);
    }

    protected <P extends AbstractTermPrice<?>> void setCo2(AbstractUpdateContext context, P price, Co2Data v, double conversion) {
        double co2 = this.setCo2(context, conversion, v.getWatt100(), v.getScope3(), price::setCo2, price::setCo210, v.getPkgWattArray());
        price.setCo2Period(this.round3Decimals(co2 * Math.max(1.0, price.getTerm().getPeriod())));
    }

    protected <P extends AbstractTermPriceVm<?>> void setCo2Custom(AbstractUpdateContext context, P p, Co2Data v, double conversion) {
        double co2 = this.setCo2(context, conversion, v.getWatt100(), v.getScope3(), p::setCo2, p::setCo210, v.getWattArray());
        this.setCo2(context, conversion, v.getPkgWatt100(), v.getScope3(), p::setCo2Cpu, p::setCo2Cpu10, v.getPkgWattArray());
        this.setCo2(context, conversion, v.getRamWatt100(), 0.0, p::setCo2Ram, p::setCo2Ram10, v.getRamWattArray());
        this.setCo2(context, conversion, v.getGpuWatt100(), 0.0, p::setCo2Gpu, p::setCo2Gpu10, v.getGpuWattArray());
        p.setCo2Period(this.round3Decimals(co2 * Math.max(1.0, p.getTerm().getPeriod())));
    }

    private double setCo2(AbstractUpdateContext context, double conversion, double watt100, double base, DoubleConsumer setCo2, Consumer<String> setCo2100, double[] data10) {
        if (watt100 == 0.0) {
            return 0.0;
        }
        double co2 = this.toCo2(context, watt100, conversion, base);
        setCo2.accept(this.round3Decimals(co2));
        setCo2100.accept(this.newCarbonData(w -> this.round3Decimals(this.toCo2(context, w, conversion, base)), data10));
        return co2;
    }

    private double toCo2(AbstractUpdateContext context, double watt, double conversion, double base) {
        return (watt * conversion + base) * (context == null ? 1.0 : context.getHoursMonth());
    }

    protected double toConversion(AbstractUpdateContext context, String location) {
        Map<String, Co2RegionData> mapping = context.getCo2RegionDataSet();
        Co2RegionData data = mapping.computeIfAbsent(location, l -> {
            String[] fragments = StringUtils.split((String)(l + "._"), (String)".-");
            String[] rawMatch = new String[]{l, fragments[0] + "-" + fragments[1], fragments[0] + "." + fragments[1], fragments[0]};
            String match = Arrays.stream(rawMatch).filter(mapping::containsKey).findFirst().orElse(null);
            if (match == null && (match = (String)Arrays.stream(rawMatch).map(this::toPattern).map(p -> mapping.keySet().stream().filter(p.asMatchPredicate()).findFirst().orElse(null)).filter(Objects::nonNull).findFirst().orElse(null)) == null) {
                log.warn("No regional CO2 for region {}", (Object)location);
                return new Co2RegionData();
            }
            log.info("No perfect regional CO2 for region {}, using {}", (Object)location, (Object)match);
            return (Co2RegionData)mapping.get(match);
        });
        return data.getPue() * data.getGPerKWH() / 1000.0;
    }

    private Pattern toPattern(String regular) {
        return Pattern.compile(Strings.CS.replace(regular, ".", "\\.") + ".*");
    }

    protected Co2Data getCo2(AbstractUpdateContext context, String type) {
        return context.getCo2DataSet().computeIfAbsent(type, t -> {
            log.warn("No CO2 for type {}", (Object)type);
            return new Co2Data();
        });
    }

    protected void setWatt(AbstractUpdateContext context, AbstractInstanceType type) {
        Co2Data v = this.getCo2(context, type.getCode());
        this.setCo2(null, 1.0, v.getWatt100(), 0.0, type::setWatt, type::setWatt10, v.getWattArray());
    }

    protected <T extends AbstractCodedEntity, P extends AbstractPrice<T>> P saveAsNeeded(AbstractUpdateContext context, P entity, double newCost, RestRepository<P, Integer> repository) {
        return (P)((Object)this.saveAsNeeded(context, entity, entity.getCost(), newCost, (cR, c) -> entity.setCost((double)cR), arg_0 -> repository.save(arg_0)));
    }

    protected ProvStoragePrice saveAsNeeded(AbstractUpdateContext context, ProvStoragePrice entity, double newCostGb, RestRepository<ProvStoragePrice, Integer> repository) {
        return this.saveAsNeededInternal(context, entity, entity.getCostGb(), newCostGb, (cR, c) -> entity.setCostGb((double)cR), arg_0 -> repository.save(arg_0));
    }

    protected <K extends Serializable, P extends Persistable<K>> P copyAsNeeded(AbstractUpdateContext context, P entity, Consumer<P> updater) {
        return this.copyAsNeeded(context, entity, updater, null);
    }

    protected <T extends AbstractCodedEntity> T copyAsNeeded(AbstractUpdateContext context, T entity, Consumer<T> updater, BaseProvTypeRepository<T> repository) {
        return (T)((AbstractCodedEntity)this.syncAdd((Set)context.getMergedTypes(), (Object)entity.getCode(), (Consumer)updater, (Object)entity, (JpaRepository)repository));
    }

    protected <Y, I> I syncAdd(Set<Y> collection, Y item, Consumer<I> whenAbsent, I entity, JpaRepository<I, ?> repository) {
        this.syncAdd(collection, item, i -> {
            whenAbsent.accept(entity);
            if (repository != null) {
                repository.saveAndFlush(entity);
            }
        });
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <Y> Y syncAdd(Set<Y> collection, Y item, Consumer<Y> whenAbsent) {
        if (!collection.contains(item)) {
            Set<Y> set = collection;
            synchronized (set) {
                if (collection.add(item)) {
                    whenAbsent.accept(item);
                }
            }
        }
        return item;
    }

    protected <K, V> V syncAdd(Map<K, V> map, K key, Function<K, V> whenAbsent, Function<V, V> onCompute) {
        return (V)map.compute(key, (code, previous) -> onCompute.apply(previous == null ? whenAbsent.apply(key) : previous));
    }

    protected ProvInstancePriceTerm copyAsNeeded(AbstractUpdateContext context, ProvInstancePriceTerm entity, Consumer<ProvInstancePriceTerm> updater) {
        return this.syncAdd((Set)context.getMergedTerms(), (Object)entity.getCode(), (Consumer)updater, (Object)entity, (JpaRepository)this.iptRepository);
    }

    protected ProvLocation copyAsNeeded(AbstractUpdateContext context, ProvLocation entity, Consumer<ProvLocation> updater) {
        return this.syncAdd((Set)context.getMergedLocations(), (Object)entity.getName(), (Consumer)updater, (Object)((Object)entity), (JpaRepository)this.locationRepository);
    }

    protected <K extends Serializable, P extends Persistable<K>> P copyAsNeeded(AbstractUpdateContext context, P entity, Consumer<P> updater, RestRepository<P, K> repository) {
        if (this.isNeedUpdate(context, entity)) {
            updater.accept(entity);
            if (repository != null) {
                repository.save(entity);
            }
        }
        return entity;
    }

    private <K extends Serializable, P extends Persistable<K>> boolean isNeedUpdate(AbstractUpdateContext context, P entity) {
        return context.isForce() || entity.isNew() && !this.em.contains(entity);
    }

    protected <T extends AbstractCodedEntity, P extends AbstractPrice<T>, Q extends AbstractQuote<P>> void purgePrices(AbstractUpdateContext context, Map<String, P> storedPrices, CrudRepository<P, Integer> pRepository, BaseProvQuoteRepository<Q> qRepository) {
        HashSet<String> retiredCodes = new HashSet<String>(storedPrices.keySet());
        retiredCodes.removeAll(context.getPrices());
        if (!retiredCodes.isEmpty()) {
            int nbRetiredCodes = retiredCodes.size();
            retiredCodes.removeAll(qRepository.findUsedPrices(context.getNode().getId()));
            log.info("Purging {} unused of {} retired catalog prices ...", (Object)retiredCodes.size(), (Object)nbRetiredCodes);
            retiredCodes.stream().map(storedPrices::get).forEach(arg_0 -> pRepository.delete(arg_0));
            log.info("Code purged");
            storedPrices.keySet().removeAll(retiredCodes);
        }
    }

    @Generated
    public void setImportCatalogResource(ImportCatalogResource importCatalogResource) {
        this.importCatalogResource = importCatalogResource;
    }

    @Generated
    public ImportCatalogResource getImportCatalogResource() {
        return this.importCatalogResource;
    }
}

