/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov;

import jakarta.transaction.Transactional;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ligoj.app.plugin.prov.AbstractLazyResource;
import org.ligoj.app.plugin.prov.TagEditionVo;
import org.ligoj.app.plugin.prov.TagVo;
import org.ligoj.app.plugin.prov.dao.ProvTagRepository;
import org.ligoj.app.plugin.prov.model.AbstractQuote;
import org.ligoj.app.plugin.prov.model.ProvQuote;
import org.ligoj.app.plugin.prov.model.ProvTag;
import org.ligoj.app.plugin.prov.model.ResourceType;
import org.ligoj.bootstrap.core.INamableBean;
import org.ligoj.bootstrap.core.NamedBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Path(value="/service/prov")
@Produces(value={"application/json"})
@Transactional
public class ProvTagResource
extends AbstractLazyResource {
    @Autowired
    private ProvTagRepository repository;

    public Map<ResourceType, Map<Integer, List<TagVo>>> findAll(ProvQuote quote) {
        EnumMap<ResourceType, Map<Integer, List<TagVo>>> tags = new EnumMap<ResourceType, Map<Integer, List<TagVo>>>(ResourceType.class);
        this.repository.findAll(quote).forEach(t -> tags.computeIfAbsent(t.getType(), a -> new HashMap()).computeIfAbsent(t.getResource(), a -> new ArrayList()).add(this.toVo((ProvTag)((Object)t))));
        return tags;
    }

    private TagVo toVo(ProvTag entity) {
        TagVo result = new TagVo();
        NamedBean.copy((INamableBean)entity, (INamableBean)result);
        result.setValue(entity.getValue());
        return result;
    }

    @Override
    public void onDelete(ResourceType type, Integer ... resources) {
        Arrays.stream(resources).forEach(r -> this.repository.deleteAllBy("type", (Object)type, new String[]{"resource"}, new Object[]{r}));
    }

    @Override
    public void onDeleteAll(ResourceType type, int quote) {
        this.repository.deleteAllBy("configuration.id", quote, new String[]{"type"}, new Object[]{type});
    }

    @POST
    @Path(value="{subscription:\\d+}/tag")
    @Consumes(value={"application/json"})
    public int create(@PathParam(value="subscription") int subscription, TagEditionVo vo) {
        return this.saveOrUpdate(subscription, new ProvTag(), vo);
    }

    @PUT
    @Path(value="{subscription:\\d+}/tag")
    @Consumes(value={"application/json"})
    public void update(@PathParam(value="subscription") int subscription, TagEditionVo vo) {
        this.saveOrUpdate(subscription, this.resource.findConfigured(this.repository, (Integer)vo.getId(), subscription), vo);
    }

    private int saveOrUpdate(int subscription, ProvTag entity, TagEditionVo vo) {
        AbstractQuote res = (AbstractQuote)this.resource.findConfigured(this.getRepository(vo.getType()), vo.getResource(), subscription);
        NamedBean.copy((INamableBean)vo, (INamableBean)entity);
        entity.setValue(vo.getValue());
        entity.setResource(vo.getResource());
        entity.setType(vo.getType());
        entity.setConfiguration(res.getConfiguration());
        return (Integer)((ProvTag)((Object)this.repository.saveAndFlush((Object)entity))).getId();
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="{subscription:\\d+}/tag/{id}")
    public void delete(@PathParam(value="subscription") int subscription, @PathParam(value="id") int id) {
        this.repository.delete((Object)this.resource.findConfigured(this.repository, id, subscription));
    }

    public void replaceTags(Collection<TagVo> tags, AbstractQuote<?> resource) {
        if (tags != null) {
            this.onDelete(resource.getResourceType(), (Integer)resource.getId());
            tags.stream().map(t -> {
                ProvTag entity = new ProvTag();
                entity.setName(t.getName());
                entity.setValue(t.getValue());
                entity.setResource((Integer)resource.getId());
                entity.setType(resource.getResourceType());
                entity.setConfiguration(resource.getConfiguration());
                return entity;
            }).forEach(arg_0 -> ((ProvTagRepository)this.repository).save(arg_0));
        }
    }
}

