/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov;

import jakarta.persistence.EntityNotFoundException;
import jakarta.transaction.Transactional;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.cache.annotation.CacheKey;
import javax.cache.annotation.CacheResult;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Hibernate;
import org.ligoj.app.iam.IUserRepository;
import org.ligoj.app.iam.IamProvider;
import org.ligoj.app.iam.UserOrg;
import org.ligoj.app.model.Configurable;
import org.ligoj.app.model.Node;
import org.ligoj.app.model.Subscription;
import org.ligoj.app.plugin.prov.AbstractProvQuoteResource;
import org.ligoj.app.plugin.prov.Floating;
import org.ligoj.app.plugin.prov.ProvBudgetResource;
import org.ligoj.app.plugin.prov.ProvNetworkResource;
import org.ligoj.app.plugin.prov.ProvTagResource;
import org.ligoj.app.plugin.prov.QuoteEditionVo;
import org.ligoj.app.plugin.prov.QuoteLightVo;
import org.ligoj.app.plugin.prov.QuoteRelated;
import org.ligoj.app.plugin.prov.QuoteVo;
import org.ligoj.app.plugin.prov.UpdatedCost;
import org.ligoj.app.plugin.prov.dao.BaseProvQuoteRepository;
import org.ligoj.app.plugin.prov.dao.ProvBudgetRepository;
import org.ligoj.app.plugin.prov.dao.ProvContainerTypeRepository;
import org.ligoj.app.plugin.prov.dao.ProvCurrencyRepository;
import org.ligoj.app.plugin.prov.dao.ProvDatabaseTypeRepository;
import org.ligoj.app.plugin.prov.dao.ProvFunctionTypeRepository;
import org.ligoj.app.plugin.prov.dao.ProvInstanceTypeRepository;
import org.ligoj.app.plugin.prov.dao.ProvLocationRepository;
import org.ligoj.app.plugin.prov.dao.ProvOptimizerRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteContainerRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteDatabaseRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteFunctionRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteInstanceRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteStorageRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteSupportRepository;
import org.ligoj.app.plugin.prov.dao.ProvUsageRepository;
import org.ligoj.app.plugin.prov.model.AbstractQuote;
import org.ligoj.app.plugin.prov.model.AbstractTermPrice;
import org.ligoj.app.plugin.prov.model.ProvBudget;
import org.ligoj.app.plugin.prov.model.ProvLocation;
import org.ligoj.app.plugin.prov.model.ProvOptimizer;
import org.ligoj.app.plugin.prov.model.ProvQuote;
import org.ligoj.app.plugin.prov.model.ProvUsage;
import org.ligoj.app.plugin.prov.model.ReservationMode;
import org.ligoj.app.plugin.prov.model.ResourceType;
import org.ligoj.app.plugin.prov.quote.container.ProvQuoteContainerResource;
import org.ligoj.app.plugin.prov.quote.database.ProvQuoteDatabaseResource;
import org.ligoj.app.plugin.prov.quote.function.ProvQuoteFunctionResource;
import org.ligoj.app.plugin.prov.quote.instance.ProvQuoteInstanceResource;
import org.ligoj.app.plugin.prov.quote.storage.ProvQuoteStorageResource;
import org.ligoj.app.plugin.prov.quote.support.ProvQuoteSupportResource;
import org.ligoj.app.plugin.prov.terraform.TerraformRunnerResource;
import org.ligoj.app.resource.ServicePluginLocator;
import org.ligoj.app.resource.node.NodeResource;
import org.ligoj.app.resource.plugin.AbstractConfiguredServicePlugin;
import org.ligoj.app.resource.subscription.SubscriptionResource;
import org.ligoj.bootstrap.core.DescribedBean;
import org.ligoj.bootstrap.core.IDescribableBean;
import org.ligoj.bootstrap.core.dao.RestRepository;
import org.ligoj.bootstrap.core.model.Auditable;
import org.ligoj.bootstrap.core.resource.BusinessException;
import org.ligoj.bootstrap.model.system.SystemConfiguration;
import org.ligoj.bootstrap.resource.system.configuration.ConfigurationResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
@Path(value="/service/prov")
@Produces(value={"application/json"})
@Transactional
public class ProvResource
extends AbstractConfiguredServicePlugin<ProvQuote>
implements QuoteRelated<ProvQuote> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProvResource.class);
    public static final String SERVICE_URL = "/service/prov";
    public static final String SERVICE_KEY = "/service/prov".replace('/', ':').substring(1);
    public static final String PARAMETER_CURRENCY_NAME = SERVICE_KEY + ":currency";
    public static final Map<String, String> ORM_COLUMNS = new HashMap<String, String>();
    public static final String USE_PARALLEL = SERVICE_KEY + ":use-parallel";
    public static final int DEFAULT_HOURS_MONTH = 730;
    @Autowired
    private ApplicationContext context;
    @Autowired
    protected SubscriptionResource subscriptionResource;
    @Autowired
    protected ServicePluginLocator locator;
    @Autowired
    private ProvQuoteRepository repository;
    @Autowired
    private ProvCurrencyRepository currencyRepository;
    @Autowired
    private ConfigurationResource configuration;
    @Autowired
    private ProvLocationRepository locationRepository;
    @Autowired
    private ProvTagResource tagResource;
    @Autowired
    private ProvNetworkResource networkResource;
    @Autowired
    private IamProvider[] iamProvider;
    @Autowired
    private ProvQuoteInstanceResource qiResource;
    @Autowired
    private ProvQuoteDatabaseResource qbResource;
    @Autowired
    private ProvQuoteContainerResource qcResource;
    @Autowired
    private ProvQuoteFunctionResource qfResource;
    @Autowired
    private ProvQuoteSupportResource qspResource;
    @Autowired
    private ProvQuoteStorageResource qsResource;
    @Autowired
    private ProvInstanceTypeRepository itRepository;
    @Autowired
    private ProvDatabaseTypeRepository btRepository;
    @Autowired
    private ProvContainerTypeRepository ctRepository;
    @Autowired
    private ProvFunctionTypeRepository ftRepository;
    @Autowired
    private ProvQuoteInstanceRepository qiRepository;
    @Autowired
    private ProvQuoteStorageRepository qsRepository;
    @Autowired
    private ProvQuoteDatabaseRepository qbRepository;
    @Autowired
    private ProvQuoteContainerRepository qcRepository;
    @Autowired
    private ProvQuoteFunctionRepository qfRepository;
    @Autowired
    private ProvQuoteSupportRepository qs2Repository;
    @Autowired
    private ProvUsageRepository usageRepository;
    @Autowired
    private ProvBudgetRepository budgetRepository;
    @Autowired
    private ProvOptimizerRepository optimizerRepository;
    @Autowired
    private ProvBudgetResource budgetResource;
    @Autowired
    private TerraformRunnerResource runner;
    @Autowired
    private ProvResource self;
    @Autowired
    protected NodeResource nodeResource;

    public String getKey() {
        return SERVICE_KEY;
    }

    private Function<String, ? extends UserOrg> toUser() {
        return arg_0 -> ((IUserRepository)this.iamProvider[0].getConfiguration().getUserRepository()).toUser(arg_0);
    }

    @GET
    @Path(value="{subscription:\\d+}/location")
    @Consumes(value={"application/json"})
    public List<ProvLocation> findLocations(@PathParam(value="subscription") int subscription) {
        String node = this.subscriptionResource.checkVisible(Integer.valueOf(subscription)).getNode().getId();
        return this.locationRepository.findAll(node);
    }

    @CacheResult(cacheName="prov-processor")
    protected Map<String, List<String>> findProcessors(@CacheKey String node) {
        HashMap<String, List<String>> listC = new HashMap<String, List<String>>();
        listC.put("instance", this.itRepository.findProcessors(node));
        listC.put("database", this.btRepository.findProcessors(node));
        listC.put("container", this.ctRepository.findProcessors(node));
        listC.put("function", this.ftRepository.findProcessors(node));
        return listC;
    }

    public ProvLocation findLocation(String node, String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        return (ProvLocation)((Object)this.assertFound((Object)this.locationRepository.findByName(node, name), name));
    }

    @GET
    @Path(value="{subscription:\\d+}")
    public QuoteVo getConfiguration(@PathParam(value="subscription") int subscription) {
        return this.getConfiguration(this.subscriptionResource.checkVisible(Integer.valueOf(subscription)));
    }

    public QuoteVo getConfiguration(Subscription subscription) {
        QuoteVo vo = new QuoteVo();
        ProvQuote quote = this.repository.getCompute((Integer)subscription.getId());
        DescribedBean.copy((IDescribableBean)quote, (IDescribableBean)vo);
        vo.copyAuditData((Auditable)quote, this.toUser());
        vo.setLocation(quote.getLocation());
        vo.setInstances(quote.getInstances());
        vo.setDatabases(this.qbRepository.findAll(quote));
        vo.setContainers(this.qcRepository.findAll(quote));
        vo.setFunctions(this.qfRepository.findAll(quote));
        vo.setStorages(this.qsRepository.findAll(quote));
        vo.setUsage(quote.getUsage());
        vo.setBudget(quote.getBudget());
        vo.setOptimizer(quote.getOptimizer());
        vo.setLicense(quote.getLicense());
        vo.setUiSettings(quote.getUiSettings());
        vo.setRamAdjustedRate((Integer)ObjectUtils.getIfNull((Object)quote.getRamAdjustedRate(), (Object)100));
        vo.setReservationMode(quote.getReservationMode());
        vo.setProcessor(quote.getProcessor());
        vo.setPhysical(quote.getPhysical());
        vo.setTerraformStatus(this.runner.getTaskInternal(subscription));
        vo.setSupports(this.qs2Repository.findAll(quote));
        vo.setLocations(this.locationRepository.findAll(subscription.getNode().getId()));
        vo.setTags(this.tagResource.findAll(quote));
        vo.setNetworks(this.networkResource.findAll((Integer)subscription.getId()));
        vo.setUsages(this.usageRepository.findAll(quote));
        vo.setBudgets(this.budgetRepository.findAll(quote));
        vo.setOptimizers(this.optimizerRepository.findAll(quote));
        vo.setProcessors(this.self.findProcessors(subscription.getNode().getTool().getId()));
        boolean unbound = quote.isUnboundCost();
        vo.setCostNoSupport(new Floating(quote.getCostNoSupport(), quote.getMaxCostNoSupport(), quote.getInitialCost(), quote.getMaxInitialCost(), unbound, quote.getCo2(), quote.getMaxCo2()));
        vo.setCostSupport(new Floating(quote.getCostSupport(), quote.getMaxCostSupport(), 0.0, 0.0, unbound, quote.getCo2(), quote.getMaxCo2()));
        vo.setCost(quote.toFloating());
        vo.setCurrency(quote.getCurrency());
        return vo;
    }

    public QuoteLightVo getSubscriptionStatus(int subscription) {
        QuoteLightVo vo = new QuoteLightVo();
        Object[] compute = this.repository.getComputeSummary(subscription).getFirst();
        Object[] database = this.repository.getDatabaseSummary(subscription).getFirst();
        Object[] container = this.repository.getContainerSummary(subscription).getFirst();
        Object[] function = this.repository.getFunctionSummary(subscription).getFirst();
        Object[] storage = this.repository.getStorageSummary(subscription).getFirst();
        ProvQuote entity = (ProvQuote)compute[0];
        DescribedBean.copy((IDescribableBean)entity, (IDescribableBean)vo);
        vo.setCost(entity.toFloating());
        vo.setLocation(entity.getLocation());
        vo.setCurrency(entity.getCurrency());
        vo.setNbInstances(((Long)compute[1]).intValue());
        vo.setNbDatabases(((Long)database[1]).intValue());
        vo.setNbContainers(((Long)container[1]).intValue());
        vo.setNbFunctions(((Long)function[1]).intValue());
        vo.setNbStorages(((Long)storage[1]).intValue());
        vo.setTotalCpu(Stream.of(compute, database, container).mapToDouble(r -> (Double)r[2]).sum());
        vo.setTotalGpu(Stream.of(compute, database, container).mapToDouble(r -> (Double)r[3]).sum());
        vo.setTotalRam(Stream.of(compute, database, container).mapToInt(r -> ((Long)r[4]).intValue()).sum());
        vo.setNbPublicAccess(Stream.of(compute, database, container).mapToInt(r -> ((Long)r[5]).intValue()).sum());
        vo.setTotalStorage(((Long)storage[2]).intValue());
        return vo;
    }

    @PUT
    @Path(value="{subscription:\\d+}")
    @Consumes(value={"application/json"})
    public Floating update(@PathParam(value="subscription") int subscription, QuoteEditionVo vo) {
        ProvQuote entity = this.getQuoteFromSubscription(subscription);
        entity.setName(vo.getName());
        entity.setDescription(vo.getDescription());
        entity.setUiSettings(vo.getUiSettings());
        String oldLicense = entity.getLicense();
        ProvLocation oldLocation = entity.getLocation();
        ProvUsage oldUsage = entity.getUsage();
        ProvBudget oldBudget = entity.getBudget();
        ProvOptimizer oldOptimizer = entity.getOptimizer();
        Integer oldRamAdjusted = (Integer)ObjectUtils.getIfNull((Object)entity.getRamAdjustedRate(), (Object)100);
        ReservationMode oldReservationMode = (ReservationMode)((Object)ObjectUtils.getIfNull((Object)((Object)entity.getReservationMode()), (Object)((Object)ReservationMode.RESERVED)));
        String oldProcessor = StringUtils.trimToNull((String)entity.getProcessor());
        Boolean oldPhysical = entity.getPhysical();
        entity.setLocation(this.findLocation(entity.getSubscription().getNode().getId(), vo.getLocation()));
        entity.setUsage(Optional.ofNullable(vo.getUsage()).map(u -> (ProvUsage)this.findConfiguredByName(this.usageRepository, (String)u, subscription)).orElse(null));
        entity.setBudget(Optional.ofNullable(vo.getBudget()).map(u -> (ProvBudget)this.findConfiguredByName(this.budgetRepository, (String)u, subscription)).orElse(null));
        entity.setOptimizer(Optional.ofNullable(vo.getOptimizer()).map(u -> (ProvOptimizer)this.findConfiguredByName(this.optimizerRepository, (String)u, subscription)).orElse(null));
        entity.setLicense(vo.getLicense());
        entity.setRamAdjustedRate((Integer)ObjectUtils.getIfNull((Object)vo.getRamAdjustedRate(), (Object)100));
        entity.setReservationMode(vo.getReservationMode());
        entity.setProcessor(StringUtils.trimToNull((String)vo.getProcessor()));
        entity.setPhysical(vo.getPhysical());
        if (!(!vo.isRefresh() && oldLocation.equals((Object)entity.getLocation()) && Objects.equals((Object)oldUsage, (Object)entity.getUsage()) && Objects.equals((Object)oldOptimizer, (Object)entity.getOptimizer()) && Objects.equals((Object)oldBudget, (Object)entity.getBudget()) && oldRamAdjusted.equals(entity.getRamAdjustedRate()) && oldReservationMode == entity.getReservationMode() && Objects.equals(oldLicense, entity.getLicense()) && Objects.equals(oldProcessor, entity.getProcessor()) && Objects.equals(oldPhysical, entity.getPhysical()))) {
            return this.refresh(entity);
        }
        return entity.toFloating();
    }

    @PUT
    @Path(value="{subscription:\\d+}/refresh-cost")
    @Consumes(value={"application/json"})
    public Floating updateCost(@PathParam(value="subscription") int subscription) {
        ProvQuote quote = this.repository.getCompute(subscription);
        return this.updateCost(quote);
    }

    protected Floating updateCost(ProvQuote quote) {
        return this.processCost(quote, BooleanUtils.isTrue((Boolean)quote.getLeanOnChange())).getTotal();
    }

    public <T> Stream<T> newStream(Collection<T> collection) {
        if (this.configuration.get(USE_PARALLEL, 1) == 1) {
            return collection.parallelStream();
        }
        return collection.stream();
    }

    private UpdatedCost processCost(ProvQuote entity, boolean lean) {
        Map<ResourceType, Map<Integer, Floating>> relatedCosts = Collections.synchronizedMap(new EnumMap(ResourceType.class));
        return this.processCost(entity, lean, relatedCosts);
    }

    private UpdatedCost processCost(ProvQuote entity, boolean lean, Map<ResourceType, Map<Integer, Floating>> relatedCosts) {
        if (lean) {
            this.budgetResource.lean(entity, relatedCosts);
            return this.processCost(entity, false, relatedCosts);
        }
        log.info("Refresh cost started for subscription {}", (Object)entity.getSubscription().getId());
        entity.setCostNoSupport(0.0);
        entity.setMaxCostNoSupport(0.0);
        entity.setCost(0.0);
        entity.setMaxCost(0.0);
        entity.setCo2(0.0);
        entity.setMaxCo2(0.0);
        entity.setInitialCost(0.0);
        entity.setMaxInitialCost(0.0);
        Hibernate.initialize(entity.getUsages());
        Hibernate.initialize(entity.getBudgets());
        Hibernate.initialize(entity.getOptimizers());
        long unbound = 0L;
        unbound += this.addCost(entity, this.qiRepository, this.qiResource, "instances");
        unbound += this.addCost(entity, this.qbRepository, this.qbResource, "databases");
        unbound += this.addCost(entity, this.qcRepository, this.qcResource, "containers");
        entity.setUnboundCostCounter((int)(unbound += this.addCost(entity, this.qfRepository, this.qfResource, "functions")));
        log.info("Refresh cost started for subscription {} / storages ... ", (Object)entity.getSubscription().getId());
        this.newStream(this.qsRepository.findAll(entity)).map(this.qsResource::updateCost).forEach(fc -> this.addCost(entity, (Floating)fc));
        log.info("Refresh cost started for subscription {} / support ... ", (Object)entity.getSubscription().getId());
        UpdatedCost cost = new UpdatedCost((Integer)entity.getId());
        log.info("Refresh cost finished for subscription {}", (Object)entity.getSubscription().getId());
        cost.setRelated(relatedCosts);
        return this.refreshSupportCost(cost, entity);
    }

    private <P extends AbstractTermPrice<?>, C extends AbstractQuote<P>> long addCost(ProvQuote entity, BaseProvQuoteRepository<C> repository, AbstractProvQuoteResource<?, P, C, ?> resource, String type) {
        log.info("Refresh cost started for subscription {} / {} ... ", (Object)entity.getSubscription().getId(), (Object)type);
        return this.newStream(repository.findAll(entity)).map(resource::updateCost).map(fc -> this.addCost(entity, (Floating)fc)).filter(Floating::isUnbound).count();
    }

    private Floating refreshSupportCost(ProvQuote entity) {
        Floating support = this.qs2Repository.findAll(entity).stream().map(this.qspResource::refresh).reduce(new Floating(0.0, 0.0, 0.0, 0.0, entity.isUnboundCost(), 0.0, 0.0), Floating::add);
        entity.setCostSupport(this.round(support.getMin()));
        entity.setMaxCostSupport(this.round(support.getMax()));
        entity.setCost(this.round(entity.getCostSupport() + entity.getCostNoSupport()));
        entity.setMaxCost(this.round(entity.getMaxCostSupport() + entity.getMaxCostNoSupport()));
        return entity.toFloating();
    }

    public UpdatedCost refreshSupportCost(UpdatedCost cost, ProvQuote quote) {
        cost.setTotal(this.refreshSupportCost(quote).round());
        quote.getSupports().forEach(s -> cost.getRelated().computeIfAbsent(ResourceType.SUPPORT, k -> new HashMap()).put((Integer)s.getId(), s.toFloating()));
        return cost;
    }

    public <Q extends AbstractQuote<?>> UpdatedCost refreshSupportCost(UpdatedCost cost, Q entity) {
        return this.refreshSupportCost(cost, entity.getConfiguration());
    }

    @Override
    @PUT
    @Path(value="{subscription:\\d+}/refresh")
    @Consumes(value={"application/json"})
    public Floating refresh(@PathParam(value="subscription") int subscription) {
        return this.refresh(this.getQuoteFromSubscription(subscription));
    }

    @Override
    public Floating refresh(ProvQuote entity) {
        this.updateCurrency(entity);
        return this.processCost(entity, true).getTotal();
    }

    private void updateCurrency(ProvQuote entity) {
        entity.setCurrency(Optional.ofNullable((String)this.subscriptionResource.getParameters(((Integer)entity.getSubscription().getId()).intValue()).get(PARAMETER_CURRENCY_NAME)).map(arg_0 -> ((ProvCurrencyRepository)this.currencyRepository).findByName(arg_0)).orElse(null));
    }

    public void create(int subscription) {
        ProvQuote quote = new ProvQuote();
        quote.setSubscription((Subscription)this.subscriptionRepository.findOne((Serializable)Integer.valueOf(subscription)));
        quote.setName(quote.getSubscription().getProject().getName());
        Node provider = quote.getSubscription().getNode().getRefined();
        List locations = this.locationRepository.findAllBy("node.id", provider.getId());
        if (locations.isEmpty()) {
            throw new BusinessException(SERVICE_KEY + "-no-catalog", new Object[]{provider.getId(), provider.getName()});
        }
        ProvLocation location = (ProvLocation)((Object)this.locationRepository.findBy("node.id", provider.getId(), new String[]{"preferred"}, new Object[]{true}));
        if (location == null) {
            quote.setLocation((ProvLocation)((Object)locations.getFirst()));
        } else {
            quote.setLocation(location);
        }
        quote.setDescription(quote.getSubscription().getProject().getPkey() + "-> " + provider.getName());
        this.updateCurrency(quote);
        this.repository.saveAndFlush(quote);
    }

    public <K extends Serializable, T extends Configurable<ProvQuote, K>> T findConfigured(RestRepository<T, K> repository, K id, int subscription) {
        Configurable entity = this.findConfigured(repository, id);
        if ((Integer)((ProvQuote)entity.getConfiguration()).getSubscription().getId() != subscription) {
            throw new EntityNotFoundException(id.toString());
        }
        return (T)entity;
    }

    public void delete(int subscription, boolean remoteData) {
        Optional.ofNullable((ProvQuote)this.repository.findBy("subscription.id", subscription)).ifPresent(c -> this.repository.delete(c));
    }

    public List<Class<?>> getInstalledEntities() {
        return Arrays.asList(Node.class, SystemConfiguration.class);
    }

    @GET
    @Path(value="location/{node:service:prov:.*}")
    @Consumes(value={"application/json"})
    public List<ProvLocation> findLocations(@PathParam(value="node") String node) {
        this.nodeResource.checkVisible(node);
        return this.locationRepository.findAll(node);
    }

    public String getName() {
        return "Provisioning";
    }

    public AbstractProvQuoteResource<?, ?, ?, ?> getResource(ResourceType type) {
        return (AbstractProvQuoteResource)this.context.getBean("provQuote" + StringUtils.capitalize((String)type.name().toLowerCase()) + "Resource", AbstractProvQuoteResource.class);
    }

    @Override
    @Generated
    public SubscriptionResource getSubscriptionResource() {
        return this.subscriptionResource;
    }

    @Override
    @Generated
    public ProvQuoteRepository getRepository() {
        return this.repository;
    }

    static {
        ORM_COLUMNS.put("name", "name");
        ORM_COLUMNS.put("description", "description");
    }
}

