/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov;

import jakarta.persistence.EntityNotFoundException;
import jakarta.transaction.Transactional;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import org.ligoj.app.plugin.prov.AbstractLazyResource;
import org.ligoj.app.plugin.prov.AbstractNetworkVo;
import org.ligoj.app.plugin.prov.NetworkFullByNameVo;
import org.ligoj.app.plugin.prov.NetworkFullVo;
import org.ligoj.app.plugin.prov.NetworkVo;
import org.ligoj.app.plugin.prov.dao.ProvNetworkRepository;
import org.ligoj.app.plugin.prov.model.AbstractQuote;
import org.ligoj.app.plugin.prov.model.ProvNetwork;
import org.ligoj.app.plugin.prov.model.ProvQuote;
import org.ligoj.app.plugin.prov.model.ResourceType;
import org.ligoj.bootstrap.core.validation.ValidationJsonException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Path(value="/service/prov")
@Produces(value={"application/json"})
@Transactional
public class ProvNetworkResource
extends AbstractLazyResource {
    @Autowired
    private ProvNetworkRepository repository;

    public List<ProvNetwork> findAll(int subscription) {
        return this.repository.findAll(subscription);
    }

    @Override
    public void onDelete(ResourceType type, Integer ... resources) {
        Arrays.stream(resources).forEach(r -> this.repository.deleteAllBy("sourceType", (Object)type, new String[]{"source"}, new Object[]{r}));
        Arrays.stream(resources).forEach(r -> this.repository.deleteAllBy("targetType", (Object)type, new String[]{"target"}, new Object[]{r}));
    }

    @Override
    public void onDeleteAll(ResourceType type, int quote) {
        this.repository.deleteAllBy("configuration.id", quote, new String[]{"sourceType"}, new Object[]{type});
        this.repository.deleteAllBy("configuration.id", quote, new String[]{"targetType"}, new Object[]{type});
    }

    private void validateId(ResourceType type, Integer id, Map<ResourceType, Set<Integer>> existing) {
        if (!existing.get((Object)type).contains(id)) {
            throw new EntityNotFoundException(id.toString());
        }
    }

    @PUT
    @Path(value="{subscription:\\d+}/network")
    @Consumes(value={"application/json"})
    public void updateAllById(@PathParam(value="subscription") int subscription, List<NetworkFullVo> io) {
        ProvQuote quote = this.deleteAll(subscription);
        EnumMap ids = new EnumMap(ResourceType.class);
        Arrays.stream(ResourceType.values()).filter(ResourceType::isNetwork).forEach(t -> ids.put((ResourceType)((Object)t), this.getRepository((ResourceType)((Object)t)).findAllNetworkId(quote)));
        io.stream().map(t -> {
            this.validateId(t.getPeerType(), t.getPeer(), ids);
            this.validateId(t.getSourceType(), t.getSource(), ids);
            return this.newNetwork(t.getSourceType(), t.getSource(), quote, (NetworkVo)t);
        }).forEach(arg_0 -> ((ProvNetworkRepository)this.repository).save(arg_0));
    }

    @PUT
    @Path(value="{subscription:\\d+}/network-name")
    @Consumes(value={"application/json"})
    public int updateAllByName(@PathParam(value="subscription") int subscription, @QueryParam(value="continue-on-error") @DefaultValue(value="false") boolean continueOnError, List<NetworkFullByNameVo> io) {
        ProvQuote quote = this.deleteAll(subscription);
        AtomicInteger errors = new AtomicInteger();
        EnumMap idAndNames = new EnumMap(ResourceType.class);
        Arrays.stream(ResourceType.values()).filter(ResourceType::isNetwork).forEach(t -> idAndNames.put((ResourceType)((Object)t), this.getRepository((ResourceType)((Object)t)).findAllNetworkIdName(quote).stream().collect(Collectors.toMap(o -> (Integer)o[0], o -> (String)o[1]))));
        EnumMap nameAndIds = new EnumMap(ResourceType.class);
        HashMap counters = new HashMap();
        idAndNames.keySet().forEach(t -> {
            HashMap names = new HashMap();
            nameAndIds.put((ResourceType)((Object)t), names);
            ((Map)idAndNames.get(t)).forEach((id, name) -> {
                counters.computeIfPresent(name, (n, o) -> 2);
                counters.computeIfAbsent(name, n -> 1);
                names.computeIfAbsent(name, n -> id);
            });
        });
        io.forEach(n -> {
            ProvNetwork entity = new ProvNetwork();
            if (this.validateName(nameAndIds, counters, n.getSource(), entity::setSource, entity::setSourceType, continueOnError)) {
                if (this.validateName(nameAndIds, counters, n.getPeer(), entity::setTarget, entity::setTargetType, continueOnError)) {
                    this.repository.save((Object)this.copyNetworkData(quote, n, entity));
                    return;
                }
            }
            errors.incrementAndGet();
        });
        this.repository.flush();
        return errors.get();
    }

    private boolean validateName(Map<ResourceType, Map<String, Integer>> nameAndIds, Map<String, Integer> counters, String name, IntConsumer setId, Consumer<ResourceType> setType, boolean continueOnError) {
        if (!counters.containsKey(name)) {
            if (continueOnError) {
                return false;
            }
            throw new EntityNotFoundException(name);
        }
        ValidationJsonException.assertTrue((counters.get(name) == 1 ? 1 : 0) != 0, (String)"ambiguous-name", (Object[])new Object[]{"name", name});
        nameAndIds.entrySet().stream().filter(e -> ((Map)e.getValue()).containsKey(name)).limit(1L).forEach(e -> {
            setId.accept((Integer)((Map)e.getValue()).get(name));
            setType.accept((ResourceType)((Object)((Object)e.getKey())));
        });
        return true;
    }

    private ProvQuote deleteAll(int subscription) {
        ProvQuote quote = this.resource.getQuoteFromSubscription(subscription);
        this.repository.deleteAll((Integer)quote.getId());
        return quote;
    }

    @PUT
    @Path(value="{subscription:\\d+}/network/{type}/{id:\\d+}")
    @Consumes(value={"application/json"})
    public void update(@PathParam(value="subscription") int subscription, @PathParam(value="type") ResourceType type, @PathParam(value="id") int id, List<NetworkVo> io) {
        AbstractQuote related = (AbstractQuote)this.resource.findConfigured(this.getRepository(type), id, subscription);
        this.onDelete(type, id);
        io.stream().map(t -> {
            this.resource.findConfigured(this.getRepository(t.getPeerType()), t.getPeer(), subscription);
            return this.newNetwork(type, id, related.getConfiguration(), (NetworkVo)t);
        }).forEach(arg_0 -> ((ProvNetworkRepository)this.repository).save(arg_0));
    }

    private ProvNetwork newNetwork(ResourceType type, Integer id, ProvQuote quote, NetworkVo t) {
        ProvNetwork entity = new ProvNetwork();
        if (t.isInbound()) {
            entity.setSource(t.getPeer());
            entity.setSourceType(t.getPeerType());
            entity.setTarget(id);
            entity.setTargetType(type);
        } else {
            entity.setSource(id);
            entity.setSourceType(type);
            entity.setTarget(t.getPeer());
            entity.setTargetType(t.getPeerType());
        }
        this.copyNetworkData(quote, t, entity);
        return entity;
    }

    private <N extends AbstractNetworkVo> ProvNetwork copyNetworkData(ProvQuote quote, N vo, ProvNetwork entity) {
        entity.setName(vo.getName());
        entity.setPort(vo.getPort());
        entity.setRate(vo.getRate());
        entity.setThroughput(vo.getThroughput());
        entity.setConfiguration(quote);
        return entity;
    }
}

