/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov;

import jakarta.transaction.Transactional;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import net.jnellis.binpack.LinearBin;
import net.jnellis.binpack.LinearBinPacker;
import org.apache.commons.lang3.BooleanUtils;
import org.hibernate.Hibernate;
import org.ligoj.app.plugin.prov.AbstractMultiScopedResource;
import org.ligoj.app.plugin.prov.AbstractProvQuoteVmResource;
import org.ligoj.app.plugin.prov.BudgetEditionVo;
import org.ligoj.app.plugin.prov.Floating;
import org.ligoj.app.plugin.prov.FloatingPrice;
import org.ligoj.app.plugin.prov.ProvResource;
import org.ligoj.app.plugin.prov.UpdatedCost;
import org.ligoj.app.plugin.prov.dao.ProvBudgetRepository;
import org.ligoj.app.plugin.prov.model.AbstractInstanceType;
import org.ligoj.app.plugin.prov.model.AbstractPrice;
import org.ligoj.app.plugin.prov.model.AbstractQuoteVm;
import org.ligoj.app.plugin.prov.model.AbstractTermPrice;
import org.ligoj.app.plugin.prov.model.AbstractTermPriceVm;
import org.ligoj.app.plugin.prov.model.ProvBudget;
import org.ligoj.app.plugin.prov.model.ProvQuote;
import org.ligoj.app.plugin.prov.model.ProvQuoteContainer;
import org.ligoj.app.plugin.prov.model.ProvQuoteDatabase;
import org.ligoj.app.plugin.prov.model.ProvQuoteFunction;
import org.ligoj.app.plugin.prov.model.ProvQuoteInstance;
import org.ligoj.app.plugin.prov.model.ProvQuoteStorage;
import org.ligoj.app.plugin.prov.model.ResourceScope;
import org.ligoj.app.plugin.prov.model.ResourceType;
import org.ligoj.bootstrap.resource.system.configuration.ConfigurationResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.AbstractPersistable;
import org.springframework.stereotype.Service;

@Service
@Path(value="/service/prov/{subscription:\\d+}/budget")
@Produces(value={"application/json"})
@Transactional
public class ProvBudgetResource
extends AbstractMultiScopedResource<ProvBudget, ProvBudgetRepository, BudgetEditionVo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProvBudgetResource.class);
    @Autowired
    private ProvBudgetRepository repository;
    @Autowired
    private ConfigurationResource configuration;

    public ProvBudgetResource() {
        super(ResourceScope::getBudget, ResourceScope::setBudget, ProvBudget::new, ProvQuote::getBudgets);
    }

    @Override
    protected UpdatedCost saveOrUpdate(ProvBudget entity, BudgetEditionVo vo) {
        entity.setName(vo.getName());
        entity.setInitialCost(vo.getInitialCost());
        ProvQuote quote = entity.getConfiguration();
        Hibernate.initialize(quote.getBudgets());
        Map<ResourceType, Map<Integer, Floating>> relatedCosts = Collections.synchronizedMap(new EnumMap(ResourceType.class));
        if (entity.getId() != null) {
            this.lean(entity, relatedCosts);
        }
        this.repository.saveAndFlush((Object)entity);
        UpdatedCost cost = new UpdatedCost((Integer)entity.getId());
        cost.setRelated(relatedCosts);
        UpdatedCost updateCost = this.resource.refreshSupportCost(cost, quote);
        log.info("Total2 monthly cost: {}", (Object)updateCost.getTotal().getMin());
        log.info("Total2 initial cost: {}", (Object)updateCost.getTotal().getInitial());
        return updateCost;
    }

    public void lean(ProvQuote quote, Map<ResourceType, Map<Integer, Floating>> costs) {
        Hibernate.initialize(quote.getUsages());
        Hibernate.initialize(quote.getBudgets());
        Hibernate.initialize(quote.getOptimizers());
        Hibernate.initialize(quote.getInstances());
        Hibernate.initialize(quote.getDatabases());
        Hibernate.initialize(quote.getContainers());
        Hibernate.initialize(quote.getFunctions());
        Hibernate.initialize(quote.getStorages());
        List<ProvQuoteInstance> instances = this.qiRepository.findAll(quote);
        List<ProvQuoteDatabase> databases = this.qbRepository.findAll(quote);
        List<ProvQuoteContainer> containers = this.qcRepository.findAll(quote);
        List<ProvQuoteFunction> functions = this.qfRepository.findAll(quote);
        List<ProvQuoteStorage> storages = this.qsRepository.findAll(quote);
        this.lean(quote, instances, databases, containers, functions, storages, costs);
        Set usedBudgets = Stream.of(instances, databases, containers, functions).flatMap(Collection::stream).map(AbstractQuoteVm::getResolvedBudget).filter(Objects::nonNull).distinct().map(AbstractPersistable::getId).collect(Collectors.toSet());
        this.repository.findAll(quote).stream().filter(b -> !usedBudgets.contains(b.getId())).forEach(b -> b.setRequiredInitialCost(0.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lean(ProvQuote quote, List<ProvQuoteInstance> instances, List<ProvQuoteDatabase> databases, List<ProvQuoteContainer> containers, List<ProvQuoteFunction> functions, List<ProvQuoteStorage> storages, Map<ResourceType, Map<Integer, Floating>> costs) {
        Object object = quote.getLeanLock();
        synchronized (object) {
            List<ProvBudget> budgets = Stream.of(instances, databases, containers, functions).flatMap(Collection::stream).map(AbstractQuoteVm::getResolvedBudget).filter(Objects::nonNull).filter(b -> b.getInitialCost() > 0.0).distinct().toList();
            budgets.forEach(b -> this.lean((ProvBudget)((Object)b), costs));
            this.refreshNoBudget(instances, ResourceType.INSTANCE, costs, this.qiResource);
            this.refreshNoBudget(databases, ResourceType.DATABASE, costs, this.qbResource);
            this.refreshNoBudget(containers, ResourceType.CONTAINER, costs, this.qcResource);
            this.refreshNoBudget(functions, ResourceType.FUNCTION, costs, this.qfResource);
            this.resource.newStream(storages).forEach(i -> costs.computeIfAbsent(ResourceType.STORAGE, k -> new ConcurrentHashMap()).put((Integer)i.getId(), this.qsResource.addCost(i, this.qsResource::refresh)));
        }
    }

    private <T extends AbstractInstanceType, P extends AbstractTermPriceVm<T>, C extends AbstractQuoteVm<P>> void refreshNoBudget(List<C> entities, ResourceType type, Map<ResourceType, Map<Integer, Floating>> costs, AbstractProvQuoteVmResource<T, P, C, ?, ?, ?> resource) {
        this.resource.newStream(entities).filter(i -> Optional.ofNullable(i.getResolvedBudget()).map(ProvBudget::getInitialCost).orElse(0.0) == 0.0).forEach(i -> costs.computeIfAbsent(type, k -> new ConcurrentHashMap()).put((Integer)i.getId(), resource.addCost(i, resource::refresh)));
    }

    public void lean(ProvBudget budget, Map<ResourceType, Map<Integer, Floating>> costs) {
        if (budget == null) {
            return;
        }
        Hibernate.initialize(budget.getConfiguration().getUsages());
        Hibernate.initialize(budget.getConfiguration().getBudgets());
        Hibernate.initialize(budget.getConfiguration().getOptimizers());
        log.info("Lean budget {} in subscription {}", (Object)budget.getName(), (Object)budget.getConfiguration().getSubscription().getId());
        List<ProvQuoteInstance> instances = this.getRelated(this.getRepository()::findRelatedInstances, budget);
        List<ProvQuoteDatabase> databases = this.getRelated(this.getRepository()::findRelatedDatabases, budget);
        List<ProvQuoteContainer> containers = this.getRelated(this.getRepository()::findRelatedContainers, budget);
        List<ProvQuoteFunction> functions = this.getRelated(this.getRepository()::findRelatedFunctions, budget);
        budget.setRemainingBudget(budget.getInitialCost());
        budget.setRequiredInitialCost(this.leanRecursive(budget, instances, databases, containers, functions, costs));
        budget.setRemainingBudget(null);
        this.logLean(c -> {
            log.info("Monthly costs:{}", c.stream().map(i -> i.getPrice().getCost()).toList());
            log.info("Monthly cost: {}", (Object)c.stream().mapToDouble(i -> i.getPrice().getCost()).sum());
            log.info("Initial cost: {}", (Object)c.stream().mapToDouble(i -> ((AbstractTermPrice)i.getPrice()).getInitialCost()).sum());
        }, instances, databases, containers, functions);
    }

    private void logLean(Consumer<List<? extends AbstractQuoteVm<?>>> logger, List<ProvQuoteInstance> instances, List<ProvQuoteDatabase> databases, List<ProvQuoteContainer> containers, List<ProvQuoteFunction> functions) {
        if (BooleanUtils.toBoolean((String)this.configuration.get(ProvResource.SERVICE_KEY + ":log"))) {
            List.of(instances, databases, containers, functions).forEach(logger);
        }
    }

    private <C> void logLean(Consumer<C> logger, C object) {
        if (BooleanUtils.toBoolean((String)this.configuration.get(ProvResource.SERVICE_KEY + ":log"))) {
            logger.accept(object);
        }
    }

    private Comparator<? super Map.Entry<Double, AbstractQuoteVm<?>>> priceOrder(Map<AbstractQuoteVm<?>, FloatingPrice<?>> prices) {
        return (e1, e2) -> {
            double c1 = ((AbstractPrice)((Object)((Object)((FloatingPrice)prices.get(e1.getValue())).getPrice()))).getCost();
            double c2 = ((AbstractPrice)((Object)((Object)((FloatingPrice)prices.get(e2.getValue())).getPrice()))).getCost();
            int compare = (int)(c2 - c1);
            if (compare == 0) {
                compare = ((AbstractQuoteVm)e1.getValue()).getName().compareTo(((AbstractQuoteVm)e2.getValue()).getName());
            }
            return compare;
        };
    }

    private double leanRecursive(ProvBudget budget, List<ProvQuoteInstance> instances, List<ProvQuoteDatabase> databases, List<ProvQuoteContainer> containers, List<ProvQuoteFunction> functions, Map<ResourceType, Map<Integer, Floating>> costs) {
        this.logLean(c -> log.info("Start lean: {}", c.stream().map(i -> i.getName() + "(" + i.getPrice().getCode() + ")").toList()), instances, databases, containers, functions);
        ConcurrentHashMap initialCosts = new ConcurrentHashMap();
        ConcurrentHashMap prices = new ConcurrentHashMap();
        List<ProvQuoteInstance> validatedQi = this.lookup(instances, prices, this.qiResource, initialCosts);
        List<ProvQuoteDatabase> validatedQb = this.lookup(databases, prices, this.qbResource, initialCosts);
        List<ProvQuoteContainer> validatedQc = this.lookup(containers, prices, this.qcResource, initialCosts);
        List<ProvQuoteFunction> validatedQf = this.lookup(functions, prices, this.qfResource, initialCosts);
        IdentityHashMap packToQrRev = initialCosts.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (a, b) -> b, IdentityHashMap::new));
        double init = this.pack(budget, packToQrRev, prices, validatedQi, validatedQb, validatedQc, validatedQf, costs);
        this.commitPrices(validatedQi, prices, ResourceType.INSTANCE, costs, this.qiResource);
        this.commitPrices(validatedQb, prices, ResourceType.DATABASE, costs, this.qbResource);
        this.commitPrices(validatedQc, prices, ResourceType.CONTAINER, costs, this.qcResource);
        this.commitPrices(validatedQf, prices, ResourceType.FUNCTION, costs, this.qfResource);
        this.logLean(t -> {
            log.info("Lean:              {}", t.stream().map(i -> i.getName() + "(" + i.getPrice().getCode() + ")").toList());
            log.info("Lean monthly costs:{}", t.stream().map(i -> i.getPrice().getCost()).toList());
            log.info("Lean monthly cost: {}", (Object)t.stream().mapToDouble(i -> i.getPrice().getCost()).sum());
            log.info("Lean initial cost: {}", (Object)t.stream().mapToDouble(i -> ((AbstractTermPrice)i.getPrice()).getInitialCost()).sum());
        }, validatedQi, validatedQb, validatedQc, validatedQf);
        this.logLean(c -> log.info("Total initialCost:{}", c), init);
        return Floating.round(init);
    }

    private double pack(ProvBudget budget, Map<Double, AbstractQuoteVm<?>> packToQr, Map<AbstractQuoteVm<?>, FloatingPrice<?>> prices, List<ProvQuoteInstance> validatedQi, List<ProvQuoteDatabase> validatedQb, List<ProvQuoteContainer> validatedQc, List<ProvQuoteFunction> validatedQf, Map<ResourceType, Map<Integer, Floating>> costs) {
        if (packToQr.isEmpty()) {
            return 0.0;
        }
        long packStart = System.currentTimeMillis();
        LinearBinPacker packer = new LinearBinPacker();
        ArrayList entries = new ArrayList(packToQr.entrySet());
        List<LinearBin> bins = packer.packAll(new ArrayList<Double>(entries.stream().sorted(this.priceOrder(prices)).map(Map.Entry::getKey).toList()), new ArrayList<LinearBin>(List.of(new LinearBin(budget.getRemainingBudget()))), new ArrayList<Double>(List.of(Double.valueOf(Double.MAX_VALUE))));
        LinearBin bin = bins.getFirst();
        bin.getPieces().stream().map(packToQr::get).forEach(i -> {
            if (i.getResourceType() == ResourceType.INSTANCE) {
                validatedQi.add((ProvQuoteInstance)i);
            } else if (i.getResourceType() == ResourceType.DATABASE) {
                validatedQb.add((ProvQuoteDatabase)i);
            } else if (i.getResourceType() == ResourceType.CONTAINER) {
                validatedQc.add((ProvQuoteContainer)i);
            } else {
                validatedQf.add((ProvQuoteFunction)i);
            }
        });
        this.logLean(b -> {
            log.info("Packing result: {}", ((LinearBin)b.getFirst()).getPieces().stream().map(packToQr::get).map(i -> i.getName() + "(" + i.getPrice().getCode() + ")").toList());
            log.info("Packing result: {}", b);
        }, bins);
        this.logPack(packStart, packToQr, budget);
        double init = bin.getTotal();
        if (bins.size() > 1) {
            budget.setRemainingBudget(Floating.round(budget.getRemainingBudget() - bin.getTotal()));
            List<ProvQuoteInstance> subQi = this.newSubPack(packToQr, bins, ResourceType.INSTANCE);
            List<ProvQuoteDatabase> subQb = this.newSubPack(packToQr, bins, ResourceType.DATABASE);
            List<ProvQuoteContainer> subQc = this.newSubPack(packToQr, bins, ResourceType.CONTAINER);
            List<ProvQuoteFunction> subQf = this.newSubPack(packToQr, bins, ResourceType.FUNCTION);
            init += this.leanRecursive(budget, subQi, subQb, subQc, subQf, costs);
        }
        return init;
    }

    protected void logPack(long packStart, Map<Double, AbstractQuoteVm<?>> packToQr, ProvBudget budget) {
        long packTime = System.currentTimeMillis() - packStart;
        if (packTime > 500L) {
            log.info("Packing of {} resources for subscription {} took {}", new Object[]{packToQr.size(), budget.getConfiguration().getSubscription().getId(), Duration.ofMillis(packTime)});
        }
    }

    private <T extends AbstractInstanceType, P extends AbstractTermPriceVm<T>, C extends AbstractQuoteVm<P>> List<C> newSubPack(Map<Double, AbstractQuoteVm<?>> packToQr, List<LinearBin> bins, ResourceType type) {
        return bins.get(1).getPieces().stream().map(packToQr::get).filter(i -> i.getResourceType() == type).toList();
    }

    private <T extends AbstractInstanceType, P extends AbstractTermPriceVm<T>, C extends AbstractQuoteVm<P>> void commitPrices(List<C> nodes, Map<AbstractQuoteVm<?>, FloatingPrice<?>> prices, ResourceType type, Map<ResourceType, Map<Integer, Floating>> costs, AbstractProvQuoteVmResource<T, P, C, ?, ?, ?> resource) {
        nodes.forEach(i -> {
            FloatingPrice price = (FloatingPrice)prices.get(i);
            costs.computeIfAbsent(type, k -> new HashMap()).put((Integer)i.getId(), resource.addCost(i, qi -> {
                qi.setPrice((AbstractTermPriceVm)price.getPrice());
                return resource.updateCost(qi);
            }));
        });
    }

    private <T extends AbstractInstanceType, P extends AbstractTermPriceVm<T>, C extends AbstractQuoteVm<P>> List<C> lookup(List<C> nodes, Map<AbstractQuoteVm<?>, FloatingPrice<?>> prices, AbstractProvQuoteVmResource<T, P, C, ?, ?, ?> resource, Map<AbstractQuoteVm<?>, Double> initialCosts) {
        ArrayList validatedQi = new ArrayList();
        this.resource.newStream(nodes).forEach(i -> {
            FloatingPrice price = resource.getNewPrice(i);
            prices.put((AbstractQuoteVm<?>)i, price);
            if (price.getCost().getInitial() > 0.0) {
                initialCosts.put((AbstractQuoteVm<?>)i, price.getCost().getInitial());
            } else {
                validatedQi.add(i);
            }
        });
        return validatedQi;
    }

    @Override
    @Generated
    public ProvBudgetRepository getRepository() {
        return this.repository;
    }
}

