/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov;

import jakarta.persistence.EntityNotFoundException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Hibernate;
import org.ligoj.app.model.Subscription;
import org.ligoj.app.plugin.prov.AbstractLookup;
import org.ligoj.app.plugin.prov.AbstractProvQuoteResource;
import org.ligoj.app.plugin.prov.AbstractQuoteVmEditionVo;
import org.ligoj.app.plugin.prov.Floating;
import org.ligoj.app.plugin.prov.FloatingPrice;
import org.ligoj.app.plugin.prov.ProvBudgetResource;
import org.ligoj.app.plugin.prov.ProvResource;
import org.ligoj.app.plugin.prov.ProvisioningService;
import org.ligoj.app.plugin.prov.UpdatedCost;
import org.ligoj.app.plugin.prov.Workload;
import org.ligoj.app.plugin.prov.dao.BasePovInstanceBehavior;
import org.ligoj.app.plugin.prov.dao.BaseProvInstanceTypeRepository;
import org.ligoj.app.plugin.prov.dao.BaseProvTermPriceRepository;
import org.ligoj.app.plugin.prov.dao.Optimizer;
import org.ligoj.app.plugin.prov.dao.ProvInstancePriceTermRepository;
import org.ligoj.app.plugin.prov.dao.ProvLocationRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteStorageRepository;
import org.ligoj.app.plugin.prov.model.AbstractInstanceType;
import org.ligoj.app.plugin.prov.model.AbstractPrice;
import org.ligoj.app.plugin.prov.model.AbstractQuote;
import org.ligoj.app.plugin.prov.model.AbstractQuoteVm;
import org.ligoj.app.plugin.prov.model.AbstractTermPrice;
import org.ligoj.app.plugin.prov.model.AbstractTermPriceVm;
import org.ligoj.app.plugin.prov.model.ProvBudget;
import org.ligoj.app.plugin.prov.model.ProvInstancePriceTerm;
import org.ligoj.app.plugin.prov.model.ProvLocation;
import org.ligoj.app.plugin.prov.model.ProvOptimizer;
import org.ligoj.app.plugin.prov.model.ProvQuote;
import org.ligoj.app.plugin.prov.model.ProvQuoteStorage;
import org.ligoj.app.plugin.prov.model.ProvUsage;
import org.ligoj.app.plugin.prov.model.QuoteVm;
import org.ligoj.app.plugin.prov.model.ReservationMode;
import org.ligoj.app.plugin.prov.model.ResourceType;
import org.ligoj.app.plugin.prov.quote.storage.ProvQuoteStorageResource;
import org.ligoj.app.plugin.prov.quote.support.QuoteTagSupport;
import org.ligoj.app.resource.ServicePluginLocator;
import org.ligoj.bootstrap.core.DescribedBean;
import org.ligoj.bootstrap.core.INamableBean;
import org.ligoj.bootstrap.core.json.TableItem;
import org.ligoj.bootstrap.core.json.datatable.DataTableAttributes;
import org.ligoj.bootstrap.core.validation.ValidationJsonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;

public abstract class AbstractProvQuoteVmResource<T extends AbstractInstanceType, P extends AbstractTermPriceVm<T>, C extends AbstractQuoteVm<P>, E extends AbstractQuoteVmEditionVo, L extends AbstractLookup<P>, Q extends QuoteVm>
extends AbstractProvQuoteResource<T, P, C, E> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractProvQuoteVmResource.class);
    public static final ProvUsage USAGE_DEFAULT = new ProvUsage();
    protected static final ProvBudget BUDGET_DEFAULT = new ProvBudget();
    protected static final ProvOptimizer OPTIMIZER_DEFAULT = new ProvOptimizer();
    @Autowired
    protected ProvQuoteStorageResource storageResource;
    @Autowired
    protected ProvInstancePriceTermRepository iptRepository;
    @Autowired
    protected ProvLocationRepository locationRepository;
    @Autowired
    protected ProvQuoteStorageRepository qsRepository;
    @Autowired
    protected ProvBudgetResource budgetResource;
    @Autowired
    protected ServicePluginLocator locator;

    @Override
    public abstract BaseProvTermPriceRepository<T, P> getIpRepository();

    @Override
    public abstract BaseProvInstanceTypeRepository<T> getItRepository();

    @Override
    public UpdatedCost update(E vo) {
        return this.saveOrUpdate((AbstractQuoteVm)this.resource.findConfigured(this.getQiRepository(), (Integer)vo.getId()), vo);
    }

    public UpdatedCost saveOrUpdate(C entity, E vo) {
        return this.saveOrUpdate(this.getQuoteFromSubscription(((AbstractQuoteVmEditionVo)vo).getSubscription()), entity, vo);
    }

    public UpdatedCost saveOrUpdate(ProvQuote quote, C entity, E vo) {
        int deltaUnbound = BooleanUtils.toInteger((((AbstractQuoteVmEditionVo)vo).getMaxQuantity() == null ? 1 : 0) != 0) - BooleanUtils.toInteger((boolean)((AbstractQuoteVm)entity).isUnboundCost());
        Subscription subscription = quote.getSubscription();
        String providerId = subscription.getNode().getRefined().getId();
        DescribedBean.copy(vo, entity);
        ((AbstractQuote)entity).setConfiguration(quote);
        ProvLocation oldLocation = ((AbstractQuote)entity).getResolvedLocation();
        ProvBudget oldBudget = ((AbstractQuoteVm)entity).getResolvedBudget();
        ((AbstractQuote)entity).setPrice((AbstractTermPriceVm)((AbstractTermPriceVm)this.getIpRepository().findOneExpected((Serializable)((AbstractQuoteVmEditionVo)vo).getPrice())));
        this.resource.checkVisibility((AbstractInstanceType)((AbstractQuoteVm)entity).getPrice().getType(), providerId);
        ((AbstractQuote)entity).setLocation(this.resource.findLocation(providerId, ((AbstractQuoteVmEditionVo)vo).getLocation()));
        ((AbstractQuoteVm)entity).setUsage(Optional.ofNullable(((AbstractQuoteVmEditionVo)vo).getUsage()).map(u -> this.getUsage(quote, (String)u)).orElse(null));
        ((AbstractQuoteVm)entity).setBudget(Optional.ofNullable(((AbstractQuoteVmEditionVo)vo).getBudget()).map(u -> this.getBudget(quote, (String)u)).orElse(null));
        ((AbstractQuoteVm)entity).setOptimizer(Optional.ofNullable(((AbstractQuoteVmEditionVo)vo).getOptimizer()).map(u -> this.getOptimizer(quote, (String)u)).orElse(null));
        ((AbstractQuoteVm)entity).setRam(((AbstractQuoteVmEditionVo)vo).getRam());
        ((AbstractQuoteVm)entity).setCpu(((AbstractQuoteVmEditionVo)vo).getCpu());
        ((AbstractQuoteVm)entity).setGpu(((AbstractQuoteVmEditionVo)vo).getGpu());
        ((AbstractQuoteVm)entity).setProcessor(((AbstractQuoteVmEditionVo)vo).getProcessor());
        ((AbstractQuoteVm)entity).setWorkload(((AbstractQuoteVmEditionVo)vo).getWorkload());
        ((AbstractQuoteVm)entity).setPhysical(((AbstractQuoteVmEditionVo)vo).getPhysical());
        ((AbstractQuoteVm)entity).setMinQuantity(((AbstractQuoteVmEditionVo)vo).getMinQuantity());
        ((AbstractQuoteVm)entity).setMaxQuantity(((AbstractQuoteVmEditionVo)vo).getMaxQuantity());
        ((AbstractQuoteVm)entity).setLicense(Optional.ofNullable(((AbstractQuoteVmEditionVo)vo).getLicense()).map(StringUtils::upperCase).orElse(null));
        ((AbstractQuoteVm)entity).setRamMax(((AbstractQuoteVmEditionVo)vo).getRamMax());
        ((AbstractQuoteVm)entity).setCpuMax(((AbstractQuoteVmEditionVo)vo).getCpuMax());
        ((AbstractQuoteVm)entity).setGpuMax(((AbstractQuoteVmEditionVo)vo).getGpuMax());
        ((AbstractQuoteVm)entity).setAutoScale(((AbstractQuoteVmEditionVo)vo).isAutoScale());
        ((AbstractQuoteVm)entity).setRamRate(((AbstractQuoteVmEditionVo)vo).getRamRate());
        ((AbstractQuoteVm)entity).setCpuRate(((AbstractQuoteVmEditionVo)vo).getCpuRate());
        ((AbstractQuoteVm)entity).setGpuRate(((AbstractQuoteVmEditionVo)vo).getGpuRate());
        ((AbstractQuoteVm)entity).setNetworkRate(((AbstractQuoteVmEditionVo)vo).getNetworkRate());
        ((AbstractQuoteVm)entity).setStorageRate(((AbstractQuoteVmEditionVo)vo).getStorageRate());
        ((AbstractQuoteVm)entity).setEdge(((AbstractQuoteVmEditionVo)vo).getEdge());
        this.checkMinMax(entity);
        this.saveOrUpdateSpec(entity, vo);
        quote.setUnboundCostCounter(quote.getUnboundCostCounter() + deltaUnbound);
        HashMap storagesCosts = new HashMap();
        boolean dirtyPrice = !oldLocation.equals((Object)((AbstractQuote)entity).getResolvedLocation());
        CollectionUtils.emptyIfNull(((AbstractQuoteVm)entity).getStorages()).stream().peek(s -> {
            if (dirtyPrice) {
                this.storageResource.refresh((ProvQuoteStorage)s);
                this.storageResource.refreshCost((ProvQuoteStorage)s);
            }
        }).forEach(s -> storagesCosts.put((Integer)s.getId(), this.addCost(s, this.storageResource::updateCost)));
        UpdatedCost cost = this.newUpdateCost(entity);
        cost.getRelated().put(ResourceType.STORAGE, storagesCosts);
        super.saveOrUpdate(entity, (QuoteTagSupport)vo);
        if (BooleanUtils.isTrue((Boolean)quote.getLeanOnChange())) {
            this.budgetResource.lean(((AbstractQuoteVm)entity).getResolvedBudget(), cost.getRelated());
            if (!Objects.equals((Object)oldBudget, (Object)((AbstractQuoteVm)entity).getResolvedBudget())) {
                this.budgetResource.lean(oldBudget, cost.getRelated());
            }
        }
        return this.resource.refreshSupportCost(cost, quote);
    }

    protected abstract void saveOrUpdateSpec(C var1, E var2);

    private void checkMinMax(C entity) {
        if (((AbstractQuoteVm)entity).getMaxQuantity() != null && ((AbstractQuoteVm)entity).getMaxQuantity() < ((AbstractQuoteVm)entity).getMinQuantity()) {
            throw new ValidationJsonException("maxQuantity", (Serializable)((Object)"Min"), new Serializable[]{Integer.valueOf(((AbstractQuoteVm)entity).getMinQuantity())});
        }
    }

    @Override
    protected UpdatedCost deleteAll(int subscription) {
        ProvQuote quote = this.resource.getQuoteFromSubscription(subscription);
        List<Integer> sIds = ((BasePovInstanceBehavior)((Object)this.getQiRepository())).findAllStorageIdentifiers(quote);
        ((BasePovInstanceBehavior)((Object)this.getQiRepository())).deleteAllStorages(quote);
        this.tagResource.onDelete(ResourceType.STORAGE, sIds.toArray(new Integer[0]));
        this.networkResource.onDelete(ResourceType.STORAGE, sIds.toArray(new Integer[0]));
        this.qsRepository.flush();
        UpdatedCost cost = super.deleteAll(subscription);
        cost.getDeleted().put(ResourceType.STORAGE, sIds);
        this.budgetResource.lean(quote, cost.getRelated());
        return cost;
    }

    @Override
    protected UpdatedCost delete(int id) {
        UpdatedCost cost = new UpdatedCost(id);
        this.tagResource.onDelete(this.getType(), id);
        this.networkResource.onDelete(this.getType(), id);
        AbstractQuoteVm entity = this.deleteAndUpdateCost(this.getQiRepository(), id, i -> {
            i.getStorages().forEach(s -> {
                this.tagResource.onDelete(ResourceType.STORAGE, (Integer)s.getId());
                this.networkResource.onDelete(ResourceType.STORAGE, (Integer)s.getId());
                this.deleteAndUpdateCost(this.qsRepository, (Integer)s.getId(), e -> cost.getDeleted().computeIfAbsent(ResourceType.STORAGE, m -> new HashSet()).add((Integer)e.getId()));
            });
            ProvQuote q = i.getConfiguration();
            q.setUnboundCostCounter(q.getUnboundCostCounter() - BooleanUtils.toInteger((boolean)i.isUnboundCost()));
        });
        if (BooleanUtils.isTrue((Boolean)entity.getConfiguration().getLeanOnChange())) {
            this.budgetResource.lean(entity.getResolvedBudget(), cost.getRelated());
        }
        return this.resource.refreshSupportCost(cost, entity);
    }

    protected ProvUsage getUsage(ProvQuote configuration, String name) {
        return this.getProfileByName(configuration.getUsage(), name, configuration.getUsages(), USAGE_DEFAULT);
    }

    protected ProvBudget getBudget(ProvQuote configuration, String name) {
        return this.getProfileByName(configuration.getBudget(), name, configuration.getBudgets(), BUDGET_DEFAULT);
    }

    protected ProvOptimizer getOptimizer(ProvQuote configuration, String name) {
        return this.getProfileByName(configuration.getOptimizer(), name, configuration.getOptimizers(), OPTIMIZER_DEFAULT);
    }

    private <G extends INamableBean<?>> G getProfileByName(G quoteProfile, String name, List<G> allProfiles, G defaultProfile) {
        if (name == null) {
            return (G)((INamableBean)ObjectUtils.getIfNull(quoteProfile, defaultProfile));
        }
        return (G)allProfiles.stream().filter(u -> u.getName().equals(name)).findFirst().orElseThrow(() -> new EntityNotFoundException(name));
    }

    protected String getProcessor(ProvQuote configuration, String processor) {
        return (String)ObjectUtils.getIfNull((Object)processor, (Object)((String)ObjectUtils.getIfNull((Object)configuration.getProcessor(), (Object)"")));
    }

    protected int getType(int subscription, String code) {
        return code == null ? 0 : (Integer)this.assertFound((AbstractInstanceType)this.getItRepository().findByCode(subscription, code), code).getId();
    }

    protected double getCpu(ProvQuote configuration, QuoteVm qi) {
        return Math.max(0.5, this.getReserved(configuration, qi.getCpu(), qi.getCpuMax()));
    }

    protected double getRam(ProvQuote configuration, QuoteVm qi) {
        return Math.max(128.0, (double)((Integer)ObjectUtils.getIfNull((Object)configuration.getRamAdjustedRate(), (Object)100) * this.getReserved(configuration, qi.getRam(), qi.getRamMax())) / 100.0);
    }

    protected double getGpu(ProvQuote configuration, QuoteVm qi) {
        return Math.max(0.0, this.getReserved(configuration, qi.getGpu(), qi.getGpuMax()));
    }

    protected <N extends Number> N getReserved(ProvQuote configuration, N reserved, N max) {
        return configuration.getReservationMode() == ReservationMode.MAX && max != null ? max : reserved;
    }

    protected int getLocation(ProvQuote configuration, String location) {
        String provider = String.join((CharSequence)":", (CharSequence[])ArrayUtils.subarray((Object[])StringUtils.split((String)configuration.getSubscription().getNode().getId(), (char)':'), (int)0, (int)3));
        return location == null ? ((Integer)configuration.getLocation().getId()).intValue() : this.assertFound(this.locationRepository.toId(provider, location), location).intValue();
    }

    protected TableItem<ProvInstancePriceTerm> findPriceTerms(int subscription, @Context UriInfo uriInfo) {
        this.subscriptionResource.checkVisible(Integer.valueOf(subscription));
        return this.paginationJson.applyPagination(uriInfo, this.iptRepository.findAll(subscription, DataTableAttributes.getSearch((UriInfo)uriInfo).toUpperCase(), (Pageable)this.paginationJson.getPageRequest(uriInfo, ProvResource.ORM_COLUMNS)), Function.identity());
    }

    @Override
    protected Floating getCost(C qi) {
        return this.getCost(qi, ((AbstractQuoteVm)qi).getPrice());
    }

    protected Floating getCost(C qi, P ip) {
        double rate = this.getRate(qi, ip);
        Workload workload = Workload.from(((AbstractQuoteVm)qi).getWorkload());
        return AbstractProvQuoteVmResource.computeFloat(rate * (((AbstractPrice)((Object)ip)).getCost() + (((AbstractInstanceType)((AbstractPrice)((Object)ip)).getType()).isCustom() ? this.getCustomCost(((AbstractQuoteVm)qi).getCpu(), ((AbstractQuoteVm)qi).getGpu(), ((AbstractQuoteVm)qi).getRam(), ip) : 0.0)), rate * this.getCo2(qi, ip, workload), ((AbstractTermPrice)ip).getInitialCost(), qi);
    }

    protected double getRate(C qi, P ip) {
        if (((AbstractTermPrice)ip).getTerm().getPeriod() == 0.0) {
            return (double)this.getRate(qi) / 100.0;
        }
        return 1.0;
    }

    private double getCo2Base10(double co2b100, String co2b10, Workload workload) {
        double baseline = workload.getBaseline();
        if (baseline < 100.0 && StringUtils.isNotEmpty((CharSequence)co2b10)) {
            String[] co2Values = StringUtils.split((String)co2b10, (char)',');
            double step = 100.0 / (double)co2Values.length;
            return workload.getPeriods().stream().mapToDouble(p -> {
                int index = (int)(p.value / step);
                double baselineMin = (double)index * step;
                double co2Min = index >= co2Values.length - 1 ? co2b100 : Double.parseDouble(co2Values[index]);
                double co2Max = index >= co2Values.length - 2 ? co2b100 : Double.parseDouble(co2Values[index + 1]);
                return p.duration * (co2Min + (co2Max - co2Min) * ((p.value - baselineMin) / step)) / 100.0;
            }).sum();
        }
        return co2b100;
    }

    protected double getCo2(C qi, P ip, Workload workload) {
        double co2 = 0.0;
        co2 += this.getCo2Base10(((AbstractPrice)((Object)ip)).getCo2(), ((AbstractPrice)((Object)ip)).getCo210(), workload);
        if (((AbstractInstanceType)((AbstractPrice)((Object)ip)).getType()).isCustom()) {
            double qCpu = this.getQuantity(((AbstractQuoteVm)qi).getCpu(), ((AbstractTermPriceVm)ip).getMinCpu(), ((AbstractTermPriceVm)ip).getIncrementCpu(), 1.0);
            double qRam = this.getQuantity(((AbstractQuoteVm)qi).getRam(), ((AbstractTermPriceVm)ip).getMinRam(), ((AbstractTermPriceVm)ip).getIncrementRam(), 1024.0);
            double qGpu = this.getQuantity(((AbstractQuoteVm)qi).getGpu(), ((AbstractTermPriceVm)ip).getMinGpu(), ((AbstractTermPriceVm)ip).getIncrementGpu(), 1.0);
            co2 += this.getCo2Base10(((AbstractTermPriceVm)ip).getCo2Cpu(), ((AbstractTermPriceVm)ip).getCo2Cpu10(), workload) * qCpu;
            co2 += this.getCo2Base10(((AbstractTermPriceVm)ip).getCo2Ram(), ((AbstractTermPriceVm)ip).getCo2Ram10(), workload) * qRam;
            co2 += this.getCo2Base10(((AbstractTermPriceVm)ip).getCo2Gpu(), ((AbstractTermPriceVm)ip).getCo2Gpu10(), workload) * qGpu;
        }
        return co2;
    }

    protected int getRate(C qi) {
        return Optional.ofNullable(((AbstractQuoteVm)qi).getResolvedUsage()).map(ProvUsage::getRate).orElse(100);
    }

    protected double getCustomCost(double cpu, double gpu, int ram, P ip) {
        return this.getCustomCost(cpu, ((AbstractTermPriceVm)ip).getCostCpu(), ((AbstractTermPriceVm)ip).getMinCpu(), ((AbstractTermPriceVm)ip).getIncrementCpu(), 1.0) + this.getCustomCost(gpu, ((AbstractTermPriceVm)ip).getCostCpu(), ((AbstractTermPriceVm)ip).getMinGpu(), ((AbstractTermPriceVm)ip).getIncrementGpu(), 1.0) + this.getCustomCost(ram, ((AbstractTermPriceVm)ip).getCostRam(), ((AbstractTermPriceVm)ip).getMinRam(), ((AbstractTermPriceVm)ip).getIncrementRam(), 1024.0);
    }

    private double getCustomCost(double requested, Double cost, Double min, Double increment, double weight) {
        return this.getQuantity(requested, min, increment, weight) * Objects.requireNonNullElse(cost, 0.0);
    }

    private double getQuantity(double requested, Double min, Double increment, double weight) {
        double incrementD = Objects.requireNonNullElse(increment, 1.0);
        return Math.ceil(Math.max(Math.ceil(requested / weight), Objects.requireNonNullElse(min, 0.0)) / incrementD) * incrementD;
    }

    public static Floating computeFloat(double base, double baseCo2, Double initial, AbstractQuoteVm<?> qi) {
        Double initialR = Objects.requireNonNullElse(initial, 0.0);
        Integer maxQuantity = Objects.requireNonNullElse(qi.getMaxQuantity(), qi.getMinQuantity());
        return new Floating(base * (double)qi.getMinQuantity(), base * (double)maxQuantity.intValue(), initialR * (double)qi.getMinQuantity(), initialR * (double)maxQuantity.intValue(), qi.isUnboundCost(), baseCo2 * (double)qi.getMinQuantity(), baseCo2 * (double)maxQuantity.intValue());
    }

    private UpdatedCost newUpdateCost(C entity) {
        return this.newUpdateCost(this.getQiRepository(), entity, this::updateCost);
    }

    protected <K> String getLicense(ProvQuote configuration, String license, K key, Predicate<K> canByol) {
        String licenseR = license;
        if (license == null && canByol.test(key)) {
            licenseR = configuration.getLicense();
        }
        if ("INCLUDED".equalsIgnoreCase(licenseR)) {
            licenseR = null;
        } else if (licenseR != null) {
            licenseR = licenseR.toUpperCase(Locale.ENGLISH);
        }
        return licenseR;
    }

    public L lookupInternal(int subscription, Q query) {
        L result = this.lookup(this.getQuoteFromSubscription(subscription), query);
        if (result != null) {
            Hibernate.initialize((Object)((AbstractTermPriceVm)((AbstractLookup)result).getPrice()).getTerm());
            Hibernate.initialize(((AbstractTermPriceVm)((AbstractLookup)result).getPrice()).getType());
        }
        return result;
    }

    public L lookup(ProvQuote configuration, Q query) {
        ProvUsage usage = this.getUsage(configuration, query.getUsageName());
        double rate = (double)usage.getRate().intValue() / 100.0;
        int duration = usage.getDuration();
        int maxPeriod = (int)Math.ceil((double)duration * rate) + 12;
        long start = System.currentTimeMillis();
        boolean moreExecution = false;
        L lookup = this.lookup(configuration, query, maxPeriod, 10.0);
        if (lookup == null) {
            moreExecution = true;
            lookup = this.lookup(configuration, query, 10000, 10000.0);
        }
        log.debug("lookup {} (ext={}): {}ms - {}", new Object[]{configuration.getSubscription().getId(), moreExecution, System.currentTimeMillis() - start, query});
        return lookup;
    }

    private L lookup(ProvQuote configuration, Q query, int maxPeriod, double maxFactor) {
        Object[] dLookup;
        List<Integer> dTypes;
        String node = configuration.getSubscription().getNode().getTool().getId();
        int subscription = (Integer)configuration.getSubscription().getId();
        double ramR = this.getRam(configuration, (QuoteVm)query);
        double cpuR = this.getCpu(configuration, (QuoteVm)query);
        double gpuR = this.getGpu(configuration, (QuoteVm)query);
        String procR = this.getProcessor(configuration, query.getProcessor());
        boolean physR = this.normalize(configuration.getPhysical(), query.getPhysical());
        int locationR = this.getLocation(configuration, query.getLocationName());
        ProvUsage usage = this.getUsage(configuration, query.getUsageName());
        ProvBudget budget = this.getBudget(configuration, query.getBudgetName());
        boolean convOs = BooleanUtils.toBoolean((Boolean)usage.getConvertibleOs());
        boolean convEngine = BooleanUtils.toBoolean((Boolean)usage.getConvertibleEngine());
        boolean convType = BooleanUtils.toBoolean((Boolean)usage.getConvertibleType());
        boolean convFamily = BooleanUtils.toBoolean((Boolean)usage.getConvertibleFamily());
        boolean convLocation = BooleanUtils.toBoolean((Boolean)usage.getConvertibleLocation());
        boolean reservation = BooleanUtils.toBoolean((Boolean)usage.getReservation());
        double rate = (double)usage.getRate().intValue() / 100.0;
        Workload workload = Workload.from(query.getWorkload());
        int duration = usage.getDuration();
        double initialCost = Objects.requireNonNullElse(budget.getRemainingBudget(), budget.getInitialCost());
        double baseline = workload.getBaseline();
        double baselineR = (double)Math.round(baseline / 5.0) * 5.0;
        Optimizer optimizer = this.getOptimizer(configuration, query.getOptimizerName()).getMode();
        optimizer = optimizer == Optimizer.CO2 && this.getItRepository().hasCo2Data(node) ? optimizer : Optimizer.COST;
        int typeId = this.getType(subscription, query.getType());
        List<Integer> types = this.getItRepository().findValidTypes(node, cpuR, gpuR, ramR, cpuR * maxFactor, gpuR * maxFactor, ramR * maxFactor, baselineR, physR, typeId, procR, query.isAutoScale(), this.normalize(query.getCpuRate()), this.normalize(query.getGpuRate()), this.normalize(query.getRamRate()), this.normalize(query.getNetworkRate()), this.normalize(query.getStorageRate()), this.normalize(query.getEdge()), optimizer == Optimizer.CO2);
        List<Integer> terms = this.iptRepository.findValidTerms(node, (this.getType() == ResourceType.INSTANCE || this.getType() == ResourceType.CONTAINER || this.getType() == ResourceType.FUNCTION) && convOs, this.getType() == ResourceType.DATABASE && convEngine, convType, convFamily, convLocation, reservation, maxPeriod, query.isEphemeral(), initialCost > 0.0);
        Object[] lookup = null;
        if (!types.isEmpty()) {
            lookup = this.findLowestPrice(configuration, query, types, terms, locationR, rate, duration, initialCost, optimizer).stream().findFirst().orElse(null);
        }
        if (this.getItRepository().hasDynamicalTypes(node) && gpuR == 0.0 && !(dTypes = this.getItRepository().findDynamicTypes(node, baselineR, physR, typeId, procR, query.isAutoScale(), this.normalize(query.getCpuRate()), this.normalize(query.getGpuRate()), this.normalize(query.getRamRate()), this.normalize(query.getNetworkRate()), this.normalize(query.getStorageRate()), this.normalize(query.getEdge()), optimizer == Optimizer.CO2)).isEmpty() && ((dLookup = (Object[])this.findLowestDynamicPrice(configuration, query, dTypes, terms, cpuR, gpuR, ramR, locationR, rate, duration, initialCost, optimizer).stream().findFirst().orElse(null)) != null && lookup == null || dLookup != null && (optimizer == Optimizer.COST && this.toTotalCost(dLookup) < this.toTotalCost(lookup) || optimizer == Optimizer.CO2 && this.toTotalCo2(dLookup) < this.toTotalCo2(lookup)))) {
            lookup = dLookup;
        }
        if (lookup == null) {
            return null;
        }
        return this.newPrice(lookup);
    }

    protected abstract L newPrice(Object[] var1);

    protected abstract List<Object[]> findLowestPrice(ProvQuote var1, Q var2, List<Integer> var3, List<Integer> var4, int var5, double var6, double var8, double var10, Optimizer var12);

    protected abstract List<Object[]> findLowestDynamicPrice(ProvQuote var1, Q var2, List<Integer> var3, List<Integer> var4, double var5, double var7, double var9, int var11, double var12, int var14, double var15, Optimizer var17);

    @Override
    public Floating refresh(C qi) {
        ((AbstractQuote)qi).setPrice(this.validateLookup(qi));
        return this.updateCost(qi);
    }

    public FloatingPrice<P> getNewPrice(C qi) {
        P price = this.validateLookup(qi);
        return new FloatingPrice<P>(this.getCost(qi, price), price);
    }

    private P validateLookup(C qi) {
        return (P)((AbstractTermPriceVm)this.validateLookup(this.getType().name().toLowerCase(), this.lookup(((AbstractQuote)qi).getConfiguration(), qi), qi.getName()));
    }

    protected double toTotalCost(Object[] lookup) {
        return (Double)lookup[1];
    }

    protected double toTotalCo2(Object[] lookup) {
        return (Double)lookup[3];
    }

    protected ProvisioningService getService(ProvQuote configuration) {
        return Objects.requireNonNullElseGet(configuration.getService(), () -> {
            configuration.setService((ProvisioningService)this.locator.getResource(configuration.getSubscription().getNode().getId(), ProvisioningService.class));
            return configuration.getService();
        });
    }

    protected TableItem<T> findAllTypes(int subscription, UriInfo uriInfo) {
        this.subscriptionResource.checkVisible(Integer.valueOf(subscription));
        return this.paginationJson.applyPagination(uriInfo, this.getItRepository().findAll(subscription, DataTableAttributes.getSearch((UriInfo)uriInfo).toUpperCase(), (Pageable)this.paginationJson.getPageRequest(uriInfo, ProvResource.ORM_COLUMNS)), Function.identity());
    }
}

