/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov;

import jakarta.transaction.Transactional;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.hibernate.Hibernate;
import org.ligoj.app.plugin.prov.Floating;
import org.ligoj.app.plugin.prov.ProvBudgetResource;
import org.ligoj.app.plugin.prov.ProvResource;
import org.ligoj.app.plugin.prov.UpdatedCost;
import org.ligoj.app.plugin.prov.dao.BaseMultiScopedRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteContainerRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteDatabaseRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteFunctionRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteInstanceRepository;
import org.ligoj.app.plugin.prov.dao.ProvQuoteStorageRepository;
import org.ligoj.app.plugin.prov.model.AbstractInstanceType;
import org.ligoj.app.plugin.prov.model.AbstractMultiScoped;
import org.ligoj.app.plugin.prov.model.AbstractQuoteVm;
import org.ligoj.app.plugin.prov.model.AbstractTermPriceVm;
import org.ligoj.app.plugin.prov.model.ProvQuote;
import org.ligoj.app.plugin.prov.model.ProvQuoteContainer;
import org.ligoj.app.plugin.prov.model.ProvQuoteDatabase;
import org.ligoj.app.plugin.prov.model.ProvQuoteFunction;
import org.ligoj.app.plugin.prov.model.ProvQuoteInstance;
import org.ligoj.app.plugin.prov.model.ResourceScope;
import org.ligoj.app.plugin.prov.model.ResourceType;
import org.ligoj.app.plugin.prov.quote.container.ProvQuoteContainerResource;
import org.ligoj.app.plugin.prov.quote.database.ProvQuoteDatabaseResource;
import org.ligoj.app.plugin.prov.quote.function.ProvQuoteFunctionResource;
import org.ligoj.app.plugin.prov.quote.instance.ProvQuoteInstanceResource;
import org.ligoj.app.plugin.prov.quote.storage.ProvQuoteStorageResource;
import org.ligoj.app.resource.subscription.SubscriptionResource;
import org.ligoj.bootstrap.core.NamedBean;
import org.ligoj.bootstrap.core.json.PaginationJson;
import org.ligoj.bootstrap.core.json.TableItem;
import org.ligoj.bootstrap.core.json.datatable.DataTableAttributes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;

@Transactional
public abstract class AbstractMultiScopedResource<S extends AbstractMultiScoped, R extends BaseMultiScopedRepository<S>, V extends NamedBean<Integer>> {
    @Autowired
    protected SubscriptionResource subscriptionResource;
    @Autowired
    protected PaginationJson paginationJson;
    @Autowired
    protected ProvResource resource;
    @Autowired
    protected ProvQuoteInstanceResource qiResource;
    @Autowired
    protected ProvQuoteStorageResource qsResource;
    @Autowired
    protected ProvQuoteDatabaseResource qbResource;
    @Autowired
    protected ProvQuoteContainerResource qcResource;
    @Autowired
    protected ProvQuoteFunctionResource qfResource;
    @Autowired
    protected ProvQuoteInstanceRepository qiRepository;
    @Autowired
    protected ProvQuoteDatabaseRepository qbRepository;
    @Autowired
    protected ProvQuoteContainerRepository qcRepository;
    @Autowired
    protected ProvQuoteFunctionRepository qfRepository;
    @Autowired
    protected ProvQuoteStorageRepository qsRepository;
    @Autowired
    protected ProvBudgetResource bResource;
    private final Function<ResourceScope, S> quoteGetter;
    private final BiConsumer<ResourceScope, S> quoteSetter;
    private final Supplier<S> newEntity;
    private final Function<ProvQuote, List<S>> allProfiles;

    protected AbstractMultiScopedResource(Function<ResourceScope, S> quoteGetter, BiConsumer<ResourceScope, S> quoteSetter, Supplier<S> newEntity, Function<ProvQuote, List<S>> allProfiles) {
        this.quoteGetter = quoteGetter;
        this.quoteSetter = quoteSetter;
        this.newEntity = newEntity;
        this.allProfiles = allProfiles;
    }

    protected abstract R getRepository();

    @GET
    @Consumes(value={"application/json"})
    public TableItem<S> findAll(@PathParam(value="subscription") int subscription, @Context UriInfo uriInfo) {
        this.subscriptionResource.checkVisible(Integer.valueOf(subscription));
        return this.paginationJson.applyPagination(uriInfo, this.getRepository().findAll(subscription, DataTableAttributes.getSearch((UriInfo)uriInfo).toUpperCase(), (Pageable)this.paginationJson.getPageRequest(uriInfo, ProvResource.ORM_COLUMNS)), Function.identity());
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="{id:\\d+}")
    public UpdatedCost delete(@PathParam(value="subscription") int subscription, @PathParam(value="id") int id) {
        AbstractMultiScoped entity = (AbstractMultiScoped)((Object)this.resource.findConfigured(this.getRepository(), id, subscription));
        ProvQuote quote = entity.getConfiguration();
        UpdatedCost cost = new UpdatedCost((Integer)entity.getId());
        List<ProvQuoteInstance> instances = this.getRelated(arg_0 -> this.getRepository().findRelatedInstances(arg_0), entity);
        List<ProvQuoteDatabase> databases = this.getRelated(arg_0 -> this.getRepository().findRelatedDatabases(arg_0), entity);
        List<ProvQuoteContainer> containers = this.getRelated(arg_0 -> this.getRepository().findRelatedContainers(arg_0), entity);
        List<ProvQuoteFunction> functions = this.getRelated(arg_0 -> this.getRepository().findRelatedFunctions(arg_0), entity);
        if (entity.equals(this.quoteGetter.apply(quote))) {
            this.quoteSetter.accept(quote, null);
        }
        Stream.of(instances, databases, containers, functions).forEach(l -> l.forEach(i -> this.quoteSetter.accept((ResourceScope)i, (S)null)));
        this.bResource.lean(quote, instances, databases, containers, functions, List.of(), cost.getRelated());
        this.getRepository().delete((Object)entity);
        return this.resource.refreshSupportCost(cost, quote);
    }

    protected <T extends AbstractInstanceType, P extends AbstractTermPriceVm<T>, C extends AbstractQuoteVm<P>> Stream<C> getRelatedStream(Function<S, Stream<C>> fetcher, S entity) {
        return fetcher.apply(entity);
    }

    protected <T extends AbstractInstanceType, P extends AbstractTermPriceVm<T>, C extends AbstractQuoteVm<P>> List<C> getRelated(Function<S, Stream<C>> fetcher, S entity) {
        return this.getRelatedStream(fetcher, entity).toList();
    }

    @POST
    @Consumes(value={"application/json"})
    public int create(@PathParam(value="subscription") int subscription, V vo) {
        AbstractMultiScoped entity = (AbstractMultiScoped)((Object)this.newEntity.get());
        entity.setConfiguration(this.resource.getQuoteFromSubscription(subscription));
        return this.saveOrUpdate(entity, vo).getId();
    }

    @PUT
    @Consumes(value={"application/json"})
    public UpdatedCost update(@PathParam(value="subscription") int subscription, V vo) {
        return this.saveOrUpdate((AbstractMultiScoped)((Object)this.resource.findConfigured(this.getRepository(), (Integer)vo.getId(), subscription)), vo);
    }

    protected abstract UpdatedCost saveOrUpdate(S var1, V var2);

    protected UpdatedCost saveOrUpdateInternal(S entity, V vo) {
        entity.setName(vo.getName());
        ProvQuote quote = ((AbstractMultiScoped)((Object)entity)).getConfiguration();
        Hibernate.initialize(quote.getUsages());
        Hibernate.initialize(quote.getBudgets());
        Hibernate.initialize(this.allProfiles.apply(quote));
        Map<ResourceType, Map<Integer, Floating>> relatedCosts = Collections.synchronizedMap(new EnumMap(ResourceType.class));
        if (entity.getId() != null) {
            List<ProvQuoteInstance> instances = this.getRelated(arg_0 -> this.getRepository().findRelatedInstances(arg_0), entity);
            List<ProvQuoteDatabase> databases = this.getRelated(arg_0 -> this.getRepository().findRelatedDatabases(arg_0), entity);
            List<ProvQuoteContainer> containers = this.getRelated(arg_0 -> this.getRepository().findRelatedContainers(arg_0), entity);
            List<ProvQuoteFunction> functions = this.getRelated(arg_0 -> this.getRepository().findRelatedFunctions(arg_0), entity);
            this.bResource.lean(quote, instances, databases, containers, functions, List.of(), relatedCosts);
        }
        this.getRepository().saveAndFlush(entity);
        UpdatedCost cost = new UpdatedCost((Integer)entity.getId());
        cost.setRelated(relatedCosts);
        return this.resource.refreshSupportCost(cost, quote);
    }
}

