/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.prov;

import java.io.Serializable;
import java.util.function.Consumer;
import lombok.Generated;
import org.ligoj.app.plugin.prov.AbstractLookup;
import org.ligoj.app.plugin.prov.Floating;
import org.ligoj.app.plugin.prov.ProvResource;
import org.ligoj.app.plugin.prov.QuoteRelated;
import org.ligoj.app.plugin.prov.dao.ProvQuoteRepository;
import org.ligoj.app.plugin.prov.model.AbstractCodedEntity;
import org.ligoj.app.plugin.prov.model.AbstractPrice;
import org.ligoj.app.plugin.prov.model.AbstractQuote;
import org.ligoj.app.resource.subscription.SubscriptionResource;
import org.ligoj.bootstrap.core.dao.RestRepository;
import org.ligoj.bootstrap.core.json.PaginationJson;
import org.ligoj.bootstrap.core.validation.ValidationJsonException;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractCostedResource<T extends AbstractCodedEntity, P extends AbstractPrice<T>, C extends AbstractQuote<P>>
implements QuoteRelated<C> {
    @Autowired
    protected PaginationJson paginationJson;
    @Autowired
    protected SubscriptionResource subscriptionResource;
    @Autowired
    private ProvQuoteRepository repository;
    @Autowired
    protected ProvResource resource;

    public P validateLookup(String resourceType, AbstractLookup<P> lookup, String context) {
        if (lookup == null) {
            throw new ValidationJsonException(resourceType, (Serializable)((Object)("no-match-" + resourceType)), new Serializable[]{"resource", context});
        }
        return lookup.getPrice();
    }

    protected <Q extends AbstractQuote<?>> Q deleteAndUpdateCost(RestRepository<Q, Integer> repository, Integer id, Consumer<Q> callback) {
        AbstractQuote entity = (AbstractQuote)this.resource.findConfigured(repository, id);
        this.addCost(entity, (T e) -> {
            e.setCost(0.0);
            e.setMaxCost(0.0);
            e.setCo2(0.0);
            e.setMaxCo2(0.0);
            e.setInitialCost(0.0);
            e.setMaxInitialCost(0.0);
            return new Floating();
        });
        callback.accept(entity);
        repository.deleteById((Object)id);
        return (Q)entity;
    }

    public Floating updateCost(C qr) {
        return this.updateCost(qr, this::getCost);
    }

    protected abstract Floating getCost(C var1);

    @Override
    @Generated
    public SubscriptionResource getSubscriptionResource() {
        return this.subscriptionResource;
    }

    @Override
    @Generated
    public ProvQuoteRepository getRepository() {
        return this.repository;
    }
}

