/*
 * Decompiled with CFR 0.152.
 */
package net.jnellis.binpack.packing;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Optional;
import net.jnellis.binpack.Bin;
import net.jnellis.binpack.packing.PackingPolicy;

public class AlmostWorstFit<P extends Comparable<P>, C extends Comparable<C>, B extends Bin<P, C>>
implements PackingPolicy<P, C, B> {
    @Override
    public Optional<B> chooseBin(P piece, List<B> existingBins) {
        if (existingBins.size() < 2) {
            return Optional.empty();
        }
        Bin firstBin = (Bin)existingBins.get(0);
        Bin[] min2 = (Bin[])Array.newInstance(firstBin.getClass(), 2);
        existingBins.stream().filter(this.binsThatCanFit(piece)).forEach(bin -> this.updateMin2(min2, (Bin)bin));
        return Optional.ofNullable(min2[1]);
    }

    private void updateMin2(B[] min2, B bin) {
        if (min2[0] == null || bin.compareTo(min2[0]) > 0) {
            min2[1] = min2[0];
            min2[0] = bin;
        } else if (min2[1] == null || bin.compareTo(min2[1]) > 0) {
            min2[1] = bin;
        }
    }
}

